/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo;

import com.netflix.fenzo.ActiveVmGroups;
import com.netflix.fenzo.AssignableVMs;
import com.netflix.fenzo.AutoScaleAction;
import com.netflix.fenzo.AutoScaleRule;
import com.netflix.fenzo.AutoScaleRules;
import com.netflix.fenzo.AutoScalerInput;
import com.netflix.fenzo.NaiveShortfallEvaluator;
import com.netflix.fenzo.OptimizingShortfallEvaluator;
import com.netflix.fenzo.ScaleDownAction;
import com.netflix.fenzo.ScaleDownConstraintExecutor;
import com.netflix.fenzo.ScaleUpAction;
import com.netflix.fenzo.ShortfallEvaluator;
import com.netflix.fenzo.TaskSchedulingService;
import com.netflix.fenzo.VMCollection;
import com.netflix.fenzo.VirtualMachineLease;
import com.netflix.fenzo.functions.Action1;
import com.netflix.fenzo.functions.Func1;
import com.netflix.fenzo.queues.QueuableTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.mesos.Protos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AutoScaler {
    private static final Logger logger = LoggerFactory.getLogger(AutoScaler.class);
    final VMCollection vmCollection;
    private final String mapHostnameAttributeName;
    private final String scaleDownBalancedByAttributeName;
    private final ActiveVmGroups activeVmGroups;
    private final AutoScaleRules autoScaleRules;
    private final boolean disableShortfallEvaluation;
    private final String attributeName;
    private final AssignableVMs assignableVMs;
    private final ExecutorService executor = new ThreadPoolExecutor(1, 1, Long.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(10), new ThreadPoolExecutor.DiscardPolicy());
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final ConcurrentMap<String, ScalingActivity> scalingActivityMap = new ConcurrentHashMap<String, ScalingActivity>();
    private final ScaleDownConstraintExecutor scaleDownConstraintExecutor;
    private volatile Action1<AutoScaleAction> callback = null;
    private ShortfallEvaluator shortfallEvaluator;
    private long delayScaleUpBySecs = 0L;
    private long delayScaleDownBySecs = 0L;
    private long disabledVmDurationInSecs = 0L;
    private volatile Func1<QueuableTask, List<String>> taskToClustersGetter = null;

    AutoScaler(String attributeName, String mapHostnameAttributeName, String scaleDownBalancedByAttributeName, List<AutoScaleRule> autoScaleRules, AssignableVMs assignableVMs, boolean disableShortfallEvaluation, ActiveVmGroups activeVmGroups, VMCollection vmCollection, ScaleDownConstraintExecutor scaleDownConstraintExecutor) {
        this.mapHostnameAttributeName = mapHostnameAttributeName;
        this.scaleDownBalancedByAttributeName = scaleDownBalancedByAttributeName;
        this.shortfallEvaluator = new NaiveShortfallEvaluator();
        this.attributeName = attributeName;
        this.autoScaleRules = new AutoScaleRules(autoScaleRules);
        this.assignableVMs = assignableVMs;
        this.disableShortfallEvaluation = disableShortfallEvaluation;
        this.activeVmGroups = activeVmGroups;
        this.vmCollection = vmCollection;
        this.scaleDownConstraintExecutor = scaleDownConstraintExecutor;
    }

    void useOptimizingShortfallAnalyzer() {
        this.shortfallEvaluator = new OptimizingShortfallEvaluator();
    }

    void setSchedulingService(TaskSchedulingService service) {
        this.shortfallEvaluator.setTaskSchedulingService(service);
    }

    Collection<AutoScaleRule> getRules() {
        return Collections.unmodifiableCollection(this.autoScaleRules.getRules());
    }

    void replaceRule(AutoScaleRule rule) {
        if (rule == null) {
            throw new NullPointerException("Can't add null rule");
        }
        this.autoScaleRules.replaceRule(rule);
    }

    AutoScaleRule getRule(String name) {
        return this.autoScaleRules.get(name);
    }

    void removeRule(String ruleName) {
        if (ruleName != null) {
            this.autoScaleRules.remRule(ruleName);
        }
    }

    void setDelayScaleUpBySecs(long secs) {
        this.delayScaleUpBySecs = secs;
    }

    void setDelayScaleDownBySecs(long secs) {
        this.delayScaleDownBySecs = secs;
    }

    void setDisabledVmDurationInSecs(long disabledVmDurationInSecs) {
        this.disabledVmDurationInSecs = disabledVmDurationInSecs;
    }

    void setTaskToClustersGetter(Func1<QueuableTask, List<String>> getter) {
        this.taskToClustersGetter = getter;
    }

    void doAutoscale(AutoScalerInput autoScalerInput) {
        if (this.isShutdown.get()) {
            return;
        }
        try {
            this.shortfallEvaluator.setTaskToClustersGetter(this.taskToClustersGetter);
            this.autoScaleRules.prepare();
            Map<String, HostAttributeGroup> hostAttributeGroupMap = this.setupHostAttributeGroupMap(this.autoScaleRules, this.scalingActivityMap);
            if (!this.disableShortfallEvaluation) {
                Map<String, Integer> shortfall = this.shortfallEvaluator.getShortfall(hostAttributeGroupMap.keySet(), autoScalerInput.getFailures(), this.autoScaleRules);
                for (Map.Entry entry : shortfall.entrySet()) {
                    hostAttributeGroupMap.get(entry.getKey()).shortFall = entry.getValue() == null ? 0 : (Integer)entry.getValue();
                }
            }
            this.populateIdleResources(autoScalerInput.getIdleResourcesList(), autoScalerInput.getIdleInactiveResourceList(), hostAttributeGroupMap);
            ArrayList<Runnable> callbacks = new ArrayList<Runnable>();
            for (HostAttributeGroup hostAttributeGroup : hostAttributeGroupMap.values()) {
                callbacks.addAll(this.processScalingNeeds(hostAttributeGroup, this.scalingActivityMap, this.assignableVMs));
            }
            this.executor.submit(() -> {
                if (this.isShutdown.get()) {
                    return;
                }
                for (Runnable callback : callbacks) {
                    callback.run();
                }
            });
        }
        catch (Exception e) {
            logger.error("Autoscaler failure: ", (Throwable)e);
        }
    }

    private boolean shouldScaleNow(boolean scaleUp, long now, ScalingActivity prevScalingActivity, AutoScaleRule rule) {
        return scaleUp ? now > Math.max(this.activeVmGroups.getLastSetAt(), prevScalingActivity.scaleUpAt) + rule.getCoolDownSecs() * 1000L : now > Math.max(this.activeVmGroups.getLastSetAt(), Math.max(prevScalingActivity.scaleDownAt, prevScalingActivity.scaleUpAt)) + rule.getCoolDownSecs() * 1000L;
    }

    private boolean shouldScaleUp(long now, ScalingActivity prevScalingActivity, AutoScaleRule rule) {
        return this.shouldScaleNow(true, now, prevScalingActivity, rule);
    }

    private boolean shouldScaleDown(long now, ScalingActivity prevScalingActivity, AutoScaleRule rule) {
        return this.shouldScaleNow(false, now, prevScalingActivity, rule);
    }

    private boolean shouldScaleDownInactive(long now, ScalingActivity prevScalingActivity, AutoScaleRule rule) {
        return now > Math.max(this.activeVmGroups.getLastSetAt(), prevScalingActivity.inactiveScaleDownAt) + rule.getCoolDownSecs() * 1000L;
    }

    private List<Runnable> processScalingNeeds(HostAttributeGroup hostAttributeGroup, ConcurrentMap<String, ScalingActivity> scalingActivityMap, AssignableVMs assignableVMs) {
        long lastReqstAge;
        ScalingActivity scalingActivity;
        ArrayList<Runnable> callbacks = new ArrayList<Runnable>();
        AutoScaleRule rule = hostAttributeGroup.rule;
        long now = System.currentTimeMillis();
        ScalingActivity prevScalingActivity = (ScalingActivity)scalingActivityMap.get(rule.getRuleName());
        int excess = hostAttributeGroup.shortFall > 0 ? 0 : hostAttributeGroup.idleHosts.size() - rule.getMaxIdleHostsToKeep();
        int inactiveIdleCount = hostAttributeGroup.idleInactiveHosts.size();
        ArrayList<String> allHostsToTerminate = new ArrayList<String>();
        if (inactiveIdleCount > 0 && this.shouldScaleDownInactive(now, prevScalingActivity, rule)) {
            scalingActivity = (ScalingActivity)scalingActivityMap.get(rule.getRuleName());
            lastReqstAge = (now - scalingActivity.inactiveScaleDownRequestedAt) / 1000L;
            if (this.delayScaleDownBySecs > 0L && lastReqstAge > 2L * this.delayScaleDownBySecs) {
                scalingActivity.inactiveScaleDownRequestedAt = now;
            } else if (this.delayScaleDownBySecs == 0L || lastReqstAge > this.delayScaleDownBySecs) {
                scalingActivity.inactiveScaleDownRequestedAt = 0L;
                scalingActivity.inactiveScaleDownAt = now;
                Map<String, String> hostsToTerminate = this.getInactiveHostsToTerminate(hostAttributeGroup.idleInactiveHosts);
                if (logger.isDebugEnabled()) {
                    logger.debug("{} has an excess of {} inactive hosts ({})", new Object[]{rule.getRuleName(), hostsToTerminate.size(), String.join((CharSequence)", ", hostsToTerminate.keySet())});
                }
                allHostsToTerminate.addAll(hostsToTerminate.values());
            }
        }
        if (excess > 0 && this.shouldScaleDown(now, prevScalingActivity, rule)) {
            scalingActivity = (ScalingActivity)scalingActivityMap.get(rule.getRuleName());
            lastReqstAge = (now - scalingActivity.scaleDownRequestedAt) / 1000L;
            if (this.delayScaleDownBySecs > 0L && lastReqstAge > 2L * this.delayScaleDownBySecs) {
                scalingActivity.scaleDownRequestedAt = now;
            } else if (this.delayScaleDownBySecs == 0L || lastReqstAge > this.delayScaleDownBySecs) {
                int size = this.vmCollection.size(rule.getRuleName());
                if (rule.getMinSize() > size - excess) {
                    excess = Math.max(0, size - rule.getMinSize());
                }
                if (excess > 0) {
                    scalingActivity.scaleDownRequestedAt = 0L;
                    scalingActivity.scaleDownAt = now;
                    scalingActivity.shortfall = hostAttributeGroup.shortFall;
                    Map<String, String> hostsToTerminate = this.getHostsToTerminate(hostAttributeGroup.idleHosts, excess);
                    scalingActivity.scaledNumInstances = hostsToTerminate.size();
                    scalingActivity.type = AutoScaleAction.Type.Down;
                    for (String host : hostsToTerminate.keySet()) {
                        long disabledDurationInSecs = Math.max(this.disabledVmDurationInSecs, rule.getCoolDownSecs());
                        assignableVMs.disableUntil(host, now + disabledDurationInSecs * 1000L);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("{} has an excess of {} hosts ({})", new Object[]{rule.getRuleName(), hostsToTerminate.size(), String.join((CharSequence)", ", hostsToTerminate.keySet())});
                    }
                    allHostsToTerminate.addAll(hostsToTerminate.values());
                }
            }
        } else if ((hostAttributeGroup.shortFall > 0 || excess <= 0 && this.shouldScaleUp(now, prevScalingActivity, rule)) && (hostAttributeGroup.shortFall > 0 || rule.getMinIdleHostsToKeep() > hostAttributeGroup.idleHosts.size())) {
            scalingActivity = (ScalingActivity)scalingActivityMap.get(rule.getRuleName());
            lastReqstAge = (now - scalingActivity.scaleUpRequestedAt) / 1000L;
            if (this.delayScaleUpBySecs > 0L && lastReqstAge > 2L * this.delayScaleUpBySecs) {
                scalingActivity.scaleUpRequestedAt = now;
            } else if (this.delayScaleUpBySecs == 0L || lastReqstAge > this.delayScaleUpBySecs) {
                int size;
                int shortage = excess <= 0 && this.shouldScaleUp(now, prevScalingActivity, rule) ? rule.getMaxIdleHostsToKeep() - hostAttributeGroup.idleHosts.size() : 0;
                if ((shortage = Math.max(shortage, hostAttributeGroup.shortFall)) + (size = this.vmCollection.size(rule.getRuleName())) > rule.getMaxSize()) {
                    shortage = Math.max(0, rule.getMaxSize() - size);
                }
                if (shortage > 0) {
                    scalingActivity.scaleUpRequestedAt = 0L;
                    scalingActivity.scaleUpAt = now;
                    scalingActivity.shortfall = hostAttributeGroup.shortFall;
                    scalingActivity.scaledNumInstances = shortage;
                    scalingActivity.type = AutoScaleAction.Type.Up;
                    int finalShortage = shortage;
                    logger.debug("{} has a shortage of {} hosts", (Object)rule.getRuleName(), (Object)finalShortage);
                    callbacks.add(() -> {
                        logger.debug("Executing callback to scale up {} by {} hosts", (Object)rule.getRuleName(), (Object)finalShortage);
                        this.callback.call(new ScaleUpAction(rule.getRuleName(), finalShortage));
                    });
                }
            }
        }
        if (!allHostsToTerminate.isEmpty()) {
            callbacks.add(() -> {
                if (logger.isDebugEnabled()) {
                    logger.debug("Executing callback to scale down {} by {} hosts ({})", new Object[]{rule.getRuleName(), allHostsToTerminate.size(), String.join((CharSequence)", ", allHostsToTerminate)});
                }
                this.callback.call(new ScaleDownAction(rule.getRuleName(), allHostsToTerminate));
            });
        }
        return callbacks;
    }

    private void populateIdleResources(List<VirtualMachineLease> idleResources, List<VirtualMachineLease> idleInactiveResources, Map<String, HostAttributeGroup> leasesMap) {
        for (VirtualMachineLease l : idleResources) {
            this.getAttribute(l).ifPresent(attrValue -> {
                if (leasesMap.containsKey(attrValue) && !((HostAttributeGroup)leasesMap.get((Object)attrValue)).rule.idleMachineTooSmall(l)) {
                    ((HostAttributeGroup)leasesMap.get((Object)attrValue)).idleHosts.add(l);
                }
            });
        }
        for (VirtualMachineLease l : idleInactiveResources) {
            this.getAttribute(l).ifPresent(attrValue -> {
                if (leasesMap.containsKey(attrValue)) {
                    ((HostAttributeGroup)leasesMap.get((Object)attrValue)).idleInactiveHosts.add(l);
                }
            });
        }
    }

    private Optional<String> getAttribute(VirtualMachineLease lease) {
        boolean hasValue = lease.getAttributeMap() != null && lease.getAttributeMap().get(this.attributeName) != null && lease.getAttributeMap().get(this.attributeName).getText().hasValue();
        return hasValue ? Optional.of(lease.getAttributeMap().get(this.attributeName).getText().getValue()) : Optional.empty();
    }

    private Map<String, HostAttributeGroup> setupHostAttributeGroupMap(AutoScaleRules autoScaleRules, ConcurrentMap<String, ScalingActivity> lastScalingAt) {
        HashMap<String, HostAttributeGroup> leasesMap = new HashMap<String, HostAttributeGroup>();
        for (AutoScaleRule rule : autoScaleRules.getRules()) {
            leasesMap.put(rule.getRuleName(), new HostAttributeGroup(rule.getRuleName(), rule));
            long initialCoolDown = this.getInitialCoolDown(rule.getCoolDownSecs());
            lastScalingAt.putIfAbsent(rule.getRuleName(), new ScalingActivity(initialCoolDown, initialCoolDown, 0, 0, null));
        }
        return leasesMap;
    }

    private long getInitialCoolDown(long coolDownSecs) {
        long initialCoolDownInPastSecs = 120L;
        initialCoolDownInPastSecs = Math.min(coolDownSecs, initialCoolDownInPastSecs);
        return System.currentTimeMillis() - coolDownSecs * 1000L + initialCoolDownInPastSecs * 1000L;
    }

    private Map<String, String> getHostsToTerminate(List<VirtualMachineLease> idleHosts, int excess) {
        if (this.scaleDownConstraintExecutor == null) {
            return idleHosts.isEmpty() ? Collections.emptyMap() : this.getHostsToTerminateLegacy(idleHosts, excess);
        }
        return this.getHostsToTerminateUsingCriteria(idleHosts, excess);
    }

    private Map<String, String> getInactiveHostsToTerminate(List<VirtualMachineLease> inactiveIdleHosts) {
        if (this.scaleDownConstraintExecutor == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> hostsMap = new HashMap<String, String>();
        List<VirtualMachineLease> result = this.scaleDownConstraintExecutor.evaluate(inactiveIdleHosts);
        result.forEach(lease -> hostsMap.put(lease.hostname(), this.getMappedHostname((VirtualMachineLease)lease)));
        return hostsMap;
    }

    private Map<String, String> getHostsToTerminateUsingCriteria(List<VirtualMachineLease> idleHosts, int excess) {
        HashMap<String, String> hostsMap = new HashMap<String, String>();
        ArrayList<VirtualMachineLease> allIdle = new ArrayList<VirtualMachineLease>(idleHosts);
        List<VirtualMachineLease> result = this.scaleDownConstraintExecutor.evaluate(allIdle);
        Set activeIds = idleHosts.stream().map(VirtualMachineLease::hostname).collect(Collectors.toSet());
        int activeCounter = 0;
        Iterator<VirtualMachineLease> it = result.iterator();
        while (it.hasNext()) {
            VirtualMachineLease leaseToRemove = it.next();
            if (!activeIds.contains(leaseToRemove.hostname())) continue;
            if (activeCounter < excess) {
                ++activeCounter;
                continue;
            }
            it.remove();
        }
        result.forEach(lease -> hostsMap.put(lease.hostname(), this.getMappedHostname((VirtualMachineLease)lease)));
        return hostsMap;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, String> getHostsToTerminateLegacy(List<VirtualMachineLease> hosts, int excess) {
        void var7_10;
        HashMap<String, String> result = new HashMap<String, String>();
        HashMap hostsMap = new HashMap();
        String defaultAttributeName = "default";
        for (VirtualMachineLease virtualMachineLease : hosts) {
            String val;
            Protos.Attribute attribute = virtualMachineLease.getAttributeMap().get(this.scaleDownBalancedByAttributeName);
            String string = val = attribute != null && attribute.hasText() ? attribute.getText().getValue() : "default";
            if (hostsMap.get(val) == null) {
                hostsMap.put(val, new ArrayList());
            }
            ((List)hostsMap.get(val)).add(virtualMachineLease);
        }
        ArrayList<List> lists = new ArrayList<List>();
        for (List l : hostsMap.values()) {
            lists.add(l);
        }
        boolean bl = false;
        while (var7_10 < excess) {
            List takeFrom = null;
            int max = 0;
            for (List l : lists) {
                if (l.size() <= max) continue;
                max = l.size();
                takeFrom = l;
            }
            VirtualMachineLease removed = (VirtualMachineLease)takeFrom.remove(0);
            result.put(removed.hostname(), this.getMappedHostname(removed));
            ++var7_10;
        }
        return result;
    }

    private String getMappedHostname(VirtualMachineLease lease) {
        if (this.mapHostnameAttributeName == null || this.mapHostnameAttributeName.isEmpty()) {
            return lease.hostname();
        }
        Protos.Attribute attribute = lease.getAttributeMap().get(this.mapHostnameAttributeName);
        if (attribute == null) {
            logger.error("Didn't find attribute " + this.mapHostnameAttributeName + " for host " + lease.hostname());
            return lease.hostname();
        }
        return attribute.getText().getValue();
    }

    public void setCallback(Action1<AutoScaleAction> callback) {
        this.callback = callback;
    }

    void shutdown() {
        if (this.isShutdown.compareAndSet(false, true)) {
            this.executor.shutdown();
        }
    }

    private static class ScalingActivity {
        private long scaleUpAt;
        private long scaleUpRequestedAt;
        private long scaleDownAt;
        private long scaleDownRequestedAt;
        private long inactiveScaleDownAt;
        private long inactiveScaleDownRequestedAt;
        private int shortfall;
        private int scaledNumInstances;
        private AutoScaleAction.Type type;

        private ScalingActivity(long scaleUpAt, long scaleDownAt, int shortfall, int scaledNumInstances, AutoScaleAction.Type type) {
            this.scaleUpAt = scaleUpAt;
            this.scaleUpRequestedAt = 0L;
            this.scaleDownAt = scaleDownAt;
            this.scaleDownRequestedAt = 0L;
            this.shortfall = shortfall;
            this.scaledNumInstances = scaledNumInstances;
            this.type = type;
        }
    }

    private static class HostAttributeGroup {
        String name;
        List<VirtualMachineLease> idleHosts;
        List<VirtualMachineLease> idleInactiveHosts;
        int shortFall;
        AutoScaleRule rule;

        private HostAttributeGroup(String name, AutoScaleRule rule) {
            this.name = name;
            this.rule = rule;
            this.idleHosts = new ArrayList<VirtualMachineLease>();
            this.idleInactiveHosts = new ArrayList<VirtualMachineLease>();
            this.shortFall = 0;
        }
    }
}

