/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.scheduler.mesos;

import com.google.common.util.concurrent.AbstractScheduledService;
import com.google.protobuf.ByteString;
import com.netflix.fenzo.TaskAssignmentResult;
import com.netflix.fenzo.TaskRequest;
import com.netflix.fenzo.TaskScheduler;
import com.netflix.fenzo.VMAssignmentResult;
import com.netflix.fenzo.VirtualMachineLease;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.mesos.Protos;
import org.apache.mesos.SchedulerDriver;
import org.apache.shardingsphere.elasticjob.cloud.config.CloudJobConfiguration;
import org.apache.shardingsphere.elasticjob.cloud.config.CloudJobExecutionType;
import org.apache.shardingsphere.elasticjob.cloud.config.pojo.CloudJobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.config.app.pojo.CloudAppConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.env.BootstrapEnvironment;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.mesos.AppConstraintEvaluator;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.mesos.FacadeService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.mesos.LaunchingTasks;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.mesos.LeasesQueue;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.mesos.SupportedExtractionType;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.mesos.TaskInfoData;
import org.apache.shardingsphere.elasticjob.infra.context.ExecutionType;
import org.apache.shardingsphere.elasticjob.infra.context.ShardingItemParameters;
import org.apache.shardingsphere.elasticjob.infra.context.TaskContext;
import org.apache.shardingsphere.elasticjob.infra.json.GsonFactory;
import org.apache.shardingsphere.elasticjob.infra.listener.ShardingContexts;
import org.apache.shardingsphere.elasticjob.tracing.JobTracingEventBus;
import org.apache.shardingsphere.elasticjob.tracing.event.JobEvent;
import org.apache.shardingsphere.elasticjob.tracing.event.JobStatusTraceEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TaskLaunchScheduledService
extends AbstractScheduledService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskLaunchScheduledService.class);
    private final SchedulerDriver schedulerDriver;
    private final TaskScheduler taskScheduler;
    private final FacadeService facadeService;
    private final JobTracingEventBus jobTracingEventBus;
    private final BootstrapEnvironment env = BootstrapEnvironment.getINSTANCE();

    protected String serviceName() {
        return "task-launch-processor";
    }

    protected AbstractScheduledService.Scheduler scheduler() {
        return AbstractScheduledService.Scheduler.newFixedDelaySchedule((long)2L, (long)10L, (TimeUnit)TimeUnit.SECONDS);
    }

    protected void startUp() {
        log.info("Elastic Job: Start {}", (Object)this.serviceName());
        AppConstraintEvaluator.init(this.facadeService);
    }

    protected void shutDown() {
        log.info("Elastic Job: Stop {}", (Object)this.serviceName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runOneIteration() {
        try {
            LaunchingTasks launchingTasks = new LaunchingTasks(this.facadeService.getEligibleJobContext());
            List<TaskRequest> taskRequests = launchingTasks.getPendingTasks();
            if (!taskRequests.isEmpty()) {
                AppConstraintEvaluator.getInstance().loadAppRunningState();
            }
            Collection<VMAssignmentResult> vmAssignmentResults = this.taskScheduler.scheduleOnce(taskRequests, LeasesQueue.getInstance().drainTo()).getResultMap().values();
            LinkedList<TaskContext> taskContextsList = new LinkedList<TaskContext>();
            HashMap offerIdTaskInfoMap = new HashMap();
            for (VMAssignmentResult vMAssignmentResult : vmAssignmentResults) {
                List leasesUsed = vMAssignmentResult.getLeasesUsed();
                ArrayList<Protos.TaskInfo> taskInfoList = new ArrayList<Protos.TaskInfo>(vMAssignmentResult.getTasksAssigned().size() * 10);
                taskInfoList.addAll(this.getTaskInfoList(launchingTasks.getIntegrityViolationJobs(vmAssignmentResults), vMAssignmentResult, ((VirtualMachineLease)leasesUsed.get(0)).hostname(), ((VirtualMachineLease)leasesUsed.get(0)).getOffer()));
                for (Protos.TaskInfo taskInfo : taskInfoList) {
                    taskContextsList.add(TaskContext.from((String)taskInfo.getTaskId().getValue()));
                }
                offerIdTaskInfoMap.put(this.getOfferIDs(leasesUsed), taskInfoList);
            }
            for (TaskContext taskContext : taskContextsList) {
                this.facadeService.addRunning(taskContext);
                this.jobTracingEventBus.post((JobEvent)this.createJobStatusTraceEvent(taskContext));
            }
            this.facadeService.removeLaunchTasksFromQueue(taskContextsList);
            for (Map.Entry entry : offerIdTaskInfoMap.entrySet()) {
                this.schedulerDriver.launchTasks((Collection)entry.getKey(), (Collection)entry.getValue());
            }
        }
        catch (Throwable throwable) {
            log.error("Launch task error", throwable);
        }
        finally {
            AppConstraintEvaluator.getInstance().clearAppRunningState();
        }
    }

    private List<Protos.TaskInfo> getTaskInfoList(Collection<String> integrityViolationJobs, VMAssignmentResult vmAssignmentResult, String hostname, Protos.Offer offer) {
        ArrayList<Protos.TaskInfo> result = new ArrayList<Protos.TaskInfo>(vmAssignmentResult.getTasksAssigned().size());
        for (TaskAssignmentResult each : vmAssignmentResult.getTasksAssigned()) {
            Protos.TaskInfo taskInfo;
            TaskContext taskContext = TaskContext.from((String)each.getTaskId());
            String jobName = taskContext.getMetaInfo().getJobName();
            if (integrityViolationJobs.contains(jobName) || this.facadeService.isRunning(taskContext) || this.facadeService.isJobDisabled(jobName) || null == (taskInfo = this.getTaskInfo(offer, each))) continue;
            result.add(taskInfo);
            this.facadeService.addMapping(taskInfo.getTaskId().getValue(), hostname);
            this.taskScheduler.getTaskAssigner().call((Object)each.getRequest(), (Object)hostname);
        }
        return result;
    }

    private Protos.TaskInfo getTaskInfo(Protos.Offer offer, TaskAssignmentResult taskAssignmentResult) {
        TaskContext taskContext = TaskContext.from((String)taskAssignmentResult.getTaskId());
        Optional<CloudJobConfigurationPOJO> cloudJobConfig = this.facadeService.load(taskContext.getMetaInfo().getJobName());
        if (!cloudJobConfig.isPresent()) {
            return null;
        }
        Optional<CloudAppConfigurationPOJO> appConfig = this.facadeService.loadAppConfig(cloudJobConfig.get().getAppName());
        if (!appConfig.isPresent()) {
            return null;
        }
        taskContext.setSlaveId(offer.getSlaveId().getValue());
        ShardingContexts shardingContexts = this.getShardingContexts(taskContext, appConfig.get(), cloudJobConfig.get().toCloudJobConfiguration());
        boolean isCommandExecutor = CloudJobExecutionType.TRANSIENT == cloudJobConfig.get().getJobExecutionType() && cloudJobConfig.get().getProps().contains("script.command.line");
        String script = appConfig.get().getBootstrapScript();
        if (isCommandExecutor) {
            script = cloudJobConfig.get().getProps().getProperty("script.command.line");
        }
        Protos.CommandInfo.URI uri = this.buildURI(appConfig.get(), isCommandExecutor);
        Protos.CommandInfo command = this.buildCommand(uri, script, shardingContexts, isCommandExecutor);
        if (isCommandExecutor) {
            return this.buildCommandExecutorTaskInfo(taskContext, cloudJobConfig.get().toCloudJobConfiguration(), shardingContexts, offer, command);
        }
        return this.buildCustomizedExecutorTaskInfo(taskContext, appConfig.get(), cloudJobConfig.get().toCloudJobConfiguration(), shardingContexts, offer, command);
    }

    private ShardingContexts getShardingContexts(TaskContext taskContext, CloudAppConfigurationPOJO appConfig, CloudJobConfiguration cloudJobConfig) {
        Map shardingItemParameters = new ShardingItemParameters(cloudJobConfig.getJobConfig().getShardingItemParameters()).getMap();
        HashMap<Integer, String> assignedShardingItemParameters = new HashMap<Integer, String>(1, 1.0f);
        int shardingItem = (Integer)taskContext.getMetaInfo().getShardingItems().get(0);
        assignedShardingItemParameters.put(shardingItem, shardingItemParameters.getOrDefault(shardingItem, ""));
        return new ShardingContexts(taskContext.getId(), cloudJobConfig.getJobConfig().getJobName(), cloudJobConfig.getJobConfig().getShardingTotalCount(), cloudJobConfig.getJobConfig().getJobParameter(), assignedShardingItemParameters, appConfig.getEventTraceSamplingCount());
    }

    private Protos.TaskInfo buildCommandExecutorTaskInfo(TaskContext taskContext, CloudJobConfiguration cloudJobConfig, ShardingContexts shardingContexts, Protos.Offer offer, Protos.CommandInfo command) {
        Protos.TaskInfo.Builder result = Protos.TaskInfo.newBuilder().setTaskId(Protos.TaskID.newBuilder().setValue(taskContext.getId()).build()).setName(taskContext.getTaskName()).setSlaveId(offer.getSlaveId()).addResources(this.buildResource("cpus", cloudJobConfig.getCpuCount(), offer.getResourcesList())).addResources(this.buildResource("mem", cloudJobConfig.getMemoryMB(), offer.getResourcesList())).setData(ByteString.copyFrom((byte[])new TaskInfoData(shardingContexts, cloudJobConfig).serialize()));
        return result.setCommand(command).build();
    }

    private Protos.TaskInfo buildCustomizedExecutorTaskInfo(TaskContext taskContext, CloudAppConfigurationPOJO appConfig, CloudJobConfiguration cloudJobConfig, ShardingContexts shardingContexts, Protos.Offer offer, Protos.CommandInfo command) {
        Protos.TaskInfo.Builder result = Protos.TaskInfo.newBuilder().setTaskId(Protos.TaskID.newBuilder().setValue(taskContext.getId()).build()).setName(taskContext.getTaskName()).setSlaveId(offer.getSlaveId()).addResources(this.buildResource("cpus", cloudJobConfig.getCpuCount(), offer.getResourcesList())).addResources(this.buildResource("mem", cloudJobConfig.getMemoryMB(), offer.getResourcesList())).setData(ByteString.copyFrom((byte[])new TaskInfoData(shardingContexts, cloudJobConfig).serialize()));
        Protos.ExecutorInfo.Builder executorBuilder = Protos.ExecutorInfo.newBuilder().setExecutorId(Protos.ExecutorID.newBuilder().setValue(taskContext.getExecutorId(cloudJobConfig.getAppName()))).setCommand(command).addResources(this.buildResource("cpus", appConfig.getCpuCount(), offer.getResourcesList())).addResources(this.buildResource("mem", appConfig.getMemoryMB(), offer.getResourcesList()));
        if (this.env.getTracingConfiguration().isPresent()) {
            executorBuilder.setData(ByteString.copyFrom((byte[])SerializationUtils.serialize(this.env.getJobEventRdbConfigurationMap()))).build();
        }
        return result.setExecutor(executorBuilder.build()).build();
    }

    private Protos.CommandInfo.URI buildURI(CloudAppConfigurationPOJO appConfig, boolean isCommandExecutor) {
        Protos.CommandInfo.URI.Builder result = Protos.CommandInfo.URI.newBuilder().setValue(appConfig.getAppURL()).setCache(appConfig.isAppCacheEnable());
        if (isCommandExecutor && !SupportedExtractionType.isExtraction(appConfig.getAppURL())) {
            result.setExecutable(true);
        } else {
            result.setExtract(true);
        }
        return result.build();
    }

    private Protos.CommandInfo buildCommand(Protos.CommandInfo.URI uri, String script, ShardingContexts shardingContexts, boolean isCommandExecutor) {
        Protos.CommandInfo.Builder result = Protos.CommandInfo.newBuilder().addUris(uri).setShell(true);
        if (isCommandExecutor) {
            CommandLine commandLine = CommandLine.parse((String)script);
            commandLine.addArgument(GsonFactory.getGson().toJson((Object)shardingContexts), false);
            result.setValue(String.join((CharSequence)"-", commandLine.getExecutable(), this.getArguments(commandLine)));
        } else {
            result.setValue(script);
        }
        return result.build();
    }

    private String getArguments(CommandLine commandLine) {
        return String.join((CharSequence)" ", commandLine.getArguments());
    }

    private Protos.Resource buildResource(String type, double resourceValue, List<Protos.Resource> resources) {
        return Protos.Resource.newBuilder().mergeFrom(resources.stream().filter(input -> input.getName().equals(type)).findFirst().get()).setScalar(Protos.Value.Scalar.newBuilder().setValue(resourceValue)).build();
    }

    private JobStatusTraceEvent createJobStatusTraceEvent(TaskContext taskContext) {
        TaskContext.MetaInfo metaInfo = taskContext.getMetaInfo();
        JobStatusTraceEvent result = new JobStatusTraceEvent(metaInfo.getJobName(), taskContext.getId(), taskContext.getSlaveId(), JobStatusTraceEvent.Source.CLOUD_SCHEDULER, taskContext.getType().toString(), String.valueOf(metaInfo.getShardingItems()), JobStatusTraceEvent.State.TASK_STAGING, "");
        if (ExecutionType.FAILOVER == taskContext.getType()) {
            Optional<String> taskContextOptional = this.facadeService.getFailoverTaskId(metaInfo);
            taskContextOptional.ifPresent(arg_0 -> ((JobStatusTraceEvent)result).setOriginalTaskId(arg_0));
        }
        return result;
    }

    private List<Protos.OfferID> getOfferIDs(List<VirtualMachineLease> leasesUsed) {
        ArrayList<Protos.OfferID> result = new ArrayList<Protos.OfferID>();
        for (VirtualMachineLease virtualMachineLease : leasesUsed) {
            result.add(virtualMachineLease.getOffer().getId());
        }
        return result;
    }

    @Generated
    public TaskLaunchScheduledService(SchedulerDriver schedulerDriver, TaskScheduler taskScheduler, FacadeService facadeService, JobTracingEventBus jobTracingEventBus) {
        this.schedulerDriver = schedulerDriver;
        this.taskScheduler = taskScheduler;
        this.facadeService = facadeService;
        this.jobTracingEventBus = jobTracingEventBus;
    }
}

