/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.logging.rule.builder;

import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.builder.global.GlobalRuleBuilder;
import org.apache.shardingsphere.logging.config.LoggingRuleConfiguration;
import org.apache.shardingsphere.logging.logger.ShardingSphereLogger;
import org.apache.shardingsphere.logging.rule.LoggingRule;

public final class LoggingRuleBuilder
implements GlobalRuleBuilder<LoggingRuleConfiguration> {
    public LoggingRule build(LoggingRuleConfiguration ruleConfig, Map<String, ShardingSphereDatabase> databases, ConfigurationProperties props) {
        this.syncLoggingRuleConfiguration(ruleConfig, props);
        return new LoggingRule(ruleConfig);
    }

    private void syncLoggingRuleConfiguration(LoggingRuleConfiguration ruleConfig, ConfigurationProperties props) {
        this.getSQLLogger(ruleConfig).ifPresent(optional -> {
            this.syncPropertiesToRule(optional.getProps(), props);
            this.syncRuleToProperties(optional.getProps(), props);
        });
    }

    private Optional<ShardingSphereLogger> getSQLLogger(LoggingRuleConfiguration ruleConfig) {
        return ruleConfig.getLoggers().stream().filter(each -> "ShardingSphere-SQL".equalsIgnoreCase(each.getLoggerName())).findFirst();
    }

    private void syncPropertiesToRule(Properties loggerProps, ConfigurationProperties props) {
        if (!loggerProps.containsKey("enable") && props.getProps().containsKey("sql-show")) {
            loggerProps.setProperty("enable", props.getProps().get("sql-show").toString());
        }
        if (!loggerProps.containsKey("simple") && props.getProps().containsKey("sql-simple")) {
            loggerProps.setProperty("simple", props.getProps().get("sql-simple").toString());
        }
    }

    private void syncRuleToProperties(Properties loggerProps, ConfigurationProperties props) {
        if (loggerProps.containsKey("enable")) {
            props.getProps().setProperty("sql-show", loggerProps.get("enable").toString());
        }
        if (loggerProps.containsKey("simple")) {
            props.getProps().setProperty("sql-simple", loggerProps.get("simple").toString());
        }
    }

    public int getOrder() {
        return 9100;
    }

    public Class<LoggingRuleConfiguration> getTypeClass() {
        return LoggingRuleConfiguration.class;
    }
}

