/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rule.attribute;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.infra.rule.attribute.RuleAttribute;

public final class RuleAttributes {
    private final Collection<RuleAttribute> attributes;

    public RuleAttributes(RuleAttribute ... attributes) {
        this.attributes = Arrays.asList(attributes);
    }

    public <T extends RuleAttribute> Optional<T> findAttribute(Class<T> attributeClass) {
        for (RuleAttribute each : this.attributes) {
            if (!attributeClass.isAssignableFrom(each.getClass())) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    public <T extends RuleAttribute> T getAttribute(Class<T> attributeClass) {
        return (T)((RuleAttribute)this.findAttribute(attributeClass).orElseThrow(() -> new IllegalStateException(String.format("Can not find rule attribute: %s", attributeClass))));
    }
}

