/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.statistics.collector.tables;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereRowData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereTableData;
import org.apache.shardingsphere.infra.metadata.statistics.collector.ShardingSphereStatisticsCollector;
import org.apache.shardingsphere.infra.metadata.statistics.collector.ShardingSphereTableDataCollectorUtils;

public final class PgClassTableCollector
implements ShardingSphereStatisticsCollector {
    private static final String PG_CLASS = "pg_class";
    private static final String PUBLIC_SCHEMA = "public";
    private static final Long PUBLIC_SCHEMA_OID = 0L;

    @Override
    public Optional<ShardingSphereTableData> collect(String databaseName, ShardingSphereTable table, Map<String, ShardingSphereDatabase> databases, RuleMetaData globalRuleMetaData) throws SQLException {
        ShardingSphereTableData result = new ShardingSphereTableData(PG_CLASS);
        long oid = 0L;
        for (Map.Entry<String, ShardingSphereSchema> entry : databases.get(databaseName).getSchemas().entrySet()) {
            if (!PUBLIC_SCHEMA.equalsIgnoreCase(entry.getKey())) continue;
            result.getRows().addAll(this.collectForSchema(oid++, PUBLIC_SCHEMA_OID, entry.getValue(), table));
        }
        return Optional.of(result);
    }

    private Collection<ShardingSphereRowData> collectForSchema(Long oid, Long relNamespace, ShardingSphereSchema schema, ShardingSphereTable table) {
        LinkedList<ShardingSphereRowData> result = new LinkedList<ShardingSphereRowData>();
        for (Map.Entry<String, ShardingSphereTable> entry : schema.getTables().entrySet()) {
            CaseInsensitiveMap columnValues = new CaseInsensitiveMap(4, 1.0f);
            columnValues.put("oid", oid);
            columnValues.put("relnamespace", relNamespace);
            columnValues.put("relname", entry.getKey());
            columnValues.put("relkind", "r");
            result.add(new ShardingSphereRowData(ShardingSphereTableDataCollectorUtils.createRowValue((Map<String, Object>)columnValues, table)));
        }
        return result;
    }

    public String getType() {
        return PG_CLASS;
    }
}

