/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.engine;

import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.dml.DeleteStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.UpdateStatementContext;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.shadow.route.engine.ShadowRouteEngine;
import org.apache.shardingsphere.shadow.route.engine.dml.ShadowDeleteStatementRoutingEngine;
import org.apache.shardingsphere.shadow.route.engine.dml.ShadowInsertStatementRoutingEngine;
import org.apache.shardingsphere.shadow.route.engine.dml.ShadowSelectStatementRoutingEngine;
import org.apache.shardingsphere.shadow.route.engine.dml.ShadowUpdateStatementRoutingEngine;
import org.apache.shardingsphere.shadow.route.engine.impl.ShadowNonDMLStatementRoutingEngine;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.UpdateStatement;

public final class ShadowRouteEngineFactory {
    public static ShadowRouteEngine newInstance(QueryContext queryContext) {
        SQLStatement sqlStatement = queryContext.getSqlStatementContext().getSqlStatement();
        if (sqlStatement instanceof InsertStatement) {
            return ShadowRouteEngineFactory.createShadowInsertStatementRoutingEngine(queryContext);
        }
        if (sqlStatement instanceof DeleteStatement) {
            return ShadowRouteEngineFactory.createShadowDeleteStatementRoutingEngine(queryContext);
        }
        if (sqlStatement instanceof UpdateStatement) {
            return ShadowRouteEngineFactory.createShadowUpdateStatementRoutingEngine(queryContext);
        }
        if (sqlStatement instanceof SelectStatement) {
            return ShadowRouteEngineFactory.createShadowSelectStatementRoutingEngine(queryContext);
        }
        return ShadowRouteEngineFactory.createShadowNonMDLStatementRoutingEngine(queryContext);
    }

    private static ShadowRouteEngine createShadowNonMDLStatementRoutingEngine(QueryContext queryContext) {
        return new ShadowNonDMLStatementRoutingEngine(queryContext.getHintValueContext());
    }

    private static ShadowRouteEngine createShadowSelectStatementRoutingEngine(QueryContext queryContext) {
        return new ShadowSelectStatementRoutingEngine((SelectStatementContext)queryContext.getSqlStatementContext(), queryContext.getParameters(), queryContext.getHintValueContext());
    }

    private static ShadowRouteEngine createShadowUpdateStatementRoutingEngine(QueryContext queryContext) {
        return new ShadowUpdateStatementRoutingEngine((UpdateStatementContext)queryContext.getSqlStatementContext(), queryContext.getParameters(), queryContext.getHintValueContext());
    }

    private static ShadowRouteEngine createShadowDeleteStatementRoutingEngine(QueryContext queryContext) {
        return new ShadowDeleteStatementRoutingEngine((DeleteStatementContext)queryContext.getSqlStatementContext(), queryContext.getParameters(), queryContext.getHintValueContext());
    }

    private static ShadowRouteEngine createShadowInsertStatementRoutingEngine(QueryContext queryContext) {
        return new ShadowInsertStatementRoutingEngine((InsertStatementContext)queryContext.getSqlStatementContext(), queryContext.getHintValueContext());
    }

    @Generated
    private ShadowRouteEngineFactory() {
    }
}

