/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.metadata.persist.service.metadata.table;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereTableData;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.data.pojo.YamlShardingSphereRowData;
import org.apache.shardingsphere.infra.yaml.data.swapper.YamlShardingSphereRowDataSwapper;
import org.apache.shardingsphere.metadata.persist.node.ShardingSphereDataNode;
import org.apache.shardingsphere.mode.spi.PersistRepository;

public final class TableRowDataPersistService {
    private final PersistRepository repository;

    public void persist(String databaseName, String schemaName, String tableName, Collection<YamlShardingSphereRowData> rows) {
        if (rows.isEmpty()) {
            this.repository.persist(ShardingSphereDataNode.getTablePath(databaseName, schemaName, tableName.toLowerCase()), "");
        } else {
            rows.forEach(each -> this.repository.persist(ShardingSphereDataNode.getTableRowPath(databaseName, schemaName, tableName.toLowerCase(), each.getUniqueKey()), YamlEngine.marshal((Object)each)));
        }
    }

    public void delete(String databaseName, String schemaName, String tableName, Collection<YamlShardingSphereRowData> rows) {
        rows.forEach(each -> this.repository.delete(ShardingSphereDataNode.getTableRowPath(databaseName, schemaName, tableName.toLowerCase(), each.getUniqueKey())));
    }

    public ShardingSphereTableData load(String databaseName, String schemaName, String tableName, ShardingSphereTable table) {
        ShardingSphereTableData result = new ShardingSphereTableData(tableName);
        YamlShardingSphereRowDataSwapper swapper = new YamlShardingSphereRowDataSwapper(new ArrayList(table.getColumnValues()));
        for (String each : this.repository.getChildrenKeys(ShardingSphereDataNode.getTablePath(databaseName, schemaName, tableName))) {
            String yamlRow = this.repository.query(ShardingSphereDataNode.getTableRowPath(databaseName, schemaName, tableName, each));
            if (Strings.isNullOrEmpty((String)yamlRow)) continue;
            result.getRows().add(swapper.swapToObject((YamlShardingSphereRowData)YamlEngine.unmarshal((String)yamlRow, YamlShardingSphereRowData.class)));
        }
        return result;
    }

    @Generated
    public TableRowDataPersistService(PersistRepository repository) {
        this.repository = repository;
    }
}

