/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.metadata.persist.service.config.database;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.metadata.version.MetaDataVersion;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.swapper.resource.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.metadata.persist.node.metadata.DataSourceMetaDataNode;
import org.apache.shardingsphere.mode.spi.PersistRepository;

public final class DataSourceUnitPersistService {
    private final PersistRepository repository;

    public Map<String, DataSourcePoolProperties> load(String databaseName) {
        List childrenKeys = this.repository.getChildrenKeys(DataSourceMetaDataNode.getDataSourceUnitsNode(databaseName));
        return childrenKeys.stream().collect(Collectors.toMap(each -> each, each -> this.load(databaseName, (String)each), (a, b) -> b, () -> new LinkedHashMap(childrenKeys.size(), 1.0f)));
    }

    public DataSourcePoolProperties load(String databaseName, String dataSourceName) {
        String dataSourceValue = this.repository.query(DataSourceMetaDataNode.getDataSourceUnitVersionNode(databaseName, dataSourceName, this.getDataSourceActiveVersion(databaseName, dataSourceName)));
        return new YamlDataSourceConfigurationSwapper().swapToDataSourcePoolProperties((Map)YamlEngine.unmarshal((String)dataSourceValue, Map.class));
    }

    public Collection<MetaDataVersion> persist(String databaseName, Map<String, DataSourcePoolProperties> dataSourcePropsMap) {
        LinkedList<MetaDataVersion> result = new LinkedList<MetaDataVersion>();
        for (Map.Entry<String, DataSourcePoolProperties> entry : dataSourcePropsMap.entrySet()) {
            String activeVersion = this.getDataSourceActiveVersion(databaseName, entry.getKey());
            List versions = this.repository.getChildrenKeys(DataSourceMetaDataNode.getDataSourceUnitVersionsNode(databaseName, entry.getKey()));
            String nextActiveVersion = versions.isEmpty() ? "0" : String.valueOf(Integer.parseInt((String)versions.get(0)) + 1);
            this.repository.persist(DataSourceMetaDataNode.getDataSourceUnitVersionNode(databaseName, entry.getKey(), nextActiveVersion), YamlEngine.marshal((Object)new YamlDataSourceConfigurationSwapper().swapToMap(entry.getValue())));
            if (Strings.isNullOrEmpty((String)activeVersion)) {
                this.repository.persist(DataSourceMetaDataNode.getDataSourceUnitActiveVersionNode(databaseName, entry.getKey()), "0");
            }
            result.add(new MetaDataVersion(DataSourceMetaDataNode.getDataSourceUnitNode(databaseName, entry.getKey()), activeVersion, nextActiveVersion));
        }
        return result;
    }

    private String getDataSourceActiveVersion(String databaseName, String dataSourceName) {
        return this.repository.query(DataSourceMetaDataNode.getDataSourceUnitActiveVersionNode(databaseName, dataSourceName));
    }

    public void delete(String databaseName, String dataSourceName) {
        this.repository.delete(DataSourceMetaDataNode.getDataSourceUnitNode(databaseName, dataSourceName));
    }

    @Generated
    public DataSourceUnitPersistService(PersistRepository repository) {
        this.repository = repository;
    }
}

