/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.metadata.persist.service.config;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.mode.spi.PersistRepository;
import org.apache.shardingsphere.mode.tuple.RepositoryTuple;

public final class RepositoryTuplePersistService {
    private static final String ACTIVE_VERSION_PATTERN = "/active_version$";
    private static final String ACTIVE_VERSION_PATH = "active_version";
    private static final String VERSIONS_PATH = "versions";
    private final PersistRepository repository;

    public Collection<RepositoryTuple> load(String rootNode) {
        Pattern pattern = Pattern.compile(ACTIVE_VERSION_PATTERN, 2);
        return this.loadNodes(rootNode).stream().filter(each -> pattern.matcher((CharSequence)each).find()).map(this::getRepositoryTuple).collect(Collectors.toList());
    }

    private Collection<String> loadNodes(String rootNode) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        this.loadNodes(rootNode, result);
        if (1 == result.size()) {
            return Collections.emptyList();
        }
        return result;
    }

    private void loadNodes(String toBeLoadedNode, Collection<String> loadedNodes) {
        loadedNodes.add(toBeLoadedNode);
        for (String each : this.repository.getChildrenKeys(toBeLoadedNode)) {
            this.loadNodes(String.join((CharSequence)"/", toBeLoadedNode, each), loadedNodes);
        }
    }

    private RepositoryTuple getRepositoryTuple(String node) {
        String activeRuleKey = node.replace(ACTIVE_VERSION_PATH, VERSIONS_PATH) + "/" + this.repository.query(node);
        return new RepositoryTuple(activeRuleKey, this.repository.query(activeRuleKey));
    }

    @Generated
    public RepositoryTuplePersistService(PersistRepository repository) {
        this.repository = repository;
    }
}

