/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.metadata.persist.node;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class DatabaseMetaDataNode {
    private static final String ROOT_NODE = "metadata";
    private static final String SCHEMAS_NODE = "schemas";
    private static final String TABLES_NODE = "tables";
    private static final String ACTIVE_VERSION = "active_version";
    private static final String VERSIONS = "versions";

    public static String getDatabaseNamePath(String databaseName) {
        return String.join((CharSequence)"/", DatabaseMetaDataNode.getMetaDataNode(), databaseName);
    }

    public static String getMetaDataSchemaPath(String databaseName, String schemaName) {
        return String.join((CharSequence)"/", DatabaseMetaDataNode.getMetaDataSchemasPath(databaseName), schemaName);
    }

    public static String getMetaDataSchemasPath(String databaseName) {
        return String.join((CharSequence)"/", DatabaseMetaDataNode.getDatabaseNamePath(databaseName), SCHEMAS_NODE);
    }

    public static String getMetaDataTablesPath(String databaseName, String schemaName) {
        return String.join((CharSequence)"/", DatabaseMetaDataNode.getMetaDataSchemaPath(databaseName, schemaName), TABLES_NODE);
    }

    public static Optional<String> getDatabaseName(String path) {
        Pattern pattern = Pattern.compile(DatabaseMetaDataNode.getMetaDataNode() + "/([\\w\\-]+)$", 2);
        Matcher matcher = pattern.matcher(path);
        return matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
    }

    public static Optional<String> getDatabaseNameBySchemaNode(String schemaPath) {
        Pattern pattern = Pattern.compile(DatabaseMetaDataNode.getMetaDataNode() + "/([\\w\\-]+)?", 2);
        Matcher matcher = pattern.matcher(schemaPath);
        return matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
    }

    public static Optional<String> getSchemaName(String path) {
        Pattern pattern = Pattern.compile(DatabaseMetaDataNode.getMetaDataNode() + "/([\\w\\-]+)/schemas/([\\w\\-]+)$", 2);
        Matcher matcher = pattern.matcher(path);
        return matcher.find() ? Optional.of(matcher.group(2)) : Optional.empty();
    }

    public static Optional<String> getSchemaNameByTableNode(String tablePath) {
        Pattern pattern = Pattern.compile(DatabaseMetaDataNode.getMetaDataNode() + "/([\\w\\-]+)/schemas/([\\w\\-]+)?", 2);
        Matcher matcher = pattern.matcher(tablePath);
        return matcher.find() ? Optional.of(matcher.group(2)) : Optional.empty();
    }

    public static String getVersionNodeByActiveVersionPath(String rulePath, String activeVersion) {
        return rulePath.replace(ACTIVE_VERSION, VERSIONS) + "/" + activeVersion;
    }

    public static String getMetaDataNode() {
        return String.join((CharSequence)"/", "", ROOT_NODE);
    }

    @Generated
    private DatabaseMetaDataNode() {
    }
}

