/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.executor.enumerable;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.engine.SQLBindEngine;
import org.apache.shardingsphere.infra.connection.kernel.KernelProcessor;
import org.apache.shardingsphere.infra.database.core.metadata.database.system.SystemDatabase;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.opengauss.type.OpenGaussDatabaseType;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.connection.SQLExecutionInterruptedException;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroup;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupReportContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.process.ProcessEngine;
import org.apache.shardingsphere.infra.executor.sql.process.ProcessRegistry;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.merge.MergeEngine;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereTableData;
import org.apache.shardingsphere.infra.parser.sql.SQLStatementParserEngine;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sqlfederation.executor.constant.EnumerableConstants;
import org.apache.shardingsphere.sqlfederation.executor.context.SQLFederationContext;
import org.apache.shardingsphere.sqlfederation.executor.context.SQLFederationExecutorContext;
import org.apache.shardingsphere.sqlfederation.executor.enumerator.JDBCRowEnumerator;
import org.apache.shardingsphere.sqlfederation.executor.enumerator.MemoryRowEnumerator;
import org.apache.shardingsphere.sqlfederation.executor.utils.StatisticsAssembleUtils;
import org.apache.shardingsphere.sqlfederation.optimizer.context.OptimizerContext;
import org.apache.shardingsphere.sqlfederation.optimizer.metadata.schema.table.EmptyRowEnumerator;
import org.apache.shardingsphere.sqlfederation.optimizer.metadata.schema.table.ScanExecutor;
import org.apache.shardingsphere.sqlfederation.optimizer.metadata.schema.table.ScanExecutorContext;

public final class EnumerableScanExecutor
implements ScanExecutor {
    private final DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine;
    private final JDBCExecutor jdbcExecutor;
    private final JDBCExecutorCallback<? extends ExecuteResult> callback;
    private final OptimizerContext optimizerContext;
    private final SQLFederationExecutorContext executorContext;
    private final SQLFederationContext federationContext;
    private final RuleMetaData globalRuleMetaData;
    private final ShardingSphereStatistics statistics;
    private final ProcessEngine processEngine = new ProcessEngine();

    public Enumerable<Object> execute(ShardingSphereTable table, ScanExecutorContext scanContext) {
        String databaseName = this.executorContext.getDatabaseName();
        String schemaName = this.executorContext.getSchemaName();
        DatabaseType databaseType = this.optimizerContext.getParserContext(databaseName).getDatabaseType();
        if (new SystemDatabase(databaseType).getSystemSchemas().contains(schemaName)) {
            return this.createMemoryEnumerable(databaseName, schemaName, table, databaseType);
        }
        QueryContext queryContext = this.createQueryContext(this.federationContext.getMetaData(), scanContext, databaseType, this.federationContext.getQueryContext().isUseCache());
        ExecutionContext executionContext = new KernelProcessor().generateExecutionContext(queryContext, this.globalRuleMetaData, this.executorContext.getProps(), new ConnectionContext(Collections::emptySet));
        if (this.federationContext.isPreview()) {
            this.federationContext.getPreviewExecutionUnits().addAll(executionContext.getExecutionUnits());
            return this.createEmptyEnumerable();
        }
        return this.createJDBCEnumerable(queryContext, this.federationContext.getMetaData().getDatabase(databaseName), executionContext);
    }

    private AbstractEnumerable<Object> createJDBCEnumerable(final QueryContext queryContext, final ShardingSphereDatabase database, final ExecutionContext context) {
        return new AbstractEnumerable<Object>(){

            public Enumerator<Object> enumerator() {
                EnumerableScanExecutor.this.computeConnectionOffsets(context);
                ExecutionGroupContext executionGroupContext = EnumerableScanExecutor.this.prepareEngine.prepare(database.getName(), context.getRouteContext(), EnumerableScanExecutor.this.executorContext.getConnectionOffsets(), context.getExecutionUnits(), new ExecutionGroupReportContext(EnumerableScanExecutor.this.federationContext.getProcessId(), database.getName()));
                EnumerableScanExecutor.this.setParameters(executionGroupContext.getInputGroups());
                ShardingSpherePreconditions.checkState((!ProcessRegistry.getInstance().get(EnumerableScanExecutor.this.federationContext.getProcessId()).isInterrupted() ? 1 : 0) != 0, SQLExecutionInterruptedException::new);
                EnumerableScanExecutor.this.processEngine.executeSQL(executionGroupContext, EnumerableScanExecutor.this.federationContext.getQueryContext());
                List queryResults = EnumerableScanExecutor.this.jdbcExecutor.execute(executionGroupContext, EnumerableScanExecutor.this.callback).stream().map(QueryResult.class::cast).collect(Collectors.toList());
                MergeEngine mergeEngine = new MergeEngine(EnumerableScanExecutor.this.federationContext.getMetaData().getGlobalRuleMetaData(), database, EnumerableScanExecutor.this.executorContext.getProps(), new ConnectionContext(Collections::emptySet));
                MergedResult mergedResult = mergeEngine.merge(queryResults, queryContext.getSqlStatementContext());
                Collection statements = EnumerableScanExecutor.this.getStatements(executionGroupContext.getInputGroups());
                return new JDBCRowEnumerator(mergedResult, ((QueryResult)queryResults.get(0)).getMetaData(), statements);
            }
        };
    }

    private void computeConnectionOffsets(ExecutionContext context) {
        for (ExecutionUnit each : context.getExecutionUnits()) {
            if (this.executorContext.getConnectionOffsets().containsKey(each.getDataSourceName())) {
                int connectionOffset = this.executorContext.getConnectionOffsets().get(each.getDataSourceName());
                this.executorContext.getConnectionOffsets().put(each.getDataSourceName(), ++connectionOffset);
                continue;
            }
            this.executorContext.getConnectionOffsets().put(each.getDataSourceName(), 0);
        }
    }

    private Enumerable<Object> createMemoryEnumerable(String databaseName, String schemaName, ShardingSphereTable table, DatabaseType databaseType) {
        if (databaseType instanceof OpenGaussDatabaseType && EnumerableConstants.SYSTEM_CATALOG_TABLES.contains(table.getName())) {
            return this.createMemoryEnumerator(StatisticsAssembleUtils.assembleTableData(table, this.federationContext.getMetaData()), table, databaseType);
        }
        Optional<ShardingSphereTableData> tableData = Optional.ofNullable(this.statistics.getDatabase(databaseName)).map(optional -> optional.getSchema(schemaName)).map(optional -> optional.getTable(table.getName()));
        return tableData.map(optional -> this.createMemoryEnumerator((ShardingSphereTableData)optional, table, databaseType)).orElseGet(this::createEmptyEnumerable);
    }

    private Enumerable<Object> createMemoryEnumerator(final ShardingSphereTableData tableData, final ShardingSphereTable table, final DatabaseType databaseType) {
        return new AbstractEnumerable<Object>(){

            public Enumerator<Object> enumerator() {
                return new MemoryRowEnumerator(tableData.getRows(), table.getColumns().values(), databaseType);
            }
        };
    }

    private Collection<Statement> getStatements(Collection<ExecutionGroup<JDBCExecutionUnit>> inputGroups) {
        LinkedList<Statement> result = new LinkedList<Statement>();
        for (ExecutionGroup<JDBCExecutionUnit> each : inputGroups) {
            for (JDBCExecutionUnit executionUnit : each.getInputs()) {
                result.add(executionUnit.getStorageResource());
            }
        }
        return result;
    }

    private void setParameters(Collection<ExecutionGroup<JDBCExecutionUnit>> inputGroups) {
        for (ExecutionGroup<JDBCExecutionUnit> each : inputGroups) {
            for (JDBCExecutionUnit executionUnit : each.getInputs()) {
                if (!(executionUnit.getStorageResource() instanceof PreparedStatement)) continue;
                this.setParameters((PreparedStatement)executionUnit.getStorageResource(), executionUnit.getExecutionUnit().getSqlUnit().getParameters());
            }
        }
    }

    private void setParameters(PreparedStatement preparedStatement, List<Object> params) {
        for (int i = 0; i < params.size(); ++i) {
            preparedStatement.setObject(i + 1, params.get(i));
        }
    }

    private QueryContext createQueryContext(ShardingSphereMetaData metaData, ScanExecutorContext sqlString, DatabaseType databaseType, boolean useCache) {
        String sql = sqlString.getSql().replace(System.lineSeparator(), " ");
        SQLStatement sqlStatement = new SQLStatementParserEngine(databaseType, this.optimizerContext.getSqlParserRule().getSqlStatementCache(), this.optimizerContext.getSqlParserRule().getParseTreeCache()).parse(sql, useCache);
        List<Object> params = this.getParameters(sqlString.getParamIndexes());
        HintValueContext hintValueContext = new HintValueContext();
        SQLStatementContext sqlStatementContext = new SQLBindEngine(metaData, this.executorContext.getDatabaseName(), hintValueContext).bind(sqlStatement, params);
        return new QueryContext(sqlStatementContext, sql, params, hintValueContext, new ConnectionContext(Collections::emptySet), metaData, useCache);
    }

    private List<Object> getParameters(int[] paramIndexes) {
        if (null == paramIndexes) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>(paramIndexes.length);
        for (int each : paramIndexes) {
            result.add(this.federationContext.getQueryContext().getParameters().get(each));
        }
        return result;
    }

    private AbstractEnumerable<Object> createEmptyEnumerable() {
        return new AbstractEnumerable<Object>(){

            public Enumerator<Object> enumerator() {
                return new EmptyRowEnumerator();
            }
        };
    }

    @Generated
    public EnumerableScanExecutor(DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutor jdbcExecutor, JDBCExecutorCallback<? extends ExecuteResult> callback, OptimizerContext optimizerContext, SQLFederationExecutorContext executorContext, SQLFederationContext federationContext, RuleMetaData globalRuleMetaData, ShardingSphereStatistics statistics) {
        this.prepareEngine = prepareEngine;
        this.jdbcExecutor = jdbcExecutor;
        this.callback = callback;
        this.optimizerContext = optimizerContext;
        this.executorContext = executorContext;
        this.federationContext = federationContext;
        this.globalRuleMetaData = globalRuleMetaData;
        this.statistics = statistics;
    }
}

