/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.insert;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.generic.InsertColumnsToken;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;

public final class EncryptInsertDerivedColumnsTokenGenerator
implements CollectionSQLTokenGenerator<InsertStatementContext> {
    private final EncryptRule encryptRule;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof InsertStatementContext && ((InsertStatementContext)sqlStatementContext).containsInsertColumns();
    }

    public Collection<SQLToken> generateSQLTokens(InsertStatementContext insertStatementContext) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        EncryptTable encryptTable = this.encryptRule.getEncryptTable(insertStatementContext.getSqlStatement().getTable().map(optional -> optional.getTableName().getIdentifier().getValue()).orElse(""));
        for (ColumnSegment each : insertStatementContext.getSqlStatement().getColumns()) {
            List<String> derivedColumnNames = this.getDerivedColumnNames(encryptTable, each);
            if (derivedColumnNames.isEmpty()) continue;
            result.add((SQLToken)new InsertColumnsToken(each.getStopIndex() + 1, derivedColumnNames));
        }
        return result;
    }

    private List<String> getDerivedColumnNames(EncryptTable encryptTable, ColumnSegment columnSegment) {
        String columnName = columnSegment.getIdentifier().getValue();
        if (!encryptTable.isEncryptColumn(columnName)) {
            return Collections.emptyList();
        }
        LinkedList<String> result = new LinkedList<String>();
        EncryptColumn encryptColumn = encryptTable.getEncryptColumn(columnName);
        encryptColumn.getAssistedQuery().ifPresent(optional -> result.add(optional.getName()));
        encryptColumn.getLikeQuery().ifPresent(optional -> result.add(optional.getName()));
        return result;
    }

    @Generated
    public EncryptInsertDerivedColumnsTokenGenerator(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }
}

