/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.merge.dal.show;

import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Optional;
import org.apache.shardingsphere.encrypt.exception.syntax.UnsupportedEncryptSQLException;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.parser.SQLParserEngine;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateTableStatement;

public abstract class EncryptShowCreateTableMergedResult
implements MergedResult {
    private static final String COMMA = ", ";
    private static final int CREATE_TABLE_DEFINITION_INDEX = 2;
    private final String tableName;
    private final EncryptRule encryptRule;
    private final SQLParserEngine sqlParserEngine;

    protected EncryptShowCreateTableMergedResult(RuleMetaData globalRuleMetaData, SQLStatementContext sqlStatementContext, EncryptRule encryptRule) {
        ShardingSpherePreconditions.checkState((sqlStatementContext instanceof TableAvailable && 1 == ((TableAvailable)sqlStatementContext).getTablesContext().getSimpleTables().size() ? 1 : 0) != 0, () -> new UnsupportedEncryptSQLException("SHOW CREATE TABLE FOR MULTI TABLE"));
        this.tableName = ((SimpleTableSegment)((TableAvailable)sqlStatementContext).getTablesContext().getSimpleTables().iterator().next()).getTableName().getIdentifier().getValue();
        this.encryptRule = encryptRule;
        this.sqlParserEngine = ((SQLParserRule)globalRuleMetaData.getSingleRule(SQLParserRule.class)).getSQLParserEngine(sqlStatementContext.getDatabaseType());
    }

    public final boolean next() throws SQLException {
        return this.nextValue();
    }

    public final Object getValue(int columnIndex, Class<?> type) throws SQLException {
        if (2 == columnIndex) {
            String result = this.getOriginalValue(2, type).toString();
            Optional<EncryptTable> encryptTable = this.encryptRule.findEncryptTable(this.tableName);
            if (!encryptTable.isPresent() || !result.contains("(")) {
                return result;
            }
            CreateTableStatement createTableStatement = (CreateTableStatement)this.sqlParserEngine.parse(result, false);
            ArrayList columnDefinitions = new ArrayList(createTableStatement.getColumnDefinitions());
            StringBuilder builder = new StringBuilder(result.substring(0, ((ColumnDefinitionSegment)columnDefinitions.get(0)).getStartIndex()));
            for (ColumnDefinitionSegment each : columnDefinitions) {
                this.findLogicColumnDefinition(each, encryptTable.get(), result).ifPresent(optional -> builder.append((String)optional).append(COMMA));
            }
            builder.delete(builder.length() - COMMA.length(), builder.length()).append(result.substring(((ColumnDefinitionSegment)columnDefinitions.get(columnDefinitions.size() - 1)).getStopIndex() + 1));
            return builder.toString();
        }
        return this.getOriginalValue(columnIndex, type);
    }

    private Optional<String> findLogicColumnDefinition(ColumnDefinitionSegment columnDefinition, EncryptTable encryptTable, String sql) {
        ColumnSegment columnSegment = columnDefinition.getColumnName();
        String columnName = columnSegment.getIdentifier().getValue();
        if (encryptTable.isCipherColumn(columnName)) {
            String logicColumn = encryptTable.getLogicColumnByCipherColumn(columnName);
            return Optional.of(sql.substring(columnDefinition.getStartIndex(), columnSegment.getStartIndex()) + columnSegment.getIdentifier().getQuoteCharacter().wrap(logicColumn) + sql.substring(columnSegment.getStopIndex() + 1, columnDefinition.getStopIndex() + 1));
        }
        if (this.isDerivedColumn(encryptTable, columnName)) {
            return Optional.empty();
        }
        return Optional.of(sql.substring(columnDefinition.getStartIndex(), columnDefinition.getStopIndex() + 1));
    }

    private boolean isDerivedColumn(EncryptTable encryptTable, String columnName) {
        return encryptTable.isAssistedQueryColumn(columnName) || encryptTable.isLikeQueryColumn(columnName);
    }

    public final Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) throws SQLException {
        throw new SQLFeatureNotSupportedException("");
    }

    public final InputStream getInputStream(int columnIndex, String type) throws SQLException {
        throw new SQLFeatureNotSupportedException("");
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("");
    }

    protected abstract boolean nextValue() throws SQLException;

    protected abstract Object getOriginalValue(int var1, Class<?> var2) throws SQLException;
}

