/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.refresher.type.view;

import java.util.Collection;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.pojo.AlterSchemaMetaDataPOJO;
import org.apache.shardingsphere.mode.metadata.refresher.MetaDataRefresher;
import org.apache.shardingsphere.mode.persist.service.MetaDataManagerPersistService;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DropViewStatement;

public final class DropViewStatementSchemaRefresher
implements MetaDataRefresher<DropViewStatement> {
    @Override
    public void refresh(MetaDataManagerPersistService metaDataManagerPersistService, ShardingSphereDatabase database, Collection<String> logicDataSourceNames, String schemaName, DatabaseType databaseType, DropViewStatement sqlStatement, ConfigurationProperties props) {
        AlterSchemaMetaDataPOJO alterSchemaMetaDataPOJO = new AlterSchemaMetaDataPOJO(database.getName(), schemaName);
        sqlStatement.getViews().forEach(each -> {
            String viewName = each.getTableName().getIdentifier().getValue();
            alterSchemaMetaDataPOJO.getDroppedTables().add(viewName);
            alterSchemaMetaDataPOJO.getDroppedViews().add(viewName);
        });
        metaDataManagerPersistService.alterSchemaMetaData(alterSchemaMetaDataPOJO);
    }

    @Override
    public Class<DropViewStatement> getType() {
        return DropViewStatement.class;
    }
}

