/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.manager;

import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.MetaDataContextsFactory;
import org.apache.shardingsphere.mode.metadata.manager.ResourceSwitchManager;
import org.apache.shardingsphere.mode.metadata.manager.SwitchingResource;
import org.apache.shardingsphere.mode.spi.PersistRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StorageUnitManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StorageUnitManager.class);
    private final AtomicReference<MetaDataContexts> metaDataContexts;
    private final ComputeNodeInstanceContext computeNodeInstanceContext;
    private final ResourceSwitchManager resourceSwitchManager;
    private final MetaDataPersistService metaDataPersistService;

    public StorageUnitManager(AtomicReference<MetaDataContexts> metaDataContexts, ComputeNodeInstanceContext computeNodeInstanceContext, PersistRepository repository, ResourceSwitchManager resourceSwitchManager) {
        this.metaDataContexts = metaDataContexts;
        this.computeNodeInstanceContext = computeNodeInstanceContext;
        this.resourceSwitchManager = resourceSwitchManager;
        this.metaDataPersistService = new MetaDataPersistService(repository);
    }

    public synchronized void registerStorageUnit(String databaseName, Map<String, DataSourcePoolProperties> propsMap) {
        try {
            this.closeStaleRules(databaseName);
            SwitchingResource switchingResource = this.resourceSwitchManager.switchByRegisterStorageUnit(this.metaDataContexts.get().getMetaData().getDatabase(databaseName).getResourceMetaData(), propsMap);
            this.buildNewMetaDataContext(databaseName, switchingResource);
        }
        catch (SQLException ex) {
            log.error("Alter database: {} register storage unit failed", (Object)databaseName, (Object)ex);
        }
    }

    public synchronized void alterStorageUnit(String databaseName, Map<String, DataSourcePoolProperties> propsMap) {
        try {
            this.closeStaleRules(databaseName);
            SwitchingResource switchingResource = this.resourceSwitchManager.switchByAlterStorageUnit(this.metaDataContexts.get().getMetaData().getDatabase(databaseName).getResourceMetaData(), propsMap);
            this.buildNewMetaDataContext(databaseName, switchingResource);
        }
        catch (SQLException ex) {
            log.error("Alter database: {} register storage unit failed", (Object)databaseName, (Object)ex);
        }
    }

    public synchronized void unregisterStorageUnit(String databaseName, String storageUnitName) {
        try {
            this.closeStaleRules(databaseName);
            SwitchingResource switchingResource = this.resourceSwitchManager.switchByUnregisterStorageUnit(this.metaDataContexts.get().getMetaData().getDatabase(databaseName).getResourceMetaData(), Collections.singletonList(storageUnitName));
            this.buildNewMetaDataContext(databaseName, switchingResource);
        }
        catch (SQLException ex) {
            log.error("Alter database: {} register storage unit failed", (Object)databaseName, (Object)ex);
        }
    }

    private void buildNewMetaDataContext(String databaseName, SwitchingResource switchingResource) throws SQLException {
        MetaDataContexts reloadMetaDataContexts = MetaDataContextsFactory.createBySwitchResource(databaseName, true, switchingResource, this.metaDataContexts.get(), this.metaDataPersistService, this.computeNodeInstanceContext);
        this.metaDataContexts.set(reloadMetaDataContexts);
        this.metaDataContexts.get().getMetaData().getDatabases().putAll(this.buildShardingSphereDatabase(reloadMetaDataContexts.getMetaData().getDatabase(databaseName)));
        switchingResource.closeStaleDataSources();
    }

    private Map<String, ShardingSphereDatabase> buildShardingSphereDatabase(ShardingSphereDatabase originalDatabase) {
        return Collections.singletonMap(originalDatabase.getName().toLowerCase(), new ShardingSphereDatabase(originalDatabase.getName(), originalDatabase.getProtocolType(), originalDatabase.getResourceMetaData(), originalDatabase.getRuleMetaData(), this.buildSchemas(originalDatabase)));
    }

    private Map<String, ShardingSphereSchema> buildSchemas(ShardingSphereDatabase originalDatabase) {
        LinkedHashMap<String, ShardingSphereSchema> result = new LinkedHashMap<String, ShardingSphereSchema>(originalDatabase.getSchemas().size(), 1.0f);
        originalDatabase.getSchemas().keySet().forEach(schemaName -> result.put(schemaName.toLowerCase(), new ShardingSphereSchema(schemaName, originalDatabase.getSchema(schemaName).getTables(), this.metaDataPersistService.getDatabaseMetaDataFacade().getView().load(originalDatabase.getName(), schemaName))));
        return result;
    }

    private void closeStaleRules(String databaseName) {
        for (ShardingSphereRule each : this.metaDataContexts.get().getMetaData().getDatabase(databaseName).getRuleMetaData().getRules()) {
            if (!(each instanceof AutoCloseable)) continue;
            ((AutoCloseable)each).close();
        }
    }
}

