/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.broadcast.route.engine.type.unicast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.apache.shardingsphere.broadcast.route.engine.type.BroadcastRouteEngine;
import org.apache.shardingsphere.broadcast.rule.BroadcastRule;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.ddl.AlterViewStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.ddl.CreateViewStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.ddl.DropViewStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.CursorAvailable;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;

public final class BroadcastUnicastRoutingEngine
implements BroadcastRouteEngine {
    private final SQLStatementContext sqlStatementContext;
    private final Collection<String> logicTables;
    private final ConnectionContext connectionContext;

    @Override
    public RouteContext route(RouteContext routeContext, BroadcastRule broadcastRule) {
        RouteMapper dataSourceMapper = this.getDataSourceRouteMapper(broadcastRule.getDataSourceNames());
        routeContext.getRouteUnits().add(new RouteUnit(dataSourceMapper, this.createTableRouteMappers()));
        return routeContext;
    }

    private RouteMapper getDataSourceRouteMapper(Collection<String> dataSourceNames) {
        String dataSourceName = this.getDataSourceName(dataSourceNames);
        return new RouteMapper(dataSourceName, dataSourceName);
    }

    private String getDataSourceName(Collection<String> dataSourceNames) {
        return this.sqlStatementContext instanceof CursorAvailable || this.isViewStatementContext(this.sqlStatementContext) ? dataSourceNames.iterator().next() : this.getRandomDataSourceName(dataSourceNames);
    }

    private boolean isViewStatementContext(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof CreateViewStatementContext || sqlStatementContext instanceof AlterViewStatementContext || sqlStatementContext instanceof DropViewStatementContext;
    }

    private String getRandomDataSourceName(Collection<String> dataSourceNames) {
        Collection usedDataSourceNames = this.connectionContext.getUsedDataSourceNames();
        ArrayList availableDataSourceNames = new ArrayList(usedDataSourceNames.isEmpty() ? dataSourceNames : usedDataSourceNames);
        return (String)availableDataSourceNames.get(ThreadLocalRandom.current().nextInt(availableDataSourceNames.size()));
    }

    private Collection<RouteMapper> createTableRouteMappers() {
        if (this.logicTables.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RouteMapper> result = new ArrayList<RouteMapper>(this.logicTables.size());
        for (String each : this.logicTables) {
            result.add(new RouteMapper(each, each));
        }
        return result;
    }

    @Generated
    public BroadcastUnicastRoutingEngine(SQLStatementContext sqlStatementContext, Collection<String> logicTables, ConnectionContext connectionContext) {
        this.sqlStatementContext = sqlStatementContext;
        this.logicTables = logicTables;
        this.connectionContext = connectionContext;
    }
}

