/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.util.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import lombok.Generated;
import org.apache.shardingsphere.infra.util.json.JsonConfiguration;

public final class JsonUtils {
    private static final ObjectMapper MAPPER = JsonUtils.initDefaultMapper();

    private static ObjectMapper initDefaultMapper() {
        ObjectMapper result = new ObjectMapper();
        result.registerModule((Module)new JavaTimeModule());
        result.findAndRegisterModules();
        result.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        result.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        result.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return result;
    }

    public static String toJsonString(Object obj) {
        return MAPPER.writeValueAsString(obj);
    }

    public static <T extends JsonConfiguration> T fromJsonString(String value, Class<T> clazz) {
        return (T)((JsonConfiguration)MAPPER.readValue(value, clazz));
    }

    public static <T> T fromJsonString(String value, TypeReference<T> typeReference) {
        return (T)MAPPER.readValue(value, typeReference);
    }

    @Generated
    private JsonUtils() {
    }
}

