/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.servicecomb.toolkit.oasv.util;

import static org.assertj.core.api.Assertions.assertThat;
import static org.junit.Assert.*;

import java.util.List;

import org.junit.Test;

import io.swagger.v3.parser.util.ClasspathHelper;

public class SyntaxCheckerTest {

  @Test
  public void checkGood() {
    String yaml = loadRelative("syntax-good.yaml");
    List<String> errors = SyntaxChecker.check(yaml);
    assertThat(errors).isEmpty();
  }

  @Test
  public void checkBad() {
    String yaml = loadRelative("syntax-bad.yaml");
    List<String> errors = SyntaxChecker.check(yaml);
    assertThat(errors).containsExactly("attribute paths.'/pets'(post).summary2 is unexpected");
  }

  private String loadRelative(String filename) {
    String basePath = getClass().getPackage().getName().replaceAll("\\.", "/");
    return ClasspathHelper.loadFileFromClasspath(basePath + "/" + filename);
  }

}
