/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.unittest;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.servicecomb.swagger.generator.core.SwaggerGenerator;
import org.apache.servicecomb.swagger.generator.core.SwaggerGeneratorContext;

public class SwaggerGeneratorForTest
extends SwaggerGenerator {
    private Set<String> methodNameSet;

    public SwaggerGeneratorForTest(SwaggerGeneratorContext context, Class<?> cls) {
        super(context, cls);
        this.setPackageName("gen.cse.ms.ut");
    }

    public boolean containsMethod(String methodName) {
        if (this.methodNameSet == null) {
            return true;
        }
        return this.methodNameSet.contains(methodName);
    }

    protected void clearMethod() {
        if (this.methodNameSet != null) {
            this.methodNameSet.clear();
        }
        this.methodNameSet = null;
    }

    public void replaceMethods(String ... methodNames) {
        this.clearMethod();
        if (methodNames == null || methodNames.length == 0) {
            return;
        }
        if (this.methodNameSet == null) {
            this.methodNameSet = new HashSet<String>();
        }
        this.methodNameSet.addAll(Arrays.asList(methodNames));
    }

    @Override
    protected boolean isSkipMethod(Method method) {
        boolean skip = super.isSkipMethod(method);
        if (skip) {
            return true;
        }
        return !this.containsMethod(method.getName());
    }
}

