/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.style.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.servicecomb.toolkit.oasv.FactoryOptions;
import org.apache.servicecomb.toolkit.oasv.style.validator.paths.PathsKeyCaseValidator;
import org.apache.servicecomb.toolkit.oasv.validation.api.PathsValidator;
import org.apache.servicecomb.toolkit.oasv.validation.factory.PathItemValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.factory.PathsValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.skeleton.paths.PathsPathItemsValidator;
import org.springframework.stereotype.Component;

@Component
public class DefaultPathsValidatorFactory
implements PathsValidatorFactory {
    private final PathItemValidatorFactory pathItemValidatorFactory;

    public DefaultPathsValidatorFactory(PathItemValidatorFactory pathItemValidatorFactory) {
        this.pathItemValidatorFactory = pathItemValidatorFactory;
    }

    public List<PathsValidator> create(FactoryOptions options) {
        ArrayList<PathsValidator> validators = new ArrayList<PathsValidator>();
        validators.add((PathsValidator)new PathsPathItemsValidator(this.pathItemValidatorFactory.create(options)));
        this.addPathsKeyCaseValidator(validators, options);
        return Collections.unmodifiableList(validators);
    }

    private void addPathsKeyCaseValidator(List<PathsValidator> validators, FactoryOptions options) {
        String expectedCase = options.getString("paths.key.case");
        if (expectedCase != null) {
            validators.add(new PathsKeyCaseValidator(expectedCase));
        }
    }
}

