/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest;

import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.common.rest.locator.ServicePathManager;
import org.apache.servicecomb.core.BootListener;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.definition.loader.SchemaListener;
import org.springframework.stereotype.Component;

@Component
public class RestEngineSchemaListener
implements SchemaListener,
BootListener {
    public void onBootEvent(BootListener.BootEvent event) {
        if (!event.getEventType().equals((Object)BootListener.EventType.BEFORE_REGISTRY)) {
            return;
        }
        MicroserviceMeta microserviceMeta = SCBEngine.getInstance().getProducerMicroserviceMeta();
        ServicePathManager servicePathManager = ServicePathManager.getServicePathManager(microserviceMeta);
        if (servicePathManager != null) {
            servicePathManager.buildProducerPaths();
        }
    }

    public void onSchemaLoaded(SchemaMeta ... schemaMetas) {
        HashMap<String, ServicePathManager> mgrMap = new HashMap<String, ServicePathManager>();
        for (SchemaMeta schemaMeta : schemaMetas) {
            MicroserviceMeta microserviceMeta = schemaMeta.getMicroserviceMeta();
            ServicePathManager mgr = this.findPathManager(mgrMap, microserviceMeta);
            mgr.addSchema(schemaMeta);
        }
        for (ServicePathManager mgr : mgrMap.values()) {
            mgr.sortPath();
            mgr.saveToMicroserviceMeta();
        }
    }

    protected ServicePathManager findPathManager(Map<String, ServicePathManager> mgrMap, MicroserviceMeta microserviceMeta) {
        ServicePathManager mgr = mgrMap.get(microserviceMeta.getName());
        if (mgr != null) {
            return mgr;
        }
        mgr = ServicePathManager.getServicePathManager(microserviceMeta);
        mgr = mgr == null ? new ServicePathManager(microserviceMeta) : mgr.cloneServicePathManager();
        mgrMap.put(microserviceMeta.getName(), mgr);
        return mgr;
    }
}

