/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.consumer;

import com.google.common.eventbus.EventBus;
import java.util.Map;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import org.apache.servicecomb.serviceregistry.consumer.DefaultMicroserviceVersionFactory;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceManager;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersionFactory;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersionRule;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersions;
import org.apache.servicecomb.serviceregistry.consumer.StaticMicroserviceVersionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppManager.class);
    private EventBus eventBus;
    private MicroserviceVersionFactory microserviceVersionFactory = new DefaultMicroserviceVersionFactory();
    private Map<String, MicroserviceManager> apps = new ConcurrentHashMapEx();
    private volatile StaticMicroserviceVersionFactory staticMicroserviceVersionFactory;

    public AppManager(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public MicroserviceVersionFactory getMicroserviceVersionFactory() {
        return this.microserviceVersionFactory;
    }

    public Map<String, MicroserviceManager> getApps() {
        return this.apps;
    }

    public void setMicroserviceVersionFactory(MicroserviceVersionFactory microserviceVersionFactory) {
        this.microserviceVersionFactory = microserviceVersionFactory;
    }

    public MicroserviceVersionRule getOrCreateMicroserviceVersionRule(String appId, String microserviceName, String versionRule) {
        MicroserviceManager microserviceManager = this.getOrCreateMicroserviceManager(appId);
        return microserviceManager.getOrCreateMicroserviceVersionRule(microserviceName, versionRule);
    }

    public MicroserviceManager getOrCreateMicroserviceManager(String appId) {
        return this.apps.computeIfAbsent(appId, id -> new MicroserviceManager(this, appId));
    }

    public MicroserviceVersions getOrCreateMicroserviceVersions(String appId, String microserviceName) {
        MicroserviceManager microserviceManager = this.getOrCreateMicroserviceManager(appId);
        return microserviceManager.getOrCreateMicroserviceVersions(microserviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StaticMicroserviceVersionFactory getStaticMicroserviceVersionFactory() {
        if (null == this.staticMicroserviceVersionFactory) {
            AppManager appManager = this;
            synchronized (appManager) {
                if (null == this.staticMicroserviceVersionFactory) {
                    this.loadStaticMicroserviceVersionFactory();
                }
            }
        }
        return this.staticMicroserviceVersionFactory;
    }

    public void setStaticMicroserviceVersionFactory(StaticMicroserviceVersionFactory staticMicroserviceVersionFactory) {
        this.staticMicroserviceVersionFactory = staticMicroserviceVersionFactory;
    }

    private void loadStaticMicroserviceVersionFactory() {
        String staticMicroserviceVersionFactoryClass = ServiceRegistryConfig.INSTANCE.getStaticMicroserviceVersionFactory();
        try {
            this.staticMicroserviceVersionFactory = (StaticMicroserviceVersionFactory)Class.forName(staticMicroserviceVersionFactoryClass).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOGGER.info("unable to load StaticMicroserviceVersionFactory", (Throwable)e);
            throw new IllegalStateException("unable to load StaticMicroserviceVersionFactory", e);
        }
        LOGGER.info("staticMicroserviceVersionFactory is {}.", (Object)staticMicroserviceVersionFactoryClass);
    }
}

