/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.utils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.PropertyConfigurator;
import org.apache.servicecomb.foundation.common.config.impl.PropertiesLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public final class Log4jUtils {
    private static final String MERGED_FILE = "merged.log4j.properties";
    public static final String OUTPUT_CONFIG_ENABLED = "log4j.logger.outputConfig.enabled";
    public static final String OUTPUT_CONFIG_ENABLED_TRUE = "true";
    private static boolean inited = false;
    private static final Object LOCK = new Object();

    private Log4jUtils() {
    }

    public static void init() throws Exception {
        Log4jUtils.init(Arrays.asList("classpath*:config/base/log4j.properties", "classpath*:config/log4j.properties"));
    }

    public static void init(String locationPattern) throws Exception {
        Log4jUtils.init(Arrays.asList(locationPattern));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(List<String> locationPatterns) throws Exception {
        if (inited) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            if (inited) {
                return;
            }
            PropertiesLoader loader = new PropertiesLoader(locationPatterns);
            Properties properties = (Properties)loader.load();
            if (properties.isEmpty()) {
                throw new Exception("can not find resource " + locationPatterns);
            }
            PropertyConfigurator.configure((Properties)properties);
            inited = true;
            if (OUTPUT_CONFIG_ENABLED_TRUE.equals(properties.getProperty(OUTPUT_CONFIG_ENABLED, OUTPUT_CONFIG_ENABLED_TRUE))) {
                Log4jUtils.outputFile(loader.getFoundResList(), properties);
            }
        }
    }

    private static void outputFile(List<Resource> resList, Properties properties) throws IOException {
        Logger log = LoggerFactory.getLogger(Log4jUtils.class);
        String content = Log4jUtils.genFileContext(resList, properties);
        Resource res = resList.get(resList.size() - 1);
        File file = new File(res.getURL().getPath());
        if (!file.getParentFile().canWrite()) {
            log.error("Can not output {},because can not write to directory of file {}", (Object)MERGED_FILE, (Object)res.getURL().getPath());
            return;
        }
        File mergedfile = new File(res.getFile().getParentFile(), MERGED_FILE);
        FileUtils.writeStringToFile((File)mergedfile, (String)content, (Charset)StandardCharsets.UTF_8, (boolean)false);
        log.info("Write merged log4j config file to {}", (Object)mergedfile.getAbsolutePath());
    }

    private static String genFileContext(List<Resource> resList, Properties properties) throws IOException {
        List entryList = properties.entrySet().stream().sorted(new Comparator<Map.Entry<Object, Object>>(){

            @Override
            public int compare(Map.Entry<Object, Object> o1, Map.Entry<Object, Object> o2) {
                return o1.getKey().toString().compareTo(o2.getKey().toString());
            }
        }).collect(Collectors.toList());
        StringBuilder sb = new StringBuilder();
        for (Resource res : resList) {
            sb.append("#").append(res.getURL().getPath()).append("\n");
        }
        for (Map.Entry entry : entryList) {
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }
}

