/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.arguments;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.swagger.generator.core.utils.ParamUtils;
import org.apache.servicecomb.swagger.invocation.InvocationType;
import org.apache.servicecomb.swagger.invocation.arguments.ArgumentMapper;
import org.apache.servicecomb.swagger.invocation.arguments.ArgumentsMapperConfig;
import org.apache.servicecomb.swagger.invocation.arguments.ContextArgumentMapperFactory;
import org.apache.servicecomb.swagger.invocation.arguments.FieldInfo;
import org.apache.servicecomb.swagger.invocation.arguments.ProviderParameter;
import org.apache.servicecomb.swagger.invocation.converter.Converter;
import org.apache.servicecomb.swagger.invocation.converter.ConverterMgr;
import org.apache.servicecomb.swagger.invocation.converter.impl.ConverterCommon;
import org.springframework.util.TypeUtils;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;

public abstract class ArgumentsMapperFactory<T> {
    @Inject
    protected ConverterMgr converterMgr;
    protected InvocationType type;
    private Map<Class<?>, ContextArgumentMapperFactory> factoryMap = new HashMap();

    public void setConverterMgr(ConverterMgr converterMgr) {
        this.converterMgr = converterMgr;
    }

    protected void createFactoryMap(List<ContextArgumentMapperFactory> factoryList) {
        factoryList.forEach(factory -> this.factoryMap.put(factory.getContextClass(), (ContextArgumentMapperFactory)factory));
    }

    protected ContextArgumentMapperFactory findFactory(Type type) {
        if (type.getClass().equals(Class.class)) {
            return this.factoryMap.get((Class)type);
        }
        return null;
    }

    protected void collectArgumentsMapper(ArgumentsMapperConfig config) {
        List<ProviderParameter> providerNormalParams = this.collectContextArgumentsMapper(config);
        if (providerNormalParams.isEmpty()) {
            return;
        }
        if (this.isSwaggerWrapBody(config, providerNormalParams)) {
            this.collectWrapBodyMapper(config, providerNormalParams);
            return;
        }
        this.collectSwaggerArgumentsMapper(config, providerNormalParams);
    }

    protected boolean isSwaggerWrapBody(ArgumentsMapperConfig config, List<ProviderParameter> providerNormalParams) {
        Method swaggerMethod = config.getSwaggerMethod();
        if (swaggerMethod.getParameterCount() != 1) {
            return false;
        }
        Type swaggerType = config.getSwaggerMethod().getGenericParameterTypes()[0];
        if (!swaggerType.getClass().equals(Class.class)) {
            return false;
        }
        Type firstProviderParam = providerNormalParams.get(0).getType();
        if (!firstProviderParam.equals(Object.class) && TypeUtils.isAssignable((Type)firstProviderParam, (Type)swaggerType)) {
            return false;
        }
        if (((Class)swaggerType).getFields().length == 0) {
            return false;
        }
        Converter converter = this.converterMgr.findConverter(this.type, firstProviderParam, swaggerType = ((Class)swaggerType).getFields()[0].getGenericType());
        return !ConverterCommon.class.isInstance(converter);
    }

    protected List<ProviderParameter> collectContextArgumentsMapper(ArgumentsMapperConfig config) {
        ArrayList<ProviderParameter> providerNormalParams = new ArrayList<ProviderParameter>();
        Annotation[][] parameterAnnotations = config.getProviderMethod().getParameterAnnotations();
        Type[] providerParameterTypes = config.getProviderMethod().getGenericParameterTypes();
        for (int providerIdx = 0; providerIdx < providerParameterTypes.length; ++providerIdx) {
            Type parameterType = ParamUtils.getGenericParameterType(config.getClz(), config.getProviderMethod().getDeclaringClass(), (Type)providerParameterTypes[providerIdx]);
            ContextArgumentMapperFactory factory = this.findFactory(parameterType);
            if (factory != null) {
                ArgumentMapper mapper = factory.create(providerIdx);
                config.addArgumentMapper(mapper);
                continue;
            }
            ProviderParameter pp = new ProviderParameter(providerIdx, parameterType, ArgumentsMapperFactory.retrieveVisibleParamName(config.getProviderMethod(), providerIdx)).setAnnotations(parameterAnnotations[providerIdx]);
            providerNormalParams.add(pp);
        }
        return providerNormalParams;
    }

    public static String retrieveVisibleParamName(Method method, int paramIndex) {
        Annotation[] annotations = method.getParameterAnnotations()[paramIndex];
        String paramName = null;
        for (Annotation annotation : annotations) {
            paramName = ArgumentsMapperFactory.retrieveVisibleParamName(annotation);
        }
        if (null == paramName) {
            paramName = ParamUtils.getParameterName((Method)method, (int)paramIndex);
        }
        return paramName;
    }

    public static String retrieveVisibleParamName(Annotation annotation) {
        if (annotation instanceof CookieParam) {
            return ((CookieParam)annotation).value();
        }
        if (annotation instanceof CookieValue) {
            return StringUtils.isEmpty((CharSequence)((CookieValue)annotation).name()) ? ((CookieValue)annotation).value() : ((CookieValue)annotation).name();
        }
        if (annotation instanceof FormParam) {
            return ((FormParam)annotation).value();
        }
        if (annotation instanceof HeaderParam) {
            return ((HeaderParam)annotation).value();
        }
        if (annotation instanceof PathParam) {
            return ((PathParam)annotation).value();
        }
        if (annotation instanceof PathVariable) {
            return StringUtils.isEmpty((CharSequence)((PathVariable)annotation).name()) ? ((PathVariable)annotation).value() : ((PathVariable)annotation).name();
        }
        if (annotation instanceof QueryParam) {
            return ((QueryParam)annotation).value();
        }
        if (annotation instanceof RequestAttribute) {
            return StringUtils.isEmpty((CharSequence)((RequestAttribute)annotation).name()) ? ((RequestAttribute)annotation).value() : ((RequestAttribute)annotation).name();
        }
        if (annotation instanceof RequestHeader) {
            return StringUtils.isEmpty((CharSequence)((RequestHeader)annotation).name()) ? ((RequestHeader)annotation).value() : ((RequestHeader)annotation).name();
        }
        if (annotation instanceof RequestParam) {
            return StringUtils.isEmpty((CharSequence)((RequestParam)annotation).name()) ? ((RequestParam)annotation).value() : ((RequestParam)annotation).name();
        }
        if (annotation instanceof RequestPart) {
            return StringUtils.isEmpty((CharSequence)((RequestPart)annotation).name()) ? ((RequestPart)annotation).value() : ((RequestPart)annotation).name();
        }
        return null;
    }

    protected void collectSwaggerArgumentsMapper(ArgumentsMapperConfig config, List<ProviderParameter> providerNormalParams) {
        Method swaggerMethod = config.getSwaggerMethod();
        Type[] swaggerParams = swaggerMethod.getGenericParameterTypes();
        int minParamCount = Math.min(providerNormalParams.size(), swaggerParams.length);
        for (int swaggerIdx = 0; swaggerIdx < minParamCount; ++swaggerIdx) {
            ProviderParameter providerParameter = providerNormalParams.get(swaggerIdx);
            Type swaggerParameter = swaggerParams[swaggerIdx];
            Converter converter = this.converterMgr.findConverter(this.type, providerParameter.getType(), swaggerParameter);
            ArgumentMapper mapper = this.createArgumentMapperWithConverter(swaggerIdx, providerParameter.getIndex(), converter);
            config.addArgumentMapper(mapper);
        }
    }

    protected void collectWrapBodyMapper(ArgumentsMapperConfig config, List<ProviderParameter> providerNormalParams) {
        Method swaggerMethod = config.getSwaggerMethod();
        Class<?> swaggerParam = swaggerMethod.getParameterTypes()[0];
        Field[] swaggerParamFields = swaggerParam.getFields();
        int minParamCount = Math.min(providerNormalParams.size(), swaggerParamFields.length);
        HashMap<Integer, FieldInfo> fieldMap = new HashMap<Integer, FieldInfo>();
        for (int swaggerIdx = 0; swaggerIdx < minParamCount; ++swaggerIdx) {
            ProviderParameter providerParameter = providerNormalParams.get(swaggerIdx);
            Field swaggerField = swaggerParamFields[swaggerIdx];
            swaggerField.setAccessible(true);
            Converter converter = this.converterMgr.findConverter(this.type, providerParameter.getType(), swaggerField.getGenericType());
            FieldInfo info = new FieldInfo(swaggerField, converter);
            fieldMap.put(providerParameter.getIndex(), info);
        }
        ArgumentMapper bodyFieldArg = this.createBodyFieldArgMapper(config, fieldMap);
        config.addArgumentMapper(bodyFieldArg);
    }

    public abstract T createArgumentsMapper(ArgumentsMapperConfig var1);

    protected abstract ArgumentMapper createArgumentMapperWithConverter(int var1, int var2, Converter var3);

    protected abstract ArgumentMapper createBodyFieldArgMapper(ArgumentsMapperConfig var1, Map<Integer, FieldInfo> var2);
}

