/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory.partition;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import thredds.inventory.partition.DirectoryCollection;
import thredds.inventory.partition.DirectoryPartition;
import thredds.inventory.partition.IndexReader;
import ucar.nc2.util.Indent;

public class DirectoryBuilder {
    private static final boolean debug = false;
    private final String suffix;
    private final String topCollectionName;
    private final String partitionName;
    private final Path dir;
    private final FileTime dirLastModified;
    private Path index;
    private FileTime indexLastModified;
    private long indexSize;
    private boolean childrenConstructed;
    private List<DirectoryBuilder> children = new ArrayList<DirectoryBuilder>(25);
    private PartitionStatus partitionStatus = PartitionStatus.unknown;

    public static MCollection factory(FeatureCollectionConfig config, Path topDir, boolean isTop, IndexReader indexReader, String suffix, Logger logger) throws IOException {
        DirectoryBuilder builder = new DirectoryBuilder(config.collectionName, topDir.toString(), suffix);
        DirectoryPartition dpart = new DirectoryPartition(config, topDir, isTop, indexReader, suffix, logger);
        if (!builder.isLeaf(indexReader)) {
            return dpart;
        }
        boolean hasIndex = builder.findIndex();
        if (hasIndex) {
            return dpart.makeChildCollection(builder);
        }
        DirectoryCollection result = new DirectoryCollection(config.collectionName, topDir, isTop, config.olderThan, logger);
        return result;
    }

    public DirectoryBuilder(String topCollectionName, String dirFilename, String suffix) throws IOException {
        this(topCollectionName, Paths.get(dirFilename, new String[0]), null, suffix);
    }

    public DirectoryBuilder(String topCollectionName, Path dir, BasicFileAttributes attr, String suffix) throws IOException {
        this.topCollectionName = topCollectionName;
        this.dir = dir;
        this.partitionName = DirectoryCollection.makeCollectionName(topCollectionName, dir);
        this.suffix = suffix;
        if (attr == null) {
            attr = Files.readAttributes(this.dir, BasicFileAttributes.class, new LinkOption[0]);
        }
        if (!attr.isDirectory()) {
            throw new IllegalArgumentException("DirectoryPartitionBuilder needs a directory");
        }
        this.dirLastModified = attr.lastModifiedTime();
        this.findIndex();
    }

    public boolean findIndex() throws IOException {
        Path indexPath = Paths.get(this.dir.toString(), this.partitionName + this.suffix);
        if (Files.exists(indexPath, new LinkOption[0])) {
            this.index = indexPath;
            BasicFileAttributes attr = Files.readAttributes(indexPath, BasicFileAttributes.class, new LinkOption[0]);
            this.indexLastModified = attr.lastModifiedTime();
            this.indexSize = attr.size();
            return true;
        }
        return false;
    }

    private boolean isLeaf(IndexReader indexReader) throws IOException {
        if (this.partitionStatus == PartitionStatus.unknown) {
            int countDir = 0;
            int countFile = 0;
            int count = 0;
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(this.dir);){
                Iterator<Path> iterator = dirStream.iterator();
                while (iterator.hasNext() && count++ < 100) {
                    Path p = iterator.next();
                    BasicFileAttributes attr = Files.readAttributes(p, BasicFileAttributes.class, new LinkOption[0]);
                    if (attr.isDirectory()) {
                        ++countDir;
                        continue;
                    }
                    ++countFile;
                }
            }
            this.partitionStatus = countFile > countDir ? PartitionStatus.isLeaf : PartitionStatus.isDirectoryPartition;
        }
        return this.partitionStatus == PartitionStatus.isLeaf;
    }

    public List<DirectoryBuilder> constructChildren(IndexReader indexReader, CollectionUpdateType forceCollection) throws IOException {
        if (this.childrenConstructed) {
            return this.children;
        }
        if (this.index != null && forceCollection == CollectionUpdateType.nocheck) {
            this.constructChildrenFromIndex(indexReader, false);
        } else {
            this.scanForChildren();
        }
        this.partitionStatus = !this.children.isEmpty() ? PartitionStatus.isDirectoryPartition : PartitionStatus.isLeaf;
        this.childrenConstructed = true;
        return this.children;
    }

    public List<DirectoryBuilder> constructChildrenFromIndex(IndexReader indexReader, boolean substituteParentDir) throws IOException {
        if (!indexReader.readChildren(this.index, new AddChildSub(substituteParentDir))) {
            this.partitionStatus = PartitionStatus.isLeaf;
        }
        return this.children;
    }

    private DirectoryBuilder(String topCollectionName, Path indexFile, long indexLastModified, String suffix) throws IOException {
        this.topCollectionName = topCollectionName;
        if (Files.exists(indexFile, new LinkOption[0])) {
            this.index = indexFile;
            this.indexLastModified = FileTime.fromMillis(indexLastModified);
        }
        this.dir = indexFile.getParent();
        this.partitionName = DirectoryCollection.makeCollectionName(topCollectionName, this.dir);
        BasicFileAttributes attr = Files.readAttributes(this.dir, BasicFileAttributes.class, new LinkOption[0]);
        if (!attr.isDirectory()) {
            throw new IllegalArgumentException("DirectoryPartition needs a directory");
        }
        this.dirLastModified = attr.lastModifiedTime();
        this.suffix = suffix;
    }

    private void scanForChildren() {
        boolean count = false;
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(this.dir);){
            for (Path p : ds) {
                BasicFileAttributes attr = Files.readAttributes(p, BasicFileAttributes.class, new LinkOption[0]);
                if (!attr.isDirectory()) continue;
                this.children.add(new DirectoryBuilder(this.topCollectionName, p, attr, this.suffix));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.childrenConstructed = true;
    }

    public List<MFile> readFilesFromIndex(IndexReader indexReader) throws IOException {
        ArrayList<MFile> result = new ArrayList<MFile>(100);
        if (this.index == null) {
            return result;
        }
        indexReader.readMFiles(this.index, result);
        return result;
    }

    public Path getDir() {
        return this.dir;
    }

    public Path getIndex() {
        return this.index;
    }

    public List<DirectoryBuilder> getChildren() {
        return this.children;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public void show(Formatter out) {
        out.format("Collection %s%n", this.partitionName);
        this.toString(out, new Indent(2));
        out.format("%n%n", new Object[0]);
    }

    private void toString(Formatter out, Indent indent) {
        out.format("%sDir '%s' (%s) index '%s' (%s)%n", indent, this.dir, this.dirLastModified, this.index, this.indexLastModified);
        indent.incr();
        for (DirectoryBuilder c : this.children) {
            c.toString(out, indent);
        }
        indent.decr();
    }

    private class AddChildSub
    implements IndexReader.AddChildCallback {
        boolean substituteParentDir;

        AddChildSub(boolean substituteParentDir) {
            this.substituteParentDir = substituteParentDir;
        }

        @Override
        public void addChild(String dirName, String indexFilename, long lastModified) throws IOException {
            Path indexPath = Paths.get(dirName, indexFilename);
            if (this.substituteParentDir) {
                Path parent = DirectoryBuilder.this.index.getParent();
                indexPath = parent.resolve(indexFilename);
            }
            DirectoryBuilder child = new DirectoryBuilder(DirectoryBuilder.this.topCollectionName, indexPath, lastModified, DirectoryBuilder.this.suffix);
            DirectoryBuilder.this.children.add(child);
        }
    }

    private class AddChild
    implements IndexReader.AddChildCallback {
        private AddChild() {
        }

        @Override
        public void addChild(String dirName, String indexFilename, long lastModified) throws IOException {
            Path indexPath = Paths.get(indexFilename, new String[0]);
            DirectoryBuilder child = new DirectoryBuilder(DirectoryBuilder.this.topCollectionName, indexPath, lastModified, DirectoryBuilder.this.suffix);
            DirectoryBuilder.this.children.add(child);
        }
    }

    private static enum PartitionStatus {
        unknown,
        isDirectoryPartition,
        isLeaf;

    }
}

