/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.common.exception;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExceptionParamsUtil {
    private static final Pattern PARAMS_PATTERN = Pattern.compile("<([a-zA-Z0-9]+)+>");

    public static List<String> getParams(String description) {
        Matcher matcher = PARAMS_PATTERN.matcher(description);
        ArrayList<String> params = new ArrayList<String>();
        while (matcher.find()) {
            String key = matcher.group(1);
            params.add(key);
        }
        return params;
    }

    public static String getDescription(String descriptionTemplate, Map<String, String> params) {
        ExceptionParamsUtil.assertParamsMatchWithDescription(descriptionTemplate, params);
        String description = descriptionTemplate;
        for (String param : ExceptionParamsUtil.getParams(descriptionTemplate)) {
            String value = params.get(param);
            description = description.replace(String.format("<%s>", param), value);
        }
        return description;
    }

    public static void assertParamsMatchWithDescription(String descriptionTemplate, Map<String, String> params) {
        ExceptionParamsUtil.getParams(descriptionTemplate).forEach(param -> {
            if (!params.containsKey(param)) {
                throw new IllegalArgumentException(String.format("Param [%s] is not set in error message [%s]", param, descriptionTemplate));
            }
        });
    }
}

