/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.inner;

import com.baomidou.mybatisplus.core.plugins.InterceptorIgnoreHelper;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.BaseMultiTableInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.toolkit.PropertyMapper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

public class TenantLineInnerInterceptor
extends BaseMultiTableInnerInterceptor
implements InnerInterceptor {
    private TenantLineHandler tenantLineHandler;

    @Override
    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        if (InterceptorIgnoreHelper.willIgnoreTenantLine((String)ms.getId())) {
            return;
        }
        PluginUtils.MPBoundSql mpBs = PluginUtils.mpBoundSql((BoundSql)boundSql);
        mpBs.sql(this.parserSingle(mpBs.sql(), null));
    }

    @Override
    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        PluginUtils.MPStatementHandler mpSh = PluginUtils.mpStatementHandler((StatementHandler)sh);
        MappedStatement ms = mpSh.mappedStatement();
        SqlCommandType sct = ms.getSqlCommandType();
        if (sct == SqlCommandType.INSERT || sct == SqlCommandType.UPDATE || sct == SqlCommandType.DELETE) {
            if (InterceptorIgnoreHelper.willIgnoreTenantLine((String)ms.getId())) {
                return;
            }
            PluginUtils.MPBoundSql mpBs = mpSh.mPBoundSql();
            mpBs.sql(this.parserMulti(mpBs.sql(), null));
        }
    }

    @Override
    protected void processSelect(Select select, int index, String sql, Object obj) {
        String whereSegment = (String)obj;
        this.processSelectBody(select.getSelectBody(), whereSegment);
        List withItemsList = select.getWithItemsList();
        if (!CollectionUtils.isEmpty((Collection)withItemsList)) {
            withItemsList.forEach(withItem -> this.processSelectBody((SelectBody)withItem, whereSegment));
        }
    }

    @Override
    protected void processInsert(Insert insert, int index, String sql, Object obj) {
        Select select;
        if (this.tenantLineHandler.ignoreTable(insert.getTable().getName())) {
            return;
        }
        List columns = insert.getColumns();
        if (CollectionUtils.isEmpty((Collection)columns)) {
            return;
        }
        String tenantIdColumn = this.tenantLineHandler.getTenantIdColumn();
        if (this.tenantLineHandler.ignoreInsert(columns, tenantIdColumn)) {
            return;
        }
        columns.add(new Column(tenantIdColumn));
        List duplicateUpdateColumns = insert.getDuplicateUpdateExpressionList();
        if (CollectionUtils.isNotEmpty((Collection)duplicateUpdateColumns)) {
            EqualsTo equalsTo = new EqualsTo();
            equalsTo.setLeftExpression((Expression)new StringValue(tenantIdColumn));
            equalsTo.setRightExpression(this.tenantLineHandler.getTenantId());
            duplicateUpdateColumns.add(equalsTo);
        }
        if ((select = insert.getSelect()) != null) {
            this.processInsertSelect(select.getSelectBody(), (String)obj);
        } else if (insert.getItemsList() != null) {
            ItemsList itemsList = insert.getItemsList();
            Expression tenantId = this.tenantLineHandler.getTenantId();
            if (itemsList instanceof MultiExpressionList) {
                ((MultiExpressionList)itemsList).getExpressionLists().forEach(el -> el.getExpressions().add(tenantId));
            } else {
                ((ExpressionList)itemsList).getExpressions().add(tenantId);
            }
        } else {
            throw ExceptionUtils.mpe((String)"Failed to process multiple-table update, please exclude the tableName or statementId", (Object[])new Object[0]);
        }
    }

    @Override
    protected void processUpdate(Update update, int index, String sql, Object obj) {
        Table table = update.getTable();
        if (this.tenantLineHandler.ignoreTable(table.getName())) {
            return;
        }
        update.setWhere(this.andExpression(table, update.getWhere(), (String)obj));
    }

    @Override
    protected void processDelete(Delete delete, int index, String sql, Object obj) {
        if (this.tenantLineHandler.ignoreTable(delete.getTable().getName())) {
            return;
        }
        delete.setWhere(this.andExpression(delete.getTable(), delete.getWhere(), (String)obj));
    }

    protected void processInsertSelect(SelectBody selectBody, String whereSegment) {
        PlainSelect plainSelect = (PlainSelect)selectBody;
        FromItem fromItem = plainSelect.getFromItem();
        if (fromItem instanceof Table) {
            this.processPlainSelect(plainSelect, whereSegment);
            this.appendSelectItem(plainSelect.getSelectItems());
        } else if (fromItem instanceof SubSelect) {
            SubSelect subSelect = (SubSelect)fromItem;
            this.appendSelectItem(plainSelect.getSelectItems());
            this.processInsertSelect(subSelect.getSelectBody(), whereSegment);
        }
    }

    protected void appendSelectItem(List<SelectItem> selectItems) {
        SelectItem item;
        if (CollectionUtils.isEmpty(selectItems)) {
            return;
        }
        if (selectItems.size() == 1 && ((item = selectItems.get(0)) instanceof AllColumns || item instanceof AllTableColumns)) {
            return;
        }
        selectItems.add((SelectItem)new SelectExpressionItem((Expression)new Column(this.tenantLineHandler.getTenantIdColumn())));
    }

    protected Column getAliasColumn(Table table) {
        StringBuilder column = new StringBuilder();
        if (table.getAlias() != null) {
            column.append(table.getAlias().getName()).append(".");
        }
        column.append(this.tenantLineHandler.getTenantIdColumn());
        return new Column(column.toString());
    }

    @Override
    public void setProperties(Properties properties) {
        PropertyMapper.newInstance(properties).whenNotBlank("tenantLineHandler", ClassUtils::newInstance, this::setTenantLineHandler);
    }

    @Override
    public Expression buildTableExpression(Table table, Expression where, String whereSegment) {
        if (this.tenantLineHandler.ignoreTable(table.getName())) {
            return null;
        }
        return new EqualsTo((Expression)this.getAliasColumn(table), this.tenantLineHandler.getTenantId());
    }

    public TenantLineHandler getTenantLineHandler() {
        return this.tenantLineHandler;
    }

    public void setTenantLineHandler(TenantLineHandler tenantLineHandler) {
        this.tenantLineHandler = tenantLineHandler;
    }

    public TenantLineInnerInterceptor() {
    }

    public TenantLineInnerInterceptor(TenantLineHandler tenantLineHandler) {
        this.tenantLineHandler = tenantLineHandler;
    }

    @Override
    public String toString() {
        return "TenantLineInnerInterceptor(super=" + super.toString() + ", tenantLineHandler=" + this.getTenantLineHandler() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TenantLineInnerInterceptor)) {
            return false;
        }
        TenantLineInnerInterceptor other = (TenantLineInnerInterceptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantLineHandler this$tenantLineHandler = this.getTenantLineHandler();
        TenantLineHandler other$tenantLineHandler = other.getTenantLineHandler();
        return !(this$tenantLineHandler == null ? other$tenantLineHandler != null : !this$tenantLineHandler.equals(other$tenantLineHandler));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TenantLineInnerInterceptor;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TenantLineHandler $tenantLineHandler = this.getTenantLineHandler();
        result = result * 59 + ($tenantLineHandler == null ? 43 : $tenantLineHandler.hashCode());
        return result;
    }
}

