/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec.scan.index;

import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.AbstractCompositeIterator;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.query.impl.AbstractIndex;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilter;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class IndexInFilter
implements IndexFilter,
IdentifiedDataSerializable {
    private List<IndexFilter> filters;

    public IndexInFilter() {
    }

    public IndexInFilter(IndexFilter ... filters) {
        assert (filters != null);
        this.filters = Arrays.asList(filters);
    }

    public IndexInFilter(List<IndexFilter> filters) {
        this.filters = filters;
    }

    @Override
    public Iterator<QueryableEntry> getEntries(InternalIndex index, boolean descending, ExpressionEvalContext evalContext) {
        TreeMap<Comparable, IndexFilter> canonicalFilters = new TreeMap<Comparable, IndexFilter>((o1, o2) -> {
            if (o1 == AbstractIndex.NULL) {
                return o2 == AbstractIndex.NULL ? 0 : (descending ? 1 : -1);
            }
            if (o2 == AbstractIndex.NULL) {
                return descending ? -1 : 1;
            }
            return descending ? o2.compareTo(o1) : o1.compareTo(o2);
        });
        for (IndexFilter filter : this.filters) {
            Comparable filterComparable = filter.getComparable(evalContext);
            if (filterComparable == null) continue;
            filterComparable = index.canonicalizeQueryArgumentScalar(filterComparable);
            canonicalFilters.put(filterComparable, filter);
        }
        if (canonicalFilters.isEmpty()) {
            return Collections.emptyIterator();
        }
        Collection filters = canonicalFilters.values();
        return new LazyIterator(index, descending, evalContext, filters);
    }

    @Override
    public Comparable getComparable(ExpressionEvalContext evalContext) {
        throw new UnsupportedOperationException("Should not be called");
    }

    public List<IndexFilter> getFilters() {
        return this.filters;
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 8;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        SerializationUtil.writeList(this.filters, out);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.filters = SerializationUtil.readList(in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexInFilter that = (IndexInFilter)o;
        return this.filters.equals(that.filters);
    }

    public int hashCode() {
        return this.filters.hashCode();
    }

    public String toString() {
        return "IndexInFilter {filters=" + this.filters + '}';
    }

    private static final class LazyIterator
    extends AbstractCompositeIterator<QueryableEntry> {
        private final InternalIndex index;
        private final ExpressionEvalContext evalContext;
        private final Iterator<IndexFilter> filterIterator;
        private final boolean descending;

        private LazyIterator(InternalIndex index, boolean descending, ExpressionEvalContext evalContext, Collection<IndexFilter> filters) {
            this.index = index;
            this.evalContext = evalContext;
            this.descending = descending;
            this.filterIterator = filters.iterator();
        }

        @Override
        protected Iterator<QueryableEntry> nextIterator() {
            while (this.filterIterator.hasNext()) {
                IndexFilter filter = this.filterIterator.next();
                Iterator<QueryableEntry> iterator = filter.getEntries(this.index, this.descending, this.evalContext);
                if (!iterator.hasNext()) continue;
                return iterator;
            }
            return null;
        }
    }
}

