/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.raft.impl.task;

import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.cp.internal.raft.impl.RaftNodeImpl;
import com.hazelcast.cp.internal.raft.impl.RaftNodeStatus;
import com.hazelcast.cp.internal.raft.impl.state.LeaderState;
import com.hazelcast.cp.internal.raft.impl.state.RaftState;
import com.hazelcast.cp.internal.raft.impl.task.LeadershipTransferTask;
import com.hazelcast.spi.impl.InternalCompletableFuture;

public class InitLeadershipTransferTask
implements Runnable {
    private static final int LEADERSHIP_TRANSFER_RETRY_COUNT = 5;
    private final RaftNodeImpl raftNode;
    private final RaftEndpoint targetEndpoint;
    private final InternalCompletableFuture resultFuture;

    public InitLeadershipTransferTask(RaftNodeImpl raftNode, RaftEndpoint targetEndpoint, InternalCompletableFuture resultFuture) {
        this.raftNode = raftNode;
        this.targetEndpoint = targetEndpoint;
        this.resultFuture = resultFuture;
    }

    @Override
    public void run() {
        if (!this.raftNode.getCommittedMembers().contains(this.targetEndpoint)) {
            this.resultFuture.completeExceptionally(new IllegalArgumentException("Cannot transfer leadership to " + this.targetEndpoint + " because it is not in the committed group member list!"));
            return;
        }
        if (this.raftNode.getStatus() != RaftNodeStatus.ACTIVE) {
            this.resultFuture.completeExceptionally(new IllegalStateException("Cannot transfer leadership to " + this.targetEndpoint + " because the status is " + (Object)((Object)this.raftNode.getStatus())));
            return;
        }
        RaftState state = this.raftNode.state();
        LeaderState leaderState = state.leaderState();
        if (leaderState == null) {
            this.resultFuture.completeExceptionally(new IllegalStateException("Cannot transfer leadership to " + this.targetEndpoint + " because I am not the leader!"));
            return;
        }
        if (this.raftNode.getLocalMember().equals(this.targetEndpoint)) {
            this.raftNode.getLogger(this.getClass()).warning("I am already the leader... There is no leadership transfer to myself.");
            this.resultFuture.complete(null);
            return;
        }
        if (state.initLeadershipTransfer(this.targetEndpoint, this.resultFuture)) {
            new LeadershipTransferTask(this.raftNode, 5).run();
        }
    }
}

