/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.thirdparty.transfrom;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seatunnel.app.domain.request.job.transform.Transform;
import org.apache.seatunnel.app.thirdparty.transfrom.TransformConfigSwitcher;

public enum TransformConfigSwitcherProvider {
    INSTANCE;

    private final Map<Transform, TransformConfigSwitcher> configSwitcherCache;

    private TransformConfigSwitcherProvider() {
        ServiceLoader<TransformConfigSwitcher> loader = ServiceLoader.load(TransformConfigSwitcher.class);
        this.configSwitcherCache = new ConcurrentHashMap<Transform, TransformConfigSwitcher>();
        for (TransformConfigSwitcher switcher : loader) {
            this.configSwitcherCache.put(switcher.getTransform(), switcher);
        }
    }

    public TransformConfigSwitcher getTransformConfigSwitcher(Transform name) {
        return this.configSwitcherCache.get((Object)name);
    }
}

