/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.app.config.ConnectorDataSourceMapperConfig;
import org.apache.seatunnel.app.dal.dao.IDatasourceDao;
import org.apache.seatunnel.app.dal.dao.IJobTaskDao;
import org.apache.seatunnel.app.dal.dao.IVirtualTableDao;
import org.apache.seatunnel.app.dal.entity.Datasource;
import org.apache.seatunnel.app.dal.entity.JobTask;
import org.apache.seatunnel.app.dal.entity.VirtualTable;
import org.apache.seatunnel.app.domain.response.PageInfo;
import org.apache.seatunnel.app.domain.response.datasource.DatasourceDetailRes;
import org.apache.seatunnel.app.domain.response.datasource.DatasourceRes;
import org.apache.seatunnel.app.domain.response.datasource.VirtualTableFieldRes;
import org.apache.seatunnel.app.dynamicforms.FormStructure;
import org.apache.seatunnel.app.permission.enums.SeatunnelResourcePermissionModuleEnum;
import org.apache.seatunnel.app.service.IDatasourceService;
import org.apache.seatunnel.app.service.IJobDefinitionService;
import org.apache.seatunnel.app.service.ITableSchemaService;
import org.apache.seatunnel.app.service.impl.SeatunnelBaseServiceImpl;
import org.apache.seatunnel.app.thirdparty.datasource.DataSourceClientFactory;
import org.apache.seatunnel.app.thirdparty.framework.SeaTunnelOptionRuleWrapper;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.datasource.plugin.api.DataSourcePluginInfo;
import org.apache.seatunnel.datasource.plugin.api.DatasourcePluginTypeEnum;
import org.apache.seatunnel.datasource.plugin.api.model.TableField;
import org.apache.seatunnel.server.common.CodeGenerateUtils;
import org.apache.seatunnel.server.common.SeatunnelErrorEnum;
import org.apache.seatunnel.server.common.SeatunnelException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class DatasourceServiceImpl
extends SeatunnelBaseServiceImpl
implements IDatasourceService,
ApplicationContextAware {
    private static final String VIRTUAL_TABLE_DATABASE_NAME = "default";
    @Autowired
    @Qualifier(value="datasourceDaoImpl")
    private IDatasourceDao datasourceDao;
    private ApplicationContext applicationContext;
    @Resource
    private IJobDefinitionService jobDefinitionService;
    @Resource(name="jobTaskDaoImpl")
    private IJobTaskDao jobTaskDao;
    @Autowired
    @Qualifier(value="virtualTableDaoImpl")
    private IVirtualTableDao virtualTableDao;
    @Autowired
    private ConnectorDataSourceMapperConfig dataSourceMapperConfig;
    protected static final String DEFAULT_DATASOURCE_PLUGIN_VERSION = "1.0.0";

    @Override
    public String createDatasource(Integer userId, String datasourceName, String pluginName, String pluginVersion, String description, Map<String, String> datasourceConfig) throws CodeGenerateUtils.CodeGenerateException {
        this.funcPermissionCheck("datasource:create", userId);
        long uuid = CodeGenerateUtils.getInstance().genCode();
        boolean unique = this.datasourceDao.checkDatasourceNameUnique(datasourceName, 0L);
        if (!unique) {
            throw new SeatunnelException(SeatunnelErrorEnum.DATASOURCE_NAME_ALREADY_EXISTS, new Object[]{datasourceName});
        }
        if (MapUtils.isEmpty(datasourceConfig)) {
            throw new SeatunnelException(SeatunnelErrorEnum.DATASOURCE_PRAM_NOT_ALLOWED_NULL, new Object[]{"datasourceConfig"});
        }
        String datasourceConfigStr = JsonUtils.toJsonString(datasourceConfig);
        Datasource datasource = Datasource.builder().id(uuid).createUserId(userId).updateUserId(userId).datasourceName(datasourceName).pluginName(pluginName).pluginVersion(pluginVersion).description(description).datasourceConfig(datasourceConfigStr).createTime(new Date()).updateTime(new Date()).build();
        boolean success = this.datasourceDao.insertDatasource(datasource);
        if (success) {
            this.resourcePostHandle(SeatunnelResourcePermissionModuleEnum.DATASOURCE.name(), Collections.singletonList(datasource.getId()), userId);
            return String.valueOf(uuid);
        }
        throw new SeatunnelException(SeatunnelErrorEnum.DATASOURCE_CREATE_FAILED);
    }

    @Override
    public boolean updateDatasource(Integer userId, Long datasourceId, String datasourceName, String description, Map<String, String> datasourceConfig) {
        this.funcAndResourcePermissionCheck("datasource:update", SeatunnelResourcePermissionModuleEnum.DATASOURCE.name(), Collections.singletonList(datasourceId), userId);
        if (datasourceId == null) {
            throw new SeatunnelException(SeatunnelErrorEnum.DATASOURCE_PRAM_NOT_ALLOWED_NULL, new Object[]{"datasourceId"});
        }
        Datasource datasource = this.datasourceDao.selectDatasourceById(datasourceId);
        if (datasource == null) {
            throw new SeatunnelException(SeatunnelErrorEnum.DATASOURCE_NOT_FOUND, new Object[]{datasourceId.toString()});
        }
        if (StringUtils.isNotBlank((CharSequence)datasourceName)) {
            datasource.setDatasourceName(datasourceName);
            boolean unique = this.datasourceDao.checkDatasourceNameUnique(datasourceName, datasourceId);
            if (!unique) {
                throw new SeatunnelException(SeatunnelErrorEnum.DATASOURCE_NAME_ALREADY_EXISTS, new Object[]{datasourceName});
            }
        }
        datasource.setUpdateUserId(userId);
        datasource.setUpdateTime(new Date());
        datasource.setDescription(description);
        if (MapUtils.isNotEmpty(datasourceConfig)) {
            String configJson = JsonUtils.toJsonString(datasourceConfig);
            datasource.setDatasourceConfig(configJson);
        }
        return this.datasourceDao.updateDatasourceById(datasource);
    }

    @Override
    public boolean deleteDatasource(Integer userId, Long datasourceId) {
        this.funcAndResourcePermissionCheck("datasource:delete", SeatunnelResourcePermissionModuleEnum.DATASOURCE.name(), Collections.singletonList(datasourceId), userId);
        List<JobTask> jobTaskList = this.jobTaskDao.getJobTaskByDataSourceId(datasourceId);
        if (!CollectionUtils.isEmpty(jobTaskList)) {
            throw new SeatunnelException(SeatunnelErrorEnum.DATA_SOURCE_HAD_USED);
        }
        List<String> virtualDatabaseNames = this.virtualTableDao.getVirtualDatabaseNames(datasourceId);
        if (!CollectionUtils.isEmpty(virtualDatabaseNames)) {
            throw new SeatunnelException(SeatunnelErrorEnum.DATASOURCE_CAN_NOT_DELETE);
        }
        if (!this.jobDefinitionService.getJobVersionByDataSourceId(datasourceId).isEmpty()) {
            throw new SeatunnelException(SeatunnelErrorEnum.DATASOURCE_CAN_NOT_DELETE);
        }
        return this.datasourceDao.deleteDatasourceById(datasourceId);
    }

    @Override
    public boolean testDatasourceConnectionAble(Integer userId, String pluginName, String pluginVersion, Map<String, String> datasourceConfig) {
        this.funcPermissionCheck("datasource:test-connect", userId);
        return DataSourceClientFactory.getDataSourceClient().checkDataSourceConnectivity(pluginName, datasourceConfig);
    }

    @Override
    public boolean testDatasourceConnectionAble(Integer userId, Long datasourceId) {
        this.funcAndResourcePermissionCheck("datasource:test-connect", SeatunnelResourcePermissionModuleEnum.DATASOURCE.name(), Collections.singletonList(datasourceId), userId);
        Datasource datasource = this.datasourceDao.selectDatasourceById(datasourceId);
        if (datasource == null) {
            throw new SeatunnelException(SeatunnelErrorEnum.DATASOURCE_NOT_FOUND, new Object[]{datasourceId.toString()});
        }
        String configJson = datasource.getDatasourceConfig();
        Map datasourceConfig = JsonUtils.toMap((String)configJson, String.class, String.class);
        String pluginName = datasource.getPluginName();
        return DataSourceClientFactory.getDataSourceClient().checkDataSourceConnectivity(pluginName, datasourceConfig);
    }

    @Override
    public String queryDatasourceNameById(String datasourceId) {
        long datasourceIdLong = Long.parseLong(datasourceId);
        return this.datasourceDao.queryDatasourceNameById(datasourceIdLong);
    }

    @Override
    public String getDynamicForm(String pluginName) {
        this.funcPermissionCheck("datasource:dynamic", 0);
        OptionRule optionRule = DataSourceClientFactory.getDataSourceClient().queryDataSourceFieldByName(pluginName);
        String connectorForDatasourceName = this.dataSourceMapperConfig.findConnectorForDatasourceName(pluginName).orElse(pluginName);
        FormStructure testForm = SeaTunnelOptionRuleWrapper.wrapper(optionRule, connectorForDatasourceName);
        return JsonUtils.toJsonString((Object)testForm);
    }

    @Override
    public boolean checkDatasourceNameUnique(Integer userId, String datasourceName, Long dataSourceId) {
        if (StringUtils.isNotBlank((CharSequence)datasourceName)) {
            return this.datasourceDao.checkDatasourceNameUnique(datasourceName, dataSourceId);
        }
        return false;
    }

    @Override
    public List<String> queryDatabaseByDatasourceName(String datasourceName) {
        this.funcPermissionCheck("datasource:databases", 0);
        Datasource datasource = this.datasourceDao.queryDatasourceByName(datasourceName);
        if (null == datasource) {
            throw new SeatunnelException(SeatunnelErrorEnum.DATASOURCE_NOT_FOUND, new Object[]{datasourceName});
        }
        String pluginName = datasource.getPluginName();
        if (Boolean.FALSE.equals(this.checkIsSupportVirtualTable(pluginName))) {
            String config = datasource.getDatasourceConfig();
            Map datasourceConfig = JsonUtils.toMap((String)config, String.class, String.class);
            return DataSourceClientFactory.getDataSourceClient().getDatabases(pluginName, datasourceConfig);
        }
        long dataSourceId = datasource.getId();
        boolean hasVirtualTable = this.virtualTableDao.checkHasVirtualTable(dataSourceId);
        if (hasVirtualTable) {
            return Collections.singletonList(VIRTUAL_TABLE_DATABASE_NAME);
        }
        return new ArrayList<String>();
    }

    private boolean checkIsSupportVirtualTable(String pluginName) {
        return DataSourceClientFactory.getDataSourceClient().listAllDataSources().stream().anyMatch(d -> d.getName().equals(pluginName) && d.getSupportVirtualTables() != false);
    }

    @Override
    public List<String> queryTableNames(String datasourceName, String databaseName, String filterName, Integer size) {
        this.funcPermissionCheck("datasource:table", 0);
        Datasource datasource = this.datasourceDao.queryDatasourceByName(datasourceName);
        if (null == datasource) {
            throw new SeatunnelException(SeatunnelErrorEnum.DATASOURCE_NOT_FOUND, new Object[]{datasourceName});
        }
        String config = datasource.getDatasourceConfig();
        Map datasourceConfig = JsonUtils.toMap((String)config, String.class, String.class);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("size", size.toString());
        options.put("filterName", filterName);
        String pluginName = datasource.getPluginName();
        if (BooleanUtils.isNotTrue((Boolean)this.checkIsSupportVirtualTable(pluginName))) {
            return DataSourceClientFactory.getDataSourceClient().getTables(pluginName, databaseName, datasourceConfig, options);
        }
        long dataSourceId = datasource.getId();
        return this.virtualTableDao.getVirtualTableNames(VIRTUAL_TABLE_DATABASE_NAME, dataSourceId);
    }

    @Override
    public List<String> queryTableNames(String datasourceName, String databaseName) {
        this.funcPermissionCheck("datasource:table", 0);
        Datasource datasource = this.datasourceDao.queryDatasourceByName(datasourceName);
        if (null == datasource) {
            throw new SeatunnelException(SeatunnelErrorEnum.DATASOURCE_NOT_FOUND, new Object[]{datasourceName});
        }
        String config = datasource.getDatasourceConfig();
        Map datasourceConfig = JsonUtils.toMap((String)config, String.class, String.class);
        HashMap options = new HashMap();
        String pluginName = datasource.getPluginName();
        if (BooleanUtils.isNotTrue((Boolean)this.checkIsSupportVirtualTable(pluginName))) {
            return DataSourceClientFactory.getDataSourceClient().getTables(pluginName, databaseName, datasourceConfig, options);
        }
        long dataSourceId = datasource.getId();
        return this.virtualTableDao.getVirtualTableNames(VIRTUAL_TABLE_DATABASE_NAME, dataSourceId);
    }

    @Override
    public List<TableField> queryTableSchema(String datasourceName, String databaseName, String tableName) {
        this.funcPermissionCheck("datasource:table-schema", 0);
        Datasource datasource = this.datasourceDao.queryDatasourceByName(datasourceName);
        if (null == datasource) {
            throw new SeatunnelException(SeatunnelErrorEnum.DATASOURCE_NOT_FOUND, new Object[]{datasourceName});
        }
        String config = datasource.getDatasourceConfig();
        Map datasourceConfig = JsonUtils.toMap((String)config, String.class, String.class);
        String pluginName = datasource.getPluginName();
        ITableSchemaService tableSchemaService = (ITableSchemaService)this.applicationContext.getBean("tableSchemaServiceImpl");
        if (BooleanUtils.isNotTrue((Boolean)this.checkIsSupportVirtualTable(pluginName))) {
            List tableFields = DataSourceClientFactory.getDataSourceClient().getTableFields(pluginName, datasourceConfig, databaseName, tableName);
            tableSchemaService.getAddSeaTunnelSchema(tableFields, pluginName);
            return tableFields;
        }
        VirtualTable virtualTable = this.virtualTableDao.selectVirtualTableByTableName(tableName);
        if (virtualTable == null) {
            throw new SeatunnelException(SeatunnelErrorEnum.VIRTUAL_TABLE_NOT_FOUND, new Object[]{tableName});
        }
        List<TableField> tableFields = this.convertTableSchema(virtualTable.getTableFields());
        tableSchemaService.getAddSeaTunnelSchema(tableFields, pluginName);
        return tableFields;
    }

    private List<TableField> convertTableSchema(String virtualTableFieldJson) {
        ArrayList<TableField> fields = new ArrayList<TableField>();
        List virtualTableFields = JsonUtils.toList((String)virtualTableFieldJson, VirtualTableFieldRes.class);
        if (CollectionUtils.isEmpty((Collection)virtualTableFields)) {
            return fields;
        }
        virtualTableFields.forEach(virtualTableField -> {
            TableField tableField = new TableField();
            tableField.setPrimaryKey(virtualTableField.getPrimaryKey());
            tableField.setName(virtualTableField.getFieldName());
            tableField.setType(virtualTableField.getFieldType());
            tableField.setComment(virtualTableField.getFieldComment());
            tableField.setNullable(virtualTableField.getNullable());
            tableField.setDefaultValue(virtualTableField.getDefaultValue());
            fields.add(tableField);
        });
        return fields;
    }

    @Override
    public PageInfo<DatasourceRes> queryDatasourceList(Integer userId, String searchVal, String pluginName, Integer pageNo, Integer pageSize) {
        this.funcPermissionCheck("datasource:list", userId);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        PageInfo<DatasourceRes> pageInfo = new PageInfo<DatasourceRes>();
        List ids = this.availableResourceRange(SeatunnelResourcePermissionModuleEnum.DATASOURCE.name(), userId);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)ids)) {
            return pageInfo;
        }
        IPage<Datasource> datasourcePage = this.datasourceDao.selectDatasourceByParam((Page<Datasource>)page, ids, searchVal, pluginName);
        pageInfo = new PageInfo();
        pageInfo.setPageNo((int)datasourcePage.getPages());
        pageInfo.setPageSize((int)datasourcePage.getSize());
        pageInfo.setTotalCount((int)datasourcePage.getTotal());
        if (CollectionUtils.isEmpty((Collection)datasourcePage.getRecords())) {
            pageInfo.setData(new ArrayList());
            return pageInfo;
        }
        ArrayList userIds = new ArrayList();
        datasourcePage.getRecords().forEach(datasource -> {
            userIds.add(datasource.getCreateUserId());
            userIds.add(datasource.getUpdateUserId());
        });
        List datasourceResList = datasourcePage.getRecords().stream().map(datasource -> {
            DatasourceRes datasourceRes = new DatasourceRes();
            datasourceRes.setId(datasource.getId().toString());
            datasourceRes.setDatasourceName(datasource.getDatasourceName());
            datasourceRes.setPluginName(datasource.getPluginName());
            datasourceRes.setPluginVersion(datasource.getPluginVersion());
            datasourceRes.setDescription(datasource.getDescription());
            datasourceRes.setCreateTime(datasource.getCreateTime());
            datasourceRes.setUpdateTime(datasource.getUpdateTime());
            Map datasourceConfig = JsonUtils.toMap((String)datasource.getDatasourceConfig(), String.class, String.class);
            datasourceRes.setDatasourceConfig(datasourceConfig);
            datasourceRes.setCreateUserId(datasource.getCreateUserId());
            datasourceRes.setUpdateUserId(datasource.getUpdateUserId());
            datasourceRes.setUpdateTime(datasource.getUpdateTime());
            return datasourceRes;
        }).collect(Collectors.toList());
        pageInfo.setData(datasourceResList);
        return pageInfo;
    }

    @Override
    public List<DataSourcePluginInfo> queryAllDatasources() {
        this.funcPermissionCheck("datasource:query-all", 0);
        return DataSourceClientFactory.getDataSourceClient().listAllDataSources();
    }

    @Override
    public List<DataSourcePluginInfo> queryAllDatasourcesByType(Integer type) {
        this.funcPermissionCheck("datasource:query-all", 0);
        return DataSourceClientFactory.getDataSourceClient().listAllDataSources().stream().map(dataSourcePluginInfo -> type.equals(dataSourcePluginInfo.getType()) ? dataSourcePluginInfo : null).collect(Collectors.toList());
    }

    @Override
    public Map<Integer, List<DataSourcePluginInfo>> queryAllDatasourcesGroupByType(Boolean onlyShowVirtualDatasource) {
        this.funcPermissionCheck("datasource:query-all", 0);
        HashMap<Integer, List<DataSourcePluginInfo>> dataSourcePluginInfoMap = new HashMap<Integer, List<DataSourcePluginInfo>>();
        for (DatasourcePluginTypeEnum value : DatasourcePluginTypeEnum.values()) {
            dataSourcePluginInfoMap.put(value.getCode(), new ArrayList());
        }
        List dataSourcePluginInfos = DataSourceClientFactory.getDataSourceClient().listAllDataSources();
        for (DataSourcePluginInfo dataSourcePluginInfo : dataSourcePluginInfos) {
            List dataSourcePluginInfoList;
            if (BooleanUtils.isNotTrue((Boolean)onlyShowVirtualDatasource)) {
                dataSourcePluginInfoList = dataSourcePluginInfoMap.computeIfAbsent(dataSourcePluginInfo.getType(), k -> new ArrayList());
                dataSourcePluginInfoList.add(dataSourcePluginInfo);
                continue;
            }
            if (!Boolean.TRUE.equals(dataSourcePluginInfo.getSupportVirtualTables())) continue;
            dataSourcePluginInfoList = dataSourcePluginInfoMap.computeIfAbsent(dataSourcePluginInfo.getType(), k -> new ArrayList());
            dataSourcePluginInfoList.add(dataSourcePluginInfo);
        }
        return dataSourcePluginInfoMap;
    }

    @Override
    public Map<String, String> queryDatasourceConfigById(String datasourceId) {
        long datasourceIdLong = Long.parseLong(datasourceId);
        Datasource datasource = this.datasourceDao.selectDatasourceById(datasourceIdLong);
        if (null == datasource) {
            throw new SeatunnelException(SeatunnelErrorEnum.DATASOURCE_NOT_FOUND, new Object[]{datasourceId});
        }
        String configJson = datasource.getDatasourceConfig();
        return JsonUtils.toMap((String)configJson, String.class, String.class);
    }

    @Override
    public Map<String, String> queryDatasourceNameByPluginName(String pluginName) {
        HashMap<String, String> datasourceNameMap = new HashMap<String, String>();
        List<Datasource> datasourceList = this.datasourceDao.selectDatasourceByPluginName(pluginName, DEFAULT_DATASOURCE_PLUGIN_VERSION);
        datasourceList.forEach(datasource -> datasourceNameMap.put(datasource.getId().toString(), datasource.getDatasourceName()));
        return datasourceNameMap;
    }

    @Override
    public OptionRule queryOptionRuleByPluginName(String pluginName) {
        return DataSourceClientFactory.getDataSourceClient().queryDataSourceFieldByName(pluginName);
    }

    @Override
    public OptionRule queryVirtualTableOptionRuleByPluginName(String pluginName) {
        if (this.checkIsSupportVirtualTable(pluginName)) {
            return DataSourceClientFactory.getDataSourceClient().queryMetadataFieldByName(pluginName);
        }
        return OptionRule.builder().build();
    }

    @Override
    public List<DatasourceDetailRes> queryDatasourceDetailListByDatasourceIds(List<String> datasourceIds) {
        if (CollectionUtils.isEmpty(datasourceIds)) {
            return new ArrayList<DatasourceDetailRes>();
        }
        this.funcAndResourcePermissionCheck("datasource:detail-list", SeatunnelResourcePermissionModuleEnum.DATASOURCE.name(), datasourceIds, 0);
        List<Long> datasourceIdsLong = datasourceIds.stream().map(Long::parseLong).collect(Collectors.toList());
        List<Datasource> datasourceList = this.datasourceDao.selectDatasourceByIds(datasourceIdsLong);
        return this.convertDatasourceDetailRes(datasourceList);
    }

    private List<DatasourceDetailRes> convertDatasourceDetailRes(List<Datasource> datasourceList) {
        if (CollectionUtils.isEmpty(datasourceList)) {
            return new ArrayList<DatasourceDetailRes>();
        }
        ArrayList userIds = new ArrayList();
        datasourceList.forEach(datasource -> {
            if (null != datasource.getCreateUserId()) {
                userIds.add(datasource.getCreateUserId());
            }
            if (null != datasource.getUpdateUserId()) {
                userIds.add(datasource.getUpdateUserId());
            }
        });
        ArrayList<DatasourceDetailRes> datasourceDetailResList = new ArrayList<DatasourceDetailRes>();
        datasourceList.forEach(datasource -> {
            DatasourceDetailRes datasourceDetailRes = new DatasourceDetailRes();
            datasourceDetailRes.setId(datasource.getId().toString());
            datasourceDetailRes.setDatasourceName(datasource.getDatasourceName());
            datasourceDetailRes.setPluginName(datasource.getPluginName());
            datasourceDetailRes.setPluginVersion(datasource.getPluginVersion());
            datasourceDetailRes.setDescription(datasource.getDescription());
            datasourceDetailRes.setCreateTime(datasource.getCreateTime());
            datasourceDetailRes.setUpdateTime(datasource.getUpdateTime());
            Map config = JsonUtils.toMap((String)datasource.getDatasourceConfig());
            datasourceDetailRes.setDatasourceConfig(config);
            datasourceDetailResList.add(datasourceDetailRes);
        });
        return datasourceDetailResList;
    }

    @Override
    public List<DatasourceDetailRes> queryAllDatasourcesInstance() {
        List<Datasource> datasourceList = this.datasourceDao.queryAll();
        return this.convertDatasourceDetailRes(datasourceList);
    }

    @Override
    public DatasourceDetailRes queryDatasourceDetailByDatasourceName(String datasourceName) {
        this.funcPermissionCheck("datasource:detail", 0);
        Datasource datasource = this.datasourceDao.queryDatasourceByName(datasourceName);
        if (null == datasource) {
            throw new SeatunnelException(SeatunnelErrorEnum.DATASOURCE_NOT_FOUND, new Object[]{datasourceName});
        }
        DatasourceDetailRes datasourceDetailRes = new DatasourceDetailRes();
        datasourceDetailRes.setId(datasource.getId().toString());
        datasourceDetailRes.setDatasourceName(datasource.getDatasourceName());
        datasourceDetailRes.setPluginName(datasource.getPluginName());
        datasourceDetailRes.setPluginVersion(datasource.getPluginVersion());
        datasourceDetailRes.setDescription(datasource.getDescription());
        datasourceDetailRes.setCreateTime(datasource.getCreateTime());
        datasourceDetailRes.setUpdateTime(datasource.getUpdateTime());
        Map datasourceConfig = JsonUtils.toMap((String)datasource.getDatasourceConfig(), String.class, String.class);
        datasourceDetailRes.setDatasourceConfig(datasourceConfig);
        return datasourceDetailRes;
    }

    @Override
    public DatasourceDetailRes queryDatasourceDetailById(String datasourceId) {
        long datasourceIdLong = Long.parseLong(datasourceId);
        this.funcPermissionCheck("datasource:detail", 0);
        Datasource datasource = this.datasourceDao.selectDatasourceById(datasourceIdLong);
        if (null == datasource) {
            throw new SeatunnelException(SeatunnelErrorEnum.DATASOURCE_NOT_FOUND, new Object[]{datasourceId});
        }
        DatasourceDetailRes datasourceDetailRes = new DatasourceDetailRes();
        datasourceDetailRes.setId(datasource.getId().toString());
        datasourceDetailRes.setDatasourceName(datasource.getDatasourceName());
        datasourceDetailRes.setPluginName(datasource.getPluginName());
        datasourceDetailRes.setPluginVersion(datasource.getPluginVersion());
        datasourceDetailRes.setDescription(datasource.getDescription());
        datasourceDetailRes.setCreateTime(datasource.getCreateTime());
        datasourceDetailRes.setUpdateTime(datasource.getUpdateTime());
        Map datasourceConfig = JsonUtils.toMap((String)datasource.getDatasourceConfig(), String.class, String.class);
        datasourceDetailRes.setDatasourceConfig(datasourceConfig);
        return datasourceDetailRes;
    }

    @Override
    public DatasourceDetailRes queryDatasourceDetailById(Integer userId, String datasourceId) {
        this.funcAndResourcePermissionCheck("datasource:detail", SeatunnelResourcePermissionModuleEnum.DATASOURCE.name(), Collections.singletonList(Long.parseLong(datasourceId)), userId);
        return this.queryDatasourceDetailById(datasourceId);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

