/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.targets;

import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.royale.abc.ABCEmitter;
import org.apache.royale.abc.instructionlist.InstructionList;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.references.IResolvedQualifiersReference;
import org.apache.royale.compiler.definitions.references.ReferenceFactory;
import org.apache.royale.compiler.internal.abc.ClassGeneratorHelper;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.targets.LibrarySWFTarget;
import org.apache.royale.compiler.internal.targets.RoyaleFrame1Info;
import org.apache.royale.compiler.internal.targets.RoyaleLibraryFrame1Info;
import org.apache.royale.compiler.internal.targets.RoyaleTarget;
import org.apache.royale.compiler.internal.targets.SWFTarget;
import org.apache.royale.compiler.internal.targets.Target;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.ResourceBundleNotFoundForLocaleProblem;
import org.apache.royale.compiler.problems.ResourceBundleNotFoundProblem;
import org.apache.royale.compiler.targets.ITargetSettings;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.swf.ISWF;
import org.apache.royale.swf.SWFFrame;
import org.apache.royale.swf.tags.DoABCTag;

public final class RoyaleLibrarySWFTarget
extends LibrarySWFTarget {
    private final RoyaleProject royaleProject;
    private ModuleFactoryInfo moduleFactoryInfo;
    private final FlexDelegate delegate;

    public RoyaleLibrarySWFTarget(RoyaleProject project, ITargetSettings targetSettings, Set<ICompilationUnit> rootedCompilationUnits) {
        super((CompilerProject)project, targetSettings, rootedCompilationUnits);
        this.royaleProject = project;
        this.delegate = new FlexDelegate(targetSettings, project);
        this.isLibrary = true;
    }

    private ModuleFactoryInfo computeModuleFactoryInfo() {
        IResolvedQualifiersReference moduleFactoryBaseClassReference = ReferenceFactory.packageQualifiedReference(this.royaleProject.getWorkspace(), this.getBaseClassQName());
        IDefinition moduleFactoryBaseClassDef = moduleFactoryBaseClassReference.resolve(this.royaleProject);
        if (!(moduleFactoryBaseClassDef instanceof ClassDefinition)) {
            return ModuleFactoryInfo.create(Collections.emptyList());
        }
        ClassDefinition moduleFactoryBaseClass = (ClassDefinition)moduleFactoryBaseClassDef;
        ICompilationUnit moduleFactoryBaseClassCompilationUnit = this.royaleProject.getScope().getCompilationUnitForDefinition(moduleFactoryBaseClass);
        assert (moduleFactoryBaseClassCompilationUnit != null) : "Unable to find compilation unit for definition!";
        return ModuleFactoryInfo.create(this.getGeneratedModuleFactoryClassName(moduleFactoryBaseClass), moduleFactoryBaseClass, moduleFactoryBaseClassCompilationUnit);
    }

    private ModuleFactoryInfo getModuleFactoryInfo() {
        if (this.moduleFactoryInfo != null) {
            return this.moduleFactoryInfo;
        }
        this.moduleFactoryInfo = this.computeModuleFactoryInfo();
        return this.moduleFactoryInfo;
    }

    @Override
    public String getBaseClassQName() {
        return "EmptyModuleFactory";
    }

    @Override
    protected SWFTarget.FramesInformation computeFramesInformation() throws InterruptedException {
        ModuleFactoryInfo moduleFactoryInfo = this.getModuleFactoryInfo();
        if (!moduleFactoryInfo.generateModuleFactory()) {
            return super.computeFramesInformation();
        }
        Sets.SetView compilationUnits = Sets.union(Collections.singleton(moduleFactoryInfo.moduleFactoryBaseClassCompilationUnit), (Set)this.rootedCompilationUnits);
        SWFTarget.SWFFrameInfo frameInfo = new SWFTarget.SWFFrameInfo(null, true, (Set<ICompilationUnit>)compilationUnits, moduleFactoryInfo.problems);
        RoyaleLibrarySWFFramesInformation framesInfo = new RoyaleLibrarySWFFramesInformation(frameInfo);
        return framesInfo;
    }

    private String getGeneratedModuleFactoryClassName(IClassDefinition moduleFactoryBaseClass) {
        File outputFile = this.targetSettings.getOutput();
        Object outputName = null;
        String absolutePath = null;
        if (outputFile != null) {
            int endIndex;
            absolutePath = outputFile.getAbsolutePath();
            String name = outputFile.getName();
            if (name != null && (endIndex = name.lastIndexOf(46)) != -1) {
                name = name.substring(0, endIndex);
            }
            outputName = name + "_" + absolutePath.hashCode();
        }
        assert (outputName != null) : "Provide an output name for the SWC by setting -output";
        if (outputName == null) {
            outputName = Long.toHexString(System.nanoTime());
        }
        Object generatedRootName = "_" + (String)outputName + "_" + moduleFactoryBaseClass.getQualifiedName();
        generatedRootName = ((String)generatedRootName).replaceAll("[^a-zA-Z0-9]", "_");
        return generatedRootName;
    }

    @Override
    protected Target.DirectDependencies getDirectDependencies(ICompilationUnit cu) throws InterruptedException {
        Target.DirectDependencies directDependencies = super.getDirectDependencies(cu);
        if (!this.targetSettings.isAccessible()) {
            return directDependencies;
        }
        Target.DirectDependencies acccessibilityDependencies = this.delegate.getAccessibilityDependencies(cu);
        return Target.DirectDependencies.concat(directDependencies, acccessibilityDependencies);
    }

    @Override
    protected void waitForCompilationUnitToFinish(ICompilationUnit cu, final Collection<ICompilerProblem> problems) throws InterruptedException {
        Collection<ICompilerProblem> problemsWithFilter = problems;
        if (this.getLinkageChecker().isExternal(cu)) {
            problemsWithFilter = new ForwardingCollection<ICompilerProblem>(){

                protected final Collection<ICompilerProblem> delegate() {
                    return problems;
                }

                public final boolean add(ICompilerProblem element) {
                    if (element instanceof ResourceBundleNotFoundProblem) {
                        return false;
                    }
                    if (element instanceof ResourceBundleNotFoundForLocaleProblem) {
                        return false;
                    }
                    return super.add((Object)element);
                }

                public final boolean addAll(Collection<? extends ICompilerProblem> collection) {
                    boolean result = false;
                    for (ICompilerProblem iCompilerProblem : collection) {
                        if (!this.add(iCompilerProblem)) continue;
                        result = true;
                    }
                    return result;
                }
            };
        }
        super.waitForCompilationUnitToFinish(cu, problemsWithFilter);
    }

    @Override
    protected ISWF initializeSWF(List<ICompilationUnit> reachableCompilationUnits) throws InterruptedException {
        ISWF swf = super.initializeSWF(reachableCompilationUnits);
        this.delegate.addProductInfoToSWF(swf);
        return swf;
    }

    private class FlexDelegate
    extends RoyaleTarget {
        FlexDelegate(ITargetSettings targetSettings, RoyaleProject project) {
            super(targetSettings, project);
        }

        private boolean addGeneratedRootClassToSWFFrame(SWFFrame frame, ISWF swf, ModuleFactoryInfo moduleFactoryInfo, ImmutableSet<ICompilationUnit> emittedCompilationUnits, Collection<ICompilerProblem> problemCollection) throws InterruptedException {
            ABCEmitter emitter = new ABCEmitter();
            emitter.visit(46, 16);
            String generatedRootClassNameString = moduleFactoryInfo.generatedModuleFactoryClassName;
            Name generatedRootName = new Name(generatedRootClassNameString);
            InstructionList classITraitsInit = new InstructionList();
            classITraitsInit.addInstruction(208);
            classITraitsInit.addInstruction(73, 0);
            classITraitsInit.addInstruction(71);
            ClassGeneratorHelper classGen = new ClassGeneratorHelper(RoyaleLibrarySWFTarget.this.project, emitter, generatedRootName, (ClassDefinition)moduleFactoryInfo.moduleFactoryBaseClass, Collections.emptyList(), classITraitsInit);
            IResolvedQualifiersReference objectReference = ReferenceFactory.packageQualifiedReference(RoyaleLibrarySWFTarget.this.project.getWorkspace(), "Object");
            this.codegenCallInContextMethod(classGen, true);
            RoyaleLibraryFrame1Info frame1Info = new RoyaleLibraryFrame1Info(this.royaleProject, emittedCompilationUnits);
            if (!frame1Info.embeddedFonts.isEmpty()) {
                this.codegenCreateMethod(classGen, objectReference.getMName(), true);
                this.codegenInfoMethod(classGen, "Object", frame1Info, this.accessibleClassNames, problemCollection);
            }
            classGen.finishScript();
            DoABCTag doABC = new DoABCTag();
            try {
                doABC.setABCData(emitter.emit());
            }
            catch (Exception e) {
                return false;
            }
            doABC.setName(generatedRootClassNameString);
            frame.addTag(doABC);
            return true;
        }

        private void codegenInfoMethod(ClassGeneratorHelper classGen, String rootClassQName, RoyaleFrame1Info frame1Info, Set<String> accessibleClassNames, Collection<ICompilerProblem> problemCollection) throws InterruptedException {
            this.codegenInfoMethod(classGen, null, rootClassQName, null, null, null, null, null, null, frame1Info, accessibleClassNames, null, null, null, null, problemCollection, false, false, null);
        }
    }

    private static class ModuleFactoryInfo {
        final IClassDefinition moduleFactoryBaseClass;
        final ICompilationUnit moduleFactoryBaseClassCompilationUnit;
        final Iterable<ICompilerProblem> problems;
        final String generatedModuleFactoryClassName;

        static ModuleFactoryInfo create(Iterable<ICompilerProblem> problems) {
            return new ModuleFactoryInfo(null, null, null, problems);
        }

        static ModuleFactoryInfo create(String generatedModuleFactoryClassName, IClassDefinition moduleFactoryBaseClass, ICompilationUnit moduleFactoryBaseClassCompilationUnit) {
            assert (generatedModuleFactoryClassName != null);
            assert (moduleFactoryBaseClass != null);
            assert (moduleFactoryBaseClassCompilationUnit != null);
            return new ModuleFactoryInfo(generatedModuleFactoryClassName, moduleFactoryBaseClass, moduleFactoryBaseClassCompilationUnit, Collections.emptyList());
        }

        private ModuleFactoryInfo(String generatedModuleFactoryClassName, IClassDefinition moduleFactoryBaseClass, ICompilationUnit moduleFactoryBaseClassCompilationUnit, Iterable<ICompilerProblem> problems) {
            this.moduleFactoryBaseClass = moduleFactoryBaseClass;
            this.moduleFactoryBaseClassCompilationUnit = moduleFactoryBaseClassCompilationUnit;
            this.problems = problems;
            this.generatedModuleFactoryClassName = generatedModuleFactoryClassName;
        }

        boolean generateModuleFactory() {
            return this.moduleFactoryBaseClass != null;
        }
    }

    private class RoyaleLibrarySWFFramesInformation
    extends SWFTarget.FramesInformation {
        RoyaleLibrarySWFFramesInformation(SWFTarget.SWFFrameInfo frameInfo) {
            super(Collections.singletonList(frameInfo));
        }

        @Override
        protected void createFrames(SWFTarget swfTarget, ISWF swf, ImmutableSet<ICompilationUnit> builtCompilationUnits, Set<ICompilationUnit> emittedCompilationUnits, Collection<ICompilerProblem> problems) throws InterruptedException {
            assert (Iterables.size((Iterable)this.frameInfos) == 1);
            SWFTarget.SWFFrameInfo frameInfo = (SWFTarget.SWFFrameInfo)Iterables.getOnlyElement((Iterable)this.frameInfos);
            SWFFrame frame = this.createFrame(swfTarget, frameInfo, builtCompilationUnits, emittedCompilationUnits, problems);
            ModuleFactoryInfo moduleFactoryInfo = RoyaleLibrarySWFTarget.this.getModuleFactoryInfo();
            RoyaleLibrarySWFTarget.this.delegate.addGeneratedRootClassToSWFFrame(frame, swf, moduleFactoryInfo, builtCompilationUnits, problems);
            swf.addFrame(frame);
            swf.setTopLevelClass(moduleFactoryInfo.generatedModuleFactoryClassName);
        }
    }
}

