/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Sets;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.ViewBuilder;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.rocketmq.common.BoundaryType;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.topic.TopicValidator;
import org.apache.rocketmq.store.CommitLogDispatcher;
import org.apache.rocketmq.store.GetMessageResult;
import org.apache.rocketmq.store.GetMessageStatus;
import org.apache.rocketmq.store.MessageFilter;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.QueryMessageResult;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.plugin.AbstractPluginMessageStore;
import org.apache.rocketmq.store.plugin.MessageStorePluginContext;
import org.apache.rocketmq.tieredstore.MessageStoreConfig;
import org.apache.rocketmq.tieredstore.MessageStoreExecutor;
import org.apache.rocketmq.tieredstore.core.MessageStoreDispatcher;
import org.apache.rocketmq.tieredstore.core.MessageStoreDispatcherImpl;
import org.apache.rocketmq.tieredstore.core.MessageStoreFetcher;
import org.apache.rocketmq.tieredstore.core.MessageStoreFetcherImpl;
import org.apache.rocketmq.tieredstore.core.MessageStoreFilter;
import org.apache.rocketmq.tieredstore.core.MessageStoreTopicFilter;
import org.apache.rocketmq.tieredstore.file.FlatFileStore;
import org.apache.rocketmq.tieredstore.file.FlatMessageFile;
import org.apache.rocketmq.tieredstore.index.IndexService;
import org.apache.rocketmq.tieredstore.index.IndexStoreService;
import org.apache.rocketmq.tieredstore.metadata.MetadataStore;
import org.apache.rocketmq.tieredstore.metrics.TieredStoreMetricsManager;
import org.apache.rocketmq.tieredstore.util.MessageStoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TieredMessageStore
extends AbstractPluginMessageStore {
    protected static final Logger log = LoggerFactory.getLogger((String)"RocketmqTieredStore");
    protected final String brokerName;
    protected final MessageStore defaultStore;
    protected final MessageStoreConfig storeConfig = new MessageStoreConfig();
    protected final MessageStorePluginContext context;
    protected final MetadataStore metadataStore;
    protected final MessageStoreExecutor storeExecutor;
    protected final IndexService indexService;
    protected final FlatFileStore flatFileStore;
    protected final MessageStoreFilter topicFilter;
    protected final MessageStoreFetcher fetcher;
    protected final MessageStoreDispatcher dispatcher;

    public TieredMessageStore(MessageStorePluginContext context, MessageStore next) {
        super(context, next);
        this.context = context;
        this.context.registerConfiguration((Object)this.storeConfig);
        this.brokerName = this.storeConfig.getBrokerName();
        this.defaultStore = next;
        this.metadataStore = this.getMetadataStore(this.storeConfig);
        this.topicFilter = new MessageStoreTopicFilter(this.storeConfig);
        this.storeExecutor = new MessageStoreExecutor();
        this.flatFileStore = new FlatFileStore(this.storeConfig, this.metadataStore, this.storeExecutor);
        this.indexService = new IndexStoreService(this.flatFileStore.getFlatFileFactory(), MessageStoreUtil.getIndexFilePath(this.storeConfig.getBrokerName()));
        this.fetcher = new MessageStoreFetcherImpl(this);
        this.dispatcher = new MessageStoreDispatcherImpl(this);
        next.addDispatcher((CommitLogDispatcher)this.dispatcher);
    }

    public boolean load() {
        boolean result;
        boolean loadFlatFile = this.flatFileStore.load();
        boolean loadNextStore = this.next.load();
        boolean bl = result = loadFlatFile && loadNextStore;
        if (result) {
            this.indexService.start();
            this.dispatcher.start();
            this.storeExecutor.commonExecutor.scheduleWithFixedDelay(this.flatFileStore::scheduleDeleteExpireFile, this.storeConfig.getTieredStoreDeleteFileInterval(), this.storeConfig.getTieredStoreDeleteFileInterval(), TimeUnit.MILLISECONDS);
        }
        return result;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public MessageStoreConfig getStoreConfig() {
        return this.storeConfig;
    }

    public MessageStore getDefaultStore() {
        return this.defaultStore;
    }

    private MetadataStore getMetadataStore(MessageStoreConfig storeConfig) {
        try {
            Class<MetadataStore> clazz = Class.forName(storeConfig.getTieredMetadataServiceProvider()).asSubclass(MetadataStore.class);
            Constructor<MetadataStore> constructor = clazz.getConstructor(MessageStoreConfig.class);
            return constructor.newInstance(storeConfig);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public MetadataStore getMetadataStore() {
        return this.metadataStore;
    }

    public MessageStoreFilter getTopicFilter() {
        return this.topicFilter;
    }

    public MessageStoreExecutor getStoreExecutor() {
        return this.storeExecutor;
    }

    public FlatFileStore getFlatFileStore() {
        return this.flatFileStore;
    }

    public IndexService getIndexService() {
        return this.indexService;
    }

    public boolean fetchFromCurrentStore(String topic, int queueId, long offset) {
        return this.fetchFromCurrentStore(topic, queueId, offset, 1);
    }

    public boolean fetchFromCurrentStore(String topic, int queueId, long offset, int batchSize) {
        MessageStoreConfig.TieredStorageLevel storageLevel = this.storeConfig.getTieredStorageLevel();
        if (storageLevel.check(MessageStoreConfig.TieredStorageLevel.FORCE)) {
            return true;
        }
        if (!storageLevel.isEnable()) {
            return false;
        }
        FlatMessageFile flatFile = this.flatFileStore.getFlatFile(new MessageQueue(topic, this.brokerName, queueId));
        if (flatFile == null) {
            return false;
        }
        if (offset >= flatFile.getConsumeQueueCommitOffset()) {
            return false;
        }
        if (storageLevel.check(MessageStoreConfig.TieredStorageLevel.NOT_IN_DISK)) {
            if (this.next != null && this.next.getCommitLog() != null && this.next.getCommitLog().getMinOffset() < 0L) {
                return true;
            }
            if (!this.next.checkInStoreByConsumeOffset(topic, queueId, offset)) {
                return true;
            }
        }
        return storageLevel.check(MessageStoreConfig.TieredStorageLevel.NOT_IN_MEM) && !this.next.checkInMemByConsumeOffset(topic, queueId, offset, batchSize);
    }

    public GetMessageResult getMessage(String group, String topic, int queueId, long offset, int maxMsgNums, MessageFilter messageFilter) {
        return this.getMessageAsync(group, topic, queueId, offset, maxMsgNums, messageFilter).join();
    }

    public CompletableFuture<GetMessageResult> getMessageAsync(String group, String topic, int queueId, long offset, int maxMsgNums, MessageFilter messageFilter) {
        if (this.topicFilter.filterTopic(topic)) {
            return this.next.getMessageAsync(group, topic, queueId, offset, maxMsgNums, messageFilter);
        }
        if (!this.fetchFromCurrentStore(topic, queueId, offset, maxMsgNums)) {
            log.trace("GetMessageAsync from next store, topic: {}, queue: {}, offset: {}, maxCount: {}", new Object[]{topic, queueId, offset, maxMsgNums});
            return this.next.getMessageAsync(group, topic, queueId, offset, maxMsgNums, messageFilter);
        }
        log.trace("GetMessageAsync from remote store, topic: {}, queue: {}, offset: {}, maxCount: {}", new Object[]{topic, queueId, offset, maxMsgNums});
        Stopwatch stopwatch = Stopwatch.createStarted();
        return ((CompletableFuture)this.fetcher.getMessageAsync(group, topic, queueId, offset, maxMsgNums, messageFilter).thenApply(result -> {
            long minOffsetInQueue;
            Attributes latencyAttributes = TieredStoreMetricsManager.newAttributesBuilder().put("operation", "get_message").put("topic", topic).put("group", group).build();
            TieredStoreMetricsManager.apiLatency.record(stopwatch.elapsed(TimeUnit.MILLISECONDS), latencyAttributes);
            if ((result.getStatus() == GetMessageStatus.OFFSET_FOUND_NULL || result.getStatus() == GetMessageStatus.NO_MATCHED_LOGIC_QUEUE) && this.next.checkInStoreByConsumeOffset(topic, queueId, offset)) {
                TieredStoreMetricsManager.fallbackTotal.add(1L, latencyAttributes);
                log.debug("GetMessageAsync not found, then back to next store, result: {}, topic: {}, queue: {}, queue offset: {}, offset range: {}-{}", new Object[]{result.getStatus(), topic, queueId, offset, result.getMinOffset(), result.getMaxOffset()});
                return this.next.getMessage(group, topic, queueId, offset, maxMsgNums, messageFilter);
            }
            if (result.getStatus() != GetMessageStatus.FOUND && result.getStatus() != GetMessageStatus.NO_MESSAGE_IN_QUEUE && result.getStatus() != GetMessageStatus.NO_MATCHED_LOGIC_QUEUE && result.getStatus() != GetMessageStatus.OFFSET_TOO_SMALL && result.getStatus() != GetMessageStatus.OFFSET_OVERFLOW_ONE && result.getStatus() != GetMessageStatus.OFFSET_OVERFLOW_BADLY) {
                log.warn("GetMessageAsync not found and message is not in next store, result: {}, topic: {}, queue: {}, queue offset: {}, offset range: {}-{}", new Object[]{result.getStatus(), topic, queueId, offset, result.getMinOffset(), result.getMaxOffset()});
            }
            if (result.getStatus() == GetMessageStatus.FOUND) {
                Attributes messagesOutAttributes = TieredStoreMetricsManager.newAttributesBuilder().put("topic", topic).put("group", group).build();
                TieredStoreMetricsManager.messagesOutTotal.add((long)result.getMessageCount(), messagesOutAttributes);
                if (this.next.getStoreStatsService() != null) {
                    this.next.getStoreStatsService().getGetMessageTransferredMsgCount().add(result.getMessageCount());
                }
            }
            if ((minOffsetInQueue = this.next.getMinOffsetInQueue(topic, queueId)) >= 0L && minOffsetInQueue < result.getMinOffset()) {
                result.setMinOffset(minOffsetInQueue);
            }
            if (this.storeConfig.isRecordGetMessageResult()) {
                log.info("GetMessageAsync result, {}, group: {}, topic: {}, queueId: {}, offset: {}, count:{}", new Object[]{result, group, topic, queueId, offset, maxMsgNums});
            }
            return result;
        })).exceptionally(e -> {
            log.error("GetMessageAsync from tiered store failed", e);
            return this.next.getMessage(group, topic, queueId, offset, maxMsgNums, messageFilter);
        });
    }

    public long getMinOffsetInQueue(String topic, int queueId) {
        long minOffsetInNextStore = this.next.getMinOffsetInQueue(topic, queueId);
        FlatMessageFile flatFile = this.flatFileStore.getFlatFile(new MessageQueue(topic, this.brokerName, queueId));
        if (flatFile == null) {
            return minOffsetInNextStore;
        }
        long minOffsetInTieredStore = flatFile.getConsumeQueueMinOffset();
        if (minOffsetInTieredStore < 0L) {
            return minOffsetInNextStore;
        }
        return Math.min(minOffsetInNextStore, minOffsetInTieredStore);
    }

    public long getEarliestMessageTime(String topic, int queueId) {
        return this.getEarliestMessageTimeAsync(topic, queueId).join();
    }

    public CompletableFuture<Long> getEarliestMessageTimeAsync(String topic, int queueId) {
        long nextEarliestMessageTime = this.next.getEarliestMessageTime(topic, queueId);
        long finalNextEarliestMessageTime = nextEarliestMessageTime > 0L ? nextEarliestMessageTime : Long.MAX_VALUE;
        Stopwatch stopwatch = Stopwatch.createStarted();
        return this.fetcher.getEarliestMessageTimeAsync(topic, queueId).thenApply(time -> {
            Attributes latencyAttributes = TieredStoreMetricsManager.newAttributesBuilder().put("operation", "get_earliest_message_time").put("topic", topic).build();
            TieredStoreMetricsManager.apiLatency.record(stopwatch.elapsed(TimeUnit.MILLISECONDS), latencyAttributes);
            if (time < 0L) {
                log.debug("GetEarliestMessageTimeAsync failed, try to get earliest message time from next store: topic: {}, queue: {}", (Object)topic, (Object)queueId);
                return finalNextEarliestMessageTime != Long.MAX_VALUE ? finalNextEarliestMessageTime : -1L;
            }
            return Math.min(finalNextEarliestMessageTime, time);
        });
    }

    public CompletableFuture<Long> getMessageStoreTimeStampAsync(String topic, int queueId, long consumeQueueOffset) {
        if (this.fetchFromCurrentStore(topic, queueId, consumeQueueOffset)) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            return this.fetcher.getMessageStoreTimeStampAsync(topic, queueId, consumeQueueOffset).thenApply(time -> {
                Attributes latencyAttributes = TieredStoreMetricsManager.newAttributesBuilder().put("operation", "get_time_by_offset").put("topic", topic).build();
                TieredStoreMetricsManager.apiLatency.record(stopwatch.elapsed(TimeUnit.MILLISECONDS), latencyAttributes);
                if (time == -1L) {
                    log.debug("GetEarliestMessageTimeAsync failed, try to get message time from next store, topic: {}, queue: {}, queue offset: {}", new Object[]{topic, queueId, consumeQueueOffset});
                    return this.next.getMessageStoreTimeStamp(topic, queueId, consumeQueueOffset);
                }
                return time;
            });
        }
        return this.next.getMessageStoreTimeStampAsync(topic, queueId, consumeQueueOffset);
    }

    public long getOffsetInQueueByTime(String topic, int queueId, long timestamp) {
        return this.getOffsetInQueueByTime(topic, queueId, timestamp, BoundaryType.LOWER);
    }

    public long getOffsetInQueueByTime(String topic, int queueId, long timestamp, BoundaryType boundaryType) {
        boolean isForce;
        boolean bl = isForce = this.storeConfig.getTieredStorageLevel() == MessageStoreConfig.TieredStorageLevel.FORCE;
        if (timestamp < this.next.getEarliestMessageTime() || isForce) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            long offsetInTieredStore = this.fetcher.getOffsetInQueueByTime(topic, queueId, timestamp, boundaryType);
            Attributes latencyAttributes = TieredStoreMetricsManager.newAttributesBuilder().put("operation", "get_offset_by_time").put("topic", topic).build();
            TieredStoreMetricsManager.apiLatency.record(stopwatch.elapsed(TimeUnit.MILLISECONDS), latencyAttributes);
            if (offsetInTieredStore == -1L && !isForce) {
                return this.next.getOffsetInQueueByTime(topic, queueId, timestamp);
            }
            return offsetInTieredStore;
        }
        return this.next.getOffsetInQueueByTime(topic, queueId, timestamp);
    }

    public QueryMessageResult queryMessage(String topic, String key, int maxNum, long begin, long end) {
        return this.queryMessageAsync(topic, key, maxNum, begin, end).join();
    }

    public CompletableFuture<QueryMessageResult> queryMessageAsync(String topic, String key, int maxNum, long begin, long end) {
        long earliestTimeInNextStore = this.next.getEarliestMessageTime();
        if (earliestTimeInNextStore <= 0L) {
            log.warn("TieredMessageStore#queryMessageAsync: get earliest message time in next store failed: {}", (Object)earliestTimeInNextStore);
        }
        boolean isForce = this.storeConfig.getTieredStorageLevel() == MessageStoreConfig.TieredStorageLevel.FORCE;
        QueryMessageResult result = end < earliestTimeInNextStore || isForce ? new QueryMessageResult() : this.next.queryMessage(topic, key, maxNum, begin, end);
        int resultSize = result.getMessageBufferList().size();
        if (resultSize < maxNum && begin < earliestTimeInNextStore || isForce) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            try {
                return this.fetcher.queryMessageAsync(topic, key, maxNum - resultSize, begin, isForce ? end : earliestTimeInNextStore).thenApply(tieredStoreResult -> {
                    Attributes latencyAttributes = TieredStoreMetricsManager.newAttributesBuilder().put("operation", "query_message").put("topic", topic).build();
                    TieredStoreMetricsManager.apiLatency.record(stopwatch.elapsed(TimeUnit.MILLISECONDS), latencyAttributes);
                    for (SelectMappedBufferResult msg : tieredStoreResult.getMessageMapedList()) {
                        result.addMessage(msg);
                    }
                    return result;
                });
            }
            catch (Exception e) {
                log.error("TieredMessageStore#queryMessageAsync: query message in tiered store failed", (Throwable)e);
                return CompletableFuture.completedFuture(result);
            }
        }
        return CompletableFuture.completedFuture(result);
    }

    public List<Pair<InstrumentSelector, ViewBuilder>> getMetricsView() {
        List res = super.getMetricsView();
        res.addAll(TieredStoreMetricsManager.getMetricsView());
        return res;
    }

    public void initMetrics(Meter meter, Supplier<AttributesBuilder> attributesBuilderSupplier) {
        super.initMetrics(meter, attributesBuilderSupplier);
        TieredStoreMetricsManager.init(meter, attributesBuilderSupplier, this.storeConfig, this.fetcher, this.flatFileStore, this.next);
    }

    public int cleanUnusedTopic(Set<String> retainTopics) {
        this.metadataStore.iterateTopic(topicMetadata -> {
            String topic = topicMetadata.getTopic();
            if (retainTopics.contains(topic) || TopicValidator.isSystemTopic((String)topic) || MixAll.isLmq((String)topic)) {
                return;
            }
            this.deleteTopics(Sets.newHashSet((Object[])new String[]{topicMetadata.getTopic()}));
        });
        return this.next.cleanUnusedTopic(retainTopics);
    }

    public int deleteTopics(Set<String> deleteTopics) {
        for (String topic : deleteTopics) {
            this.metadataStore.iterateQueue(topic, queueMetadata -> this.flatFileStore.destroyFile(queueMetadata.getQueue()));
            this.metadataStore.deleteTopic(topic);
            log.info("MessageStore delete topic success, topicName={}", (Object)topic);
        }
        return this.next.deleteTopics(deleteTopics);
    }

    public synchronized void shutdown() {
        if (this.next != null) {
            this.next.shutdown();
        }
        if (this.dispatcher != null) {
            this.dispatcher.shutdown();
        }
        if (this.indexService != null) {
            this.indexService.shutdown();
        }
        if (this.flatFileStore != null) {
            this.flatFileStore.shutdown();
        }
        if (this.storeExecutor != null) {
            this.storeExecutor.shutdown();
        }
    }

    public void destroy() {
        if (this.next != null) {
            this.next.destroy();
        }
        if (this.indexService != null) {
            this.indexService.destroy();
        }
        if (this.flatFileStore != null) {
            this.flatFileStore.destroy();
        }
        if (this.metadataStore != null) {
            this.metadataStore.destroy();
        }
    }
}

