/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.metrics;

import org.apache.ratis.metrics.LongCounter;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.metrics.RatisMetrics;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.server.metrics.RaftLogMetrics;
import org.apache.ratis.server.raftlog.LogEntryHeader;

public class RaftLogMetricsBase
extends RatisMetrics
implements RaftLogMetrics {
    public static final String RATIS_LOG_WORKER_METRICS_DESC = "Metrics for Log Worker";
    public static final String RATIS_LOG_WORKER_METRICS = "log_worker";
    public static final String METADATA_LOG_ENTRY_COUNT = "metadataLogEntryCount";
    public static final String CONFIG_LOG_ENTRY_COUNT = "configLogEntryCount";
    public static final String STATE_MACHINE_LOG_ENTRY_COUNT = "stateMachineLogEntryCount";
    private final LongCounter configLogEntryCount = this.getRegistry().counter("configLogEntryCount");
    private final LongCounter metadataLogEntryCount = this.getRegistry().counter("metadataLogEntryCount");
    private final LongCounter stateMachineLogEntryCount = this.getRegistry().counter("stateMachineLogEntryCount");

    public RaftLogMetricsBase(RaftGroupMemberId serverId) {
        super(RaftLogMetricsBase.createRegistry(serverId));
    }

    public static RatisMetricRegistry createRegistry(RaftGroupMemberId serverId) {
        return RaftLogMetricsBase.create(new MetricRegistryInfo(serverId.toString(), "ratis", RATIS_LOG_WORKER_METRICS, RATIS_LOG_WORKER_METRICS_DESC));
    }

    @Override
    public void onLogEntryCommitted(LogEntryHeader header) {
        switch (header.getLogEntryBodyCase()) {
            case CONFIGURATIONENTRY: {
                this.configLogEntryCount.inc();
                return;
            }
            case METADATAENTRY: {
                this.metadataLogEntryCount.inc();
                return;
            }
            case STATEMACHINELOGENTRY: {
                this.stateMachineLogEntryCount.inc();
                return;
            }
        }
    }
}

