/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.authorization.utils.JsonUtils;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.contextenricher.RangerTagForEval;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.util.MacroProcessor;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.RangerTimeRangeChecker;
import org.apache.ranger.plugin.util.RangerUserStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RangerRequestScriptEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(RangerRequestScriptEvaluator.class);
    private static final Logger PERF_POLICY_CONDITION_SCRIPT_TOJSON = RangerPerfTracer.getPerfLogger("policy.condition.script.tojson");
    private static final Logger PERF_POLICY_CONDITION_SCRIPT_EVAL = RangerPerfTracer.getPerfLogger("policy.condition.script.eval");
    private static final String TAG_ATTR_DATE_FORMAT_PROP = "ranger.plugin.tag.attr.additional.date.formats";
    private static final String TAG_ATTR_DATE_FORMAT_SEPARATOR = "||";
    private static final String TAG_ATTR_DATE_FORMAT_SEPARATOR_REGEX = "\\|\\|";
    private static final String DEFAULT_RANGER_TAG_ATTRIBUTE_DATE_FORMAT = "yyyy/MM/dd";
    private static final String DEFAULT_ATLAS_TAG_ATTRIBUTE_DATE_FORMAT_NAME = "ATLAS_DATE_FORMAT";
    private static final String DEFAULT_ATLAS_TAG_ATTRIBUTE_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final String SCRIPT_SAFE_PREEXEC = "exit=null;quit=null;";
    private static final String SCRIPT_PREEXEC = "_ctx=JSON.parse(_ctx_json); J=JSON.stringify;REQ=_ctx.request;RES=REQ.resource;USER=REQ.userAttributes;UGNAMES=REQ.userGroups;UG=REQ.userGroupAttributes;UGA=REQ.uga;URNAMES=REQ.userRoles;TAG=_ctx.tag;TAGS=_ctx.tags;TAGNAMES=_ctx.tagNames;";
    private static final Pattern JSON_VAR_NAMES_PATTERN = Pattern.compile(RangerRequestScriptEvaluator.getJsonVarNamesPattern());
    private static final Pattern USER_ATTRIBUTES_PATTERN = Pattern.compile(RangerRequestScriptEvaluator.getUserAttributesPattern());
    private static final Pattern GROUP_ATTRIBUTES_PATTERN = Pattern.compile(RangerRequestScriptEvaluator.getGroupAttributesPattern());
    private static final String STR_QUOTE = "'";
    private static final String STR_COMMA = ",";
    private static final MacroProcessor MACRO_PROCESSOR = new MacroProcessor(RangerRequestScriptEvaluator.getMacrosMap());
    private static String[] dateFormatStrings = null;
    private final RangerAccessRequest accessRequest;
    private final ScriptEngine scriptEngine;
    private final Bindings bindings;
    private boolean initDone = false;
    private Map<String, String> userAttrs = Collections.emptyMap();
    private Map<String, Map<String, String>> groupAttrs = Collections.emptyMap();
    private Map<String, Map<String, Object>> tags = Collections.emptyMap();
    private Map<String, Object> tag = Collections.emptyMap();
    private Collection<String> userGroups = Collections.emptySet();
    private Collection<String> userRoles = Collections.emptySet();
    private Collection<String> tagNames = Collections.emptySet();
    private Boolean result = false;
    private static final ThreadLocal<List<SimpleDateFormat>> THREADLOCAL_DATE_FORMATS;

    public static boolean needsJsonCtxEnabled(String script) {
        boolean ret = false;
        if (script != null) {
            Matcher matcher = JSON_VAR_NAMES_PATTERN.matcher(script);
            ret = matcher.find();
        }
        return ret;
    }

    public static boolean hasUserAttributeReference(String script) {
        boolean ret = false;
        if (script != null) {
            Matcher matcher = USER_ATTRIBUTES_PATTERN.matcher(script);
            ret = matcher.find();
        }
        return ret;
    }

    public static boolean hasGroupAttributeReference(String script) {
        boolean ret = false;
        if (script != null) {
            Matcher matcher = GROUP_ATTRIBUTES_PATTERN.matcher(script);
            ret = matcher.find();
        }
        return ret;
    }

    public static boolean hasUserGroupAttributeReference(String script) {
        return RangerRequestScriptEvaluator.hasUserAttributeReference(script) || RangerRequestScriptEvaluator.hasGroupAttributeReference(script);
    }

    public static boolean hasUserGroupAttributeReference(Collection<String> scripts) {
        boolean ret = false;
        if (scripts != null) {
            for (String script : scripts) {
                if (!RangerRequestScriptEvaluator.hasUserGroupAttributeReference(script)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public static String expandMacros(String script) {
        return MACRO_PROCESSOR.expandMacros(script);
    }

    public RangerRequestScriptEvaluator(RangerAccessRequest accessRequest, ScriptEngine scriptEngine) {
        this(accessRequest, scriptEngine, true);
    }

    public RangerRequestScriptEvaluator(RangerAccessRequest accessRequest, ScriptEngine scriptEngine, boolean enableJsonCtx) {
        this.accessRequest = accessRequest.getReadOnlyCopy();
        this.scriptEngine = scriptEngine;
        this.bindings = scriptEngine.createBindings();
        RangerTagForEval currentTag = this.getCurrentTag();
        Map<Object, Object> tagAttribs = currentTag != null ? currentTag.getAttributes() : Collections.emptyMap();
        this.bindings.put("ctx", (Object)this);
        this.bindings.put("tag", (Object)currentTag);
        this.bindings.put("tagAttr", (Object)tagAttribs);
        String preExecScript = "";
        if (enableJsonCtx) {
            this.bindings.put("_ctx_json", (Object)this.toJson());
            preExecScript = preExecScript + SCRIPT_PREEXEC;
        }
        if (StringUtils.isNotBlank((String)preExecScript)) {
            try {
                scriptEngine.eval(preExecScript, this.bindings);
            }
            catch (ScriptException excp) {
                LOG.error("RangerRequestScriptEvaluator(): initialization failed", (Throwable)excp);
            }
        }
    }

    public Object evaluateScript(String script) {
        script = RangerRequestScriptEvaluator.expandMacros(script);
        return this.evaluateScriptImpl(script);
    }

    public Object evaluateConditionScript(String script) {
        Object ret = this.evaluateScript(script);
        if (ret == null) {
            ret = this.getResult();
        }
        if (ret instanceof Boolean) {
            this.result = (Boolean)ret;
        }
        return ret;
    }

    /*
     * Exception decompiling
     */
    private Object evaluateScriptImpl(String script) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String toJson() {
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICY_CONDITION_SCRIPT_TOJSON)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICY_CONDITION_SCRIPT_TOJSON, "RangerRequestScriptEvaluator.toJson(requestHash=" + this.accessRequest.hashCode() + ")");
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        HashMap<String, Object> request = new HashMap<String, Object>();
        Date accessTime = this.accessRequest.getAccessTime();
        this.init();
        if (accessTime != null) {
            request.put("accessTime", accessTime.getTime());
        }
        request.put("accessType", this.accessRequest.getAccessType());
        request.put("action", this.accessRequest.getAction());
        request.put("clientIPAddress", this.accessRequest.getClientIPAddress());
        request.put("clientType", this.accessRequest.getClientType());
        request.put("clusterName", this.accessRequest.getClusterName());
        request.put("clusterType", this.accessRequest.getClusterType());
        request.put("forwardedAddresses", this.accessRequest.getForwardedAddresses());
        request.put("remoteIPAddress", this.accessRequest.getRemoteIPAddress());
        request.put("requestData", this.accessRequest.getRequestData());
        if (this.accessRequest.getResource() != null) {
            HashMap<String, Object> resource = new HashMap<String, Object>(this.accessRequest.getResource().getAsMap());
            resource.put("_ownerUser", this.accessRequest.getResource().getOwnerUser());
            request.put("resource", resource);
        }
        request.put("resourceMatchingScope", (Object)this.accessRequest.getResourceMatchingScope());
        request.put("user", this.getUser());
        request.put("userGroups", this.userGroups);
        request.put("userRoles", this.userRoles);
        request.put("userAttributes", this.userAttrs);
        request.put("userGroupAttributes", this.groupAttrs);
        request.put("uga", new UserGroupsAttributes(this.userGroups, this.groupAttrs).getAttributes());
        ret.put("request", request);
        ret.put("tags", this.tags);
        ret.put("tagNames", this.tagNames);
        ret.put("tag", this.tag);
        String strRet = JsonUtils.objectToJson(ret);
        RangerPerfTracer.log(perf);
        return strRet;
    }

    public static void init(Configuration config) {
        String additionalDateFormatsValue;
        StringBuilder sb = new StringBuilder(DEFAULT_RANGER_TAG_ATTRIBUTE_DATE_FORMAT);
        sb.append(TAG_ATTR_DATE_FORMAT_SEPARATOR).append(DEFAULT_ATLAS_TAG_ATTRIBUTE_DATE_FORMAT_NAME);
        String string = additionalDateFormatsValue = config != null ? config.get(TAG_ATTR_DATE_FORMAT_PROP) : null;
        if (StringUtils.isNotBlank((String)additionalDateFormatsValue)) {
            sb.append(TAG_ATTR_DATE_FORMAT_SEPARATOR).append(additionalDateFormatsValue);
        }
        String[] formatStrings = sb.toString().split(TAG_ATTR_DATE_FORMAT_SEPARATOR_REGEX);
        Arrays.sort(formatStrings, new Comparator<String>(){

            @Override
            public int compare(String first, String second) {
                return Integer.compare(second.length(), first.length());
            }
        });
        dateFormatStrings = formatStrings;
    }

    public String getResource() {
        String ret = null;
        RangerAccessResource val = RangerAccessRequestUtil.getCurrentResourceFromContext(this.getRequestContext());
        if (val != null) {
            ret = val.getAsString();
        }
        return ret;
    }

    public String getResourceZone() {
        String ret = RangerAccessRequestUtil.getResourceZoneNameFromContext(this.getRequestContext());
        return ret != null ? ret : "";
    }

    public Set<String> getResourceZones() {
        Set<String> ret = RangerAccessRequestUtil.getResourceZoneNamesFromContext(this.getRequestContext());
        return ret != null ? Collections.emptySet() : ret;
    }

    public String getRequestContextAttribute(String attributeName) {
        Object val;
        String ret = null;
        if (StringUtils.isNotBlank((String)attributeName) && (val = this.getRequestContext().get(attributeName)) != null) {
            ret = val.toString();
        }
        return ret;
    }

    public boolean isAccessTypeAny() {
        return this.accessRequest.isAccessTypeAny();
    }

    public boolean isAccessTypeDelegatedAdmin() {
        return this.accessRequest.isAccessTypeDelegatedAdmin();
    }

    public String getUser() {
        return this.accessRequest.getUser();
    }

    public Set<String> getUserGroups() {
        return this.accessRequest.getUserGroups();
    }

    public Set<String> getUserRoles() {
        return RangerAccessRequestUtil.getUserRoles(this.accessRequest);
    }

    public Date getAccessTime() {
        return this.accessRequest.getAccessTime() != null ? this.accessRequest.getAccessTime() : new Date();
    }

    public String getClientIPAddress() {
        return this.accessRequest.getClientIPAddress();
    }

    public String getClientType() {
        return this.accessRequest.getClientType();
    }

    public String getAction() {
        return this.accessRequest.getAction();
    }

    public String getRequestData() {
        return this.accessRequest.getRequestData();
    }

    public String getSessionId() {
        return this.accessRequest.getSessionId();
    }

    public RangerTagForEval getCurrentTag() {
        RangerTagForEval ret = RangerAccessRequestUtil.getCurrentTagFromContext(this.getRequestContext());
        if (ret == null && LOG.isDebugEnabled()) {
            this.logDebug("RangerRequestScriptEvaluator.getCurrentTag() - No current TAG object. Script execution must be for resource-based policy.");
        }
        return ret;
    }

    public String getCurrentTagType() {
        RangerTagForEval tagObject = this.getCurrentTag();
        return tagObject != null ? tagObject.getType() : null;
    }

    public Set<String> getAllTagTypes() {
        HashSet<String> allTagTypes = null;
        Set<RangerTagForEval> tagObjectList = this.getAllTags();
        if (CollectionUtils.isNotEmpty(tagObjectList)) {
            for (RangerTagForEval tag : tagObjectList) {
                String tagType = tag.getType();
                if (allTagTypes == null) {
                    allTagTypes = new HashSet<String>();
                }
                allTagTypes.add(tagType);
            }
        }
        return allTagTypes;
    }

    public Map<String, String> getTagAttributes(String tagType) {
        Set<RangerTagForEval> tagObjectList;
        Map<String, String> ret = null;
        if (StringUtils.isNotBlank((String)tagType) && CollectionUtils.isNotEmpty(tagObjectList = this.getAllTags())) {
            for (RangerTagForEval tag : tagObjectList) {
                if (!tag.getType().equals(tagType)) continue;
                ret = tag.getAttributes();
                break;
            }
        }
        return ret;
    }

    public List<Map<String, String>> getTagAttributesForAllMatchingTags(String tagType) {
        Set<RangerTagForEval> tagObjectList;
        ArrayList<Map<String, String>> ret = null;
        if (StringUtils.isNotBlank((String)tagType) && CollectionUtils.isNotEmpty(tagObjectList = this.getAllTags())) {
            for (RangerTagForEval tag : tagObjectList) {
                if (!tag.getType().equals(tagType)) continue;
                Map<String, String> tagAttributes = tag.getAttributes();
                if (tagAttributes == null) break;
                if (ret == null) {
                    ret = new ArrayList<Map<String, String>>();
                }
                ret.add(tagAttributes);
                break;
            }
        }
        return ret;
    }

    public Set<String> getAttributeNames(String tagType) {
        Set<String> ret = null;
        Map<String, String> attributes = this.getTagAttributes(tagType);
        if (attributes != null) {
            ret = attributes.keySet();
        }
        return ret;
    }

    public String getAttributeValue(String tagType, String attributeName) {
        Map<String, String> attributes;
        String ret = null;
        if ((StringUtils.isNotBlank((String)tagType) || StringUtils.isNotBlank((String)attributeName)) && (attributes = this.getTagAttributes(tagType)) != null) {
            ret = attributes.get(attributeName);
        }
        return ret;
    }

    public List<String> getAttributeValueForAllMatchingTags(String tagType, String attributeName) {
        Map<String, String> attributes;
        ArrayList<String> ret = null;
        if ((StringUtils.isNotBlank((String)tagType) || StringUtils.isNotBlank((String)attributeName)) && (attributes = this.getTagAttributes(tagType)) != null && attributes.get(attributeName) != null) {
            if (ret == null) {
                ret = new ArrayList<String>();
            }
            ret.add(attributes.get(attributeName));
        }
        return ret;
    }

    public String getAttributeValue(String attributeName) {
        String ret = null;
        if (StringUtils.isNotBlank((String)attributeName)) {
            RangerTagForEval tag = this.getCurrentTag();
            Map<String, String> attributes = null;
            if (tag != null) {
                attributes = tag.getAttributes();
            }
            if (attributes != null) {
                ret = attributes.get(attributeName);
            }
        }
        return ret;
    }

    public boolean getResult() {
        return this.result;
    }

    public void setResult(boolean result) {
        this.result = result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date getAsDate(String value, SimpleDateFormat df) {
        Date ret = null;
        TimeZone savedTimeZone = df.getTimeZone();
        try {
            ret = df.parse(value);
        }
        catch (ParseException parseException) {
        }
        finally {
            df.setTimeZone(savedTimeZone);
        }
        return ret;
    }

    public Date getAsDate(String value) {
        Date ret = null;
        if (StringUtils.isNotBlank((String)value)) {
            for (SimpleDateFormat simpleDateFormat : THREADLOCAL_DATE_FORMATS.get()) {
                ret = this.getAsDate(value, simpleDateFormat);
                if (ret == null) continue;
                if (!LOG.isDebugEnabled()) break;
                this.logDebug("RangerRequestScriptEvaluator.getAsDate() -The best match found for Format-String:[" + simpleDateFormat.toPattern() + "], date:[" + ret + "]");
                break;
            }
        }
        if (ret == null) {
            this.logError("RangerRequestScriptEvaluator.getAsDate() - Could not convert [" + value + "] to Date using any of the Format-Strings: " + Arrays.toString(dateFormatStrings));
        } else {
            ret = StringUtil.getUTCDateForLocalDate(ret);
        }
        return ret;
    }

    public Date getTagAttributeAsDate(String tagType, String attributeName) {
        String attrValue = this.getAttributeValue(tagType, attributeName);
        return this.getAsDate(attrValue);
    }

    public boolean isAccessedAfter(String tagType, String attributeName) {
        boolean ret = false;
        Date accessDate = this.getAccessTime();
        Date expiryDate = this.getTagAttributeAsDate(tagType, attributeName);
        if (expiryDate == null || accessDate.after(expiryDate) || accessDate.equals(expiryDate)) {
            ret = true;
        }
        return ret;
    }

    public boolean isAccessedAfter(String attributeName) {
        boolean ret = false;
        Date accessDate = this.getAccessTime();
        Date expiryDate = this.getAsDate(this.getAttributeValue(attributeName));
        if (expiryDate == null || accessDate.after(expiryDate) || accessDate.equals(expiryDate)) {
            ret = true;
        }
        return ret;
    }

    public boolean isAccessedBefore(String tagType, String attributeName) {
        boolean ret = true;
        Date accessDate = this.getAccessTime();
        Date expiryDate = this.getTagAttributeAsDate(tagType, attributeName);
        if (expiryDate == null || accessDate.after(expiryDate)) {
            ret = false;
        }
        return ret;
    }

    public boolean isAccessedBefore(String attributeName) {
        boolean ret = true;
        Date accessDate = this.getAccessTime();
        Date expiryDate = this.getAsDate(this.getAttributeValue(attributeName));
        if (expiryDate == null || accessDate.after(expiryDate)) {
            ret = false;
        }
        return ret;
    }

    public String tagNames(Object ... args) {
        this.init();
        return this.toCsv(this.tagNames, args);
    }

    public String tagNamesQ(Object ... args) {
        this.init();
        return this.toCsvQ(this.tagNames, args);
    }

    public String tagAttrNames(Object ... args) {
        this.init();
        return this.toCsv(this.getTagAttrNames(), args);
    }

    public String tagAttrNamesQ(Object ... args) {
        this.init();
        return this.toCsvQ(this.getTagAttrNames(), args);
    }

    public String tagAttr(String attrName, Object ... args) {
        this.init();
        return this.toCsv(this.getTagAttr(attrName), args);
    }

    public String tagAttrQ(String attrName, Object ... args) {
        this.init();
        return this.toCsvQ(this.getTagAttr(attrName), args);
    }

    public String ugNames(Object ... args) {
        this.init();
        return this.toCsv(this.userGroups, args);
    }

    public String ugNamesQ(Object ... args) {
        this.init();
        return this.toCsvQ(this.userGroups, args);
    }

    public String ugAttrNames(Object ... args) {
        this.init();
        return this.toCsv(this.getUgAttrNames(), args);
    }

    public String ugAttrNamesQ(Object ... args) {
        this.init();
        return this.toCsvQ(this.getUgAttrNames(), args);
    }

    public String ugAttr(String attrName, Object ... args) {
        this.init();
        return this.toCsv(this.getUgAttr(attrName), args);
    }

    public String ugAttrQ(String attrName, Object ... args) {
        this.init();
        return this.toCsvQ(this.getUgAttr(attrName), args);
    }

    public String urNames(Object ... args) {
        this.init();
        return this.toCsv(this.userRoles, args);
    }

    public String urNamesQ(Object ... args) {
        this.init();
        return this.toCsvQ(this.userRoles, args);
    }

    public String userAttrNames(Object ... args) {
        this.init();
        return this.toCsv(this.getUserAttrNames(), args);
    }

    public String userAttrNamesQ(Object ... args) {
        this.init();
        return this.toCsvQ(this.getUserAttrNames(), args);
    }

    public String userAttr(String attrName, Object ... args) {
        this.init();
        String attrVal = this.userAttrs.get(attrName);
        return this.toCsv(Collections.singletonList(attrVal), args);
    }

    public String userAttrQ(String attrName, Object ... args) {
        this.init();
        String attrVal = this.userAttrs.get(attrName);
        return this.toCsvQ(Collections.singletonList(attrVal), args);
    }

    public boolean hasTag(String tagName) {
        this.init();
        return this.tags.containsKey(tagName);
    }

    public boolean hasAnyTag() {
        this.init();
        return !this.tags.isEmpty();
    }

    public boolean hasUserAttr(String attrName) {
        this.init();
        return this.userAttrs.containsKey(attrName);
    }

    public boolean hasUgAttr(String attrName) {
        this.init();
        boolean ret = false;
        for (Map<String, String> attrs : this.groupAttrs.values()) {
            if (!attrs.containsKey(attrName)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public boolean hasTagAttr(String attrName) {
        this.init();
        boolean ret = false;
        Set<RangerTagForEval> tags = RangerAccessRequestUtil.getRequestTagsFromContext(this.accessRequest.getContext());
        if (tags != null) {
            for (RangerTagForEval tag : tags) {
                if (!tag.getAttributes().containsKey(attrName)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public boolean isInGroup(String groupName) {
        this.init();
        return this.userGroups.contains(groupName);
    }

    public boolean isInRole(String roleName) {
        this.init();
        return this.userRoles.contains(roleName);
    }

    public boolean isInAnyGroup() {
        this.init();
        return !this.userGroups.isEmpty();
    }

    public boolean isInAnyRole() {
        this.init();
        return !this.userRoles.isEmpty();
    }

    public boolean isAccessTimeAfter(String strTime) {
        return this.isAccessTimeBetween(strTime, null, null);
    }

    public boolean isAccessTimeAfter(String strTime, String timeZone) {
        return this.isAccessTimeBetween(strTime, null, timeZone);
    }

    public boolean isAccessTimeBefore(String strTime) {
        return this.isAccessTimeBetween(null, strTime, null);
    }

    public boolean isAccessTimeBefore(String strTime, String timeZone) {
        return this.isAccessTimeBetween(null, strTime, timeZone);
    }

    public boolean isAccessTimeBetween(String fromTime, String toTime) {
        return this.isAccessTimeBetween(fromTime, toTime, null);
    }

    public boolean isAccessTimeBetween(String fromTime, String toTime, String timeZone) {
        RangerTimeRangeChecker evaluator = new RangerTimeRangeChecker(fromTime, toTime, timeZone);
        return evaluator.isInRange(this.getAccessTime().getTime());
    }

    public String ugNamesCsv() {
        return this.ugNames(null, STR_COMMA);
    }

    public String ugNamesCsvQ() {
        return this.ugNamesQ(null, STR_COMMA, STR_QUOTE);
    }

    public String urNamesCsv() {
        return this.urNames(null, STR_COMMA);
    }

    public String urNamesCsvQ() {
        return this.urNamesQ(null, STR_COMMA, STR_QUOTE);
    }

    public String tagNamesCsv() {
        return this.tagNames(null, STR_COMMA);
    }

    public String tagNamesCsvQ() {
        return this.tagNamesQ(null, STR_COMMA, STR_QUOTE);
    }

    public String userAttrNamesCsv() {
        return this.userAttrNames(null, STR_COMMA);
    }

    public String userAttrNamesCsvQ() {
        return this.userAttrNamesQ(null, STR_COMMA, STR_QUOTE);
    }

    public String ugAttrNamesCsv() {
        return this.ugAttrNames(null, STR_COMMA);
    }

    public String ugAttrNamesCsvQ() {
        return this.ugAttrNamesQ(null, STR_COMMA, STR_QUOTE);
    }

    public String tagAttrNamesCsv() {
        return this.tagAttrNames(null, STR_COMMA);
    }

    public String tagAttrNamesCsvQ() {
        return this.tagAttrNamesQ(null, STR_COMMA, STR_QUOTE);
    }

    public String ugAttrCsv(String attrName) {
        return this.ugAttr(attrName, null, STR_COMMA);
    }

    public String ugAttrCsvQ(String attrName) {
        return this.ugAttrQ(attrName, null, STR_COMMA, STR_QUOTE);
    }

    public String tagAttrCsv(String attrName) {
        return this.tagAttr(attrName, null, STR_COMMA);
    }

    public String tagAttrCsvQ(String attrName) {
        return this.tagAttrQ(attrName, null, STR_COMMA, STR_QUOTE);
    }

    private void init() {
        if (!this.initDone) {
            RangerUserStore userStore = RangerAccessRequestUtil.getRequestUserStoreFromContext(this.accessRequest.getContext());
            Map<Object, Object> userAttrMapping = userStore != null ? userStore.getUserAttrMapping() : Collections.emptyMap();
            Map<Object, Object> groupAttrMapping = userStore != null ? userStore.getGroupAttrMapping() : Collections.emptyMap();
            this.userGroups = this.getSorted(this.getUserGroups());
            this.userRoles = this.getSorted(this.getUserRoles());
            this.userAttrs = this.copyMap((Map)userAttrMapping.get(this.accessRequest.getUser()));
            this.groupAttrs = new HashMap<String, Map<String, String>>();
            this.userAttrs.put("_name", this.getUser());
            for (String groupName : this.userGroups) {
                HashMap<String, String> attrs = (HashMap<String, String>)groupAttrMapping.get(groupName);
                attrs = attrs != null ? new HashMap<String, String>(attrs) : new HashMap();
                attrs.put("_name", groupName);
                this.groupAttrs.put(groupName, attrs);
            }
            Set<RangerTagForEval> requestTags = RangerAccessRequestUtil.getRequestTagsFromContext(this.getRequestContext());
            if (CollectionUtils.isNotEmpty(requestTags)) {
                RangerTagForEval currentTag = RangerAccessRequestUtil.getCurrentTagFromContext(this.getRequestContext());
                this.tags = new HashMap<String, Map<String, Object>>();
                this.tag = currentTag != null ? RangerRequestScriptEvaluator.toMap(currentTag) : Collections.emptyMap();
                for (RangerTagForEval tag : requestTags) {
                    this.tags.put(tag.getType(), RangerRequestScriptEvaluator.toMap(tag));
                }
                this.tagNames = this.getSorted(this.tags.keySet());
            } else {
                this.tags = Collections.emptyMap();
                this.tagNames = Collections.emptySet();
                this.tag = Collections.emptyMap();
            }
            this.initDone = true;
        }
    }

    private Map<String, Object> getRequestContext() {
        return this.accessRequest.getContext();
    }

    private Set<RangerTagForEval> getAllTags() {
        Set<RangerTagForEval> ret = RangerAccessRequestUtil.getRequestTagsFromContext(this.accessRequest.getContext());
        if (ret == null && LOG.isDebugEnabled()) {
            String resource = this.accessRequest.getResource().getAsString();
            this.logDebug("RangerRequestScriptEvaluator.getAllTags() - No TAGS. No TAGS for the RangerAccessResource=" + resource);
        }
        return ret;
    }

    private static Map<String, Object> toMap(RangerTagForEval tag) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (tag.getAttributes() != null) {
            ret.putAll(tag.getAttributes());
        }
        ret.put("_type", tag.getType());
        ret.put("_matchType", (Object)tag.getMatchType());
        return ret;
    }

    private Collection<String> getSorted(Collection<String> values) {
        Collection<String> ret;
        if (values == null) {
            ret = Collections.emptyList();
        } else if (values.size() > 1) {
            ArrayList<String> lst = new ArrayList<String>(values);
            Collections.sort(lst);
            ret = lst;
        } else {
            ret = values;
        }
        return ret;
    }

    private Map<String, String> copyMap(Map<String, String> obj) {
        return obj == null ? new HashMap<String, String>() : new HashMap<String, String>(obj);
    }

    private List<Object> getUgAttr(String attrName) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (String groupName : this.userGroups) {
            Map<String, String> attrs = this.groupAttrs.get(groupName);
            String val = attrs != null ? attrs.get(attrName) : null;
            if (val == null) continue;
            ret.add(val);
        }
        return ret;
    }

    private List<Object> getTagAttr(String attrName) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (String tagName : this.tagNames) {
            Map<String, Object> attrs = this.tags.get(tagName);
            Object val = attrs != null ? attrs.get(attrName) : null;
            if (val == null) continue;
            ret.add(val);
        }
        return ret;
    }

    private Collection<String> getUserAttrNames() {
        Collection<String> ret = this.getSorted(this.userAttrs.keySet());
        if (ret.contains("_name")) {
            ret.remove("_name");
        }
        return ret;
    }

    private Collection<String> getUgAttrNames() {
        HashSet<String> ret = new HashSet<String>();
        for (Map<String, String> attrs : this.groupAttrs.values()) {
            ret.addAll(attrs.keySet());
        }
        ret.remove("_name");
        return this.getSorted(ret);
    }

    private Collection<String> getTagAttrNames() {
        HashSet<String> ret = new HashSet<String>();
        for (Map<String, Object> attrs : this.tags.values()) {
            ret.addAll(attrs.keySet());
        }
        ret.remove("_type");
        ret.remove("_matchType");
        return this.getSorted(ret);
    }

    private String toCsv(Collection<? extends Object> values, Object[] args) {
        String defValue;
        StringBuilder sb = new StringBuilder();
        String separator = this.getSeparator(args);
        for (Object object : values) {
            if (object == null) continue;
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(object);
        }
        if (sb.length() == 0 && (defValue = this.getDefaultValue(args)) != null) {
            sb.append(this.getDefaultValue(args));
        }
        return sb.toString();
    }

    private String toCsvQ(Collection<? extends Object> values, Object[] args) {
        String defValue;
        StringBuilder sb = new StringBuilder();
        String openQuote = this.getOpenQuote(args);
        String closeQuote = this.getCloseQuote(args, openQuote);
        String separator = this.getSeparator(args);
        for (Object object : values) {
            if (object == null) continue;
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(openQuote).append(object).append(closeQuote);
        }
        if (sb.length() == 0 && (defValue = this.getDefaultValue(args)) != null) {
            sb.append(openQuote).append(this.getDefaultValue(args)).append(closeQuote);
        }
        return sb.toString();
    }

    private String getDefaultValue(Object[] args) {
        Object ret = args != null && args.length > 0 ? args[0] : null;
        return ret != null ? ret.toString() : null;
    }

    private String getSeparator(Object[] args) {
        String ret = args != null && args.length > 1 ? args[1] : STR_COMMA;
        return ret != null ? ret.toString() : "";
    }

    private String getOpenQuote(Object[] args) {
        String ret = args != null && args.length > 2 ? args[2] : STR_QUOTE;
        return ret != null ? ret.toString() : "";
    }

    private String getCloseQuote(Object[] args, String openQuote) {
        Object ret = args != null && args.length > 3 ? args[3] : null;
        return ret != null ? ret.toString() : openQuote;
    }

    private static String getJsonVarNamesPattern() {
        ArrayList<String> varNames = new ArrayList<String>();
        varNames.add("_ctx");
        varNames.add("REQ");
        varNames.add("RES");
        varNames.add("TAG");
        varNames.add("TAGNAMES");
        varNames.add("TAGS");
        varNames.add("UGA");
        varNames.add("UG");
        varNames.add("UGNAMES");
        varNames.add("URNAMES");
        varNames.add("USER");
        return "\\b(" + StringUtils.join(varNames, (char)'|') + ")\\b";
    }

    private static String getUserAttributesPattern() {
        ArrayList<String> varNames = new ArrayList<String>();
        varNames.add("USER");
        varNames.add("GET_USER_ATTR");
        varNames.add("GET_USER_ATTR_Q");
        varNames.add("GET_USER_ATTR_NAMES");
        varNames.add("GET_USER_ATTR_NAMES_Q");
        varNames.add("USER_ATTR_NAMES_CSV");
        varNames.add("USER_ATTR_NAMES_Q_CSV");
        varNames.add("HAS_USER_ATTR");
        varNames.add("userAttr");
        varNames.add("userAttrQ");
        varNames.add("userAttrNames");
        varNames.add("userAttrNamesQ");
        varNames.add("userAttrNamesCsv");
        varNames.add("userAttrNamesCsvQ");
        varNames.add("hasUserAttr");
        return "\\b(" + StringUtils.join(varNames, (char)'|') + ")\\b";
    }

    private static String getGroupAttributesPattern() {
        ArrayList<String> varNames = new ArrayList<String>();
        varNames.add("UG");
        varNames.add("UGA");
        varNames.add("GET_UG_ATTR");
        varNames.add("GET_UG_ATTR_Q");
        varNames.add("GET_UG_ATTR_CSV");
        varNames.add("GET_UG_ATTR_Q_CSV");
        varNames.add("GET_UG_ATTR_NAMES");
        varNames.add("GET_UG_ATTR_NAMES_Q");
        varNames.add("UG_ATTR_NAMES_CSV");
        varNames.add("UG_ATTR_NAMES_Q_CSV");
        varNames.add("HAS_UG_ATTR");
        varNames.add("ugAttr");
        varNames.add("ugAttrQ");
        varNames.add("ugAttrCsv");
        varNames.add("ugAttrCsvQ");
        varNames.add("ugAttrNames");
        varNames.add("ugAttrNamesQ");
        varNames.add("ugAttrNamesCsv");
        varNames.add("ugAttrNamesCsvQ");
        varNames.add("hasUgAttr");
        return "\\b(" + StringUtils.join(varNames, (char)'|') + ")\\b";
    }

    private static Map<String, String> getMacrosMap() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("GET_TAG_NAMES", "ctx.tagNames");
        ret.put("GET_TAG_NAMES_Q", "ctx.tagNamesQ");
        ret.put("GET_TAG_ATTR_NAMES", "ctx.tagAttrNames");
        ret.put("GET_TAG_ATTR_NAMES_Q", "ctx.tagAttrNamesQ");
        ret.put("GET_TAG_ATTR", "ctx.tagAttr");
        ret.put("GET_TAG_ATTR_Q", "ctx.tagAttrQ");
        ret.put("GET_UG_NAMES", "ctx.ugNames");
        ret.put("GET_UG_NAMES_Q", "ctx.ugNamesQ");
        ret.put("GET_UG_ATTR_NAMES", "ctx.ugAttrNames");
        ret.put("GET_UG_ATTR_NAMES_Q", "ctx.ugAttrNamesQ");
        ret.put("GET_UG_ATTR", "ctx.ugAttr");
        ret.put("GET_UG_ATTR_Q", "ctx.ugAttrQ");
        ret.put("GET_UR_NAMES", "ctx.urNames");
        ret.put("GET_UR_NAMES_Q", "ctx.urNamesQ");
        ret.put("GET_USER_ATTR_NAMES", "ctx.userAttrNames");
        ret.put("GET_USER_ATTR_NAMES_Q", "ctx.userAttrNamesQ");
        ret.put("GET_USER_ATTR", "ctx.userAttr");
        ret.put("GET_USER_ATTR_Q", "ctx.userAttrQ");
        ret.put("GET_TAG_ATTR_CSV", "ctx.tagAttrCsv");
        ret.put("GET_TAG_ATTR_Q_CSV", "ctx.tagAttrCsvQ");
        ret.put("GET_UG_ATTR_CSV", "ctx.ugAttrCsv");
        ret.put("GET_UG_ATTR_Q_CSV", "ctx.ugAttrCsvQ");
        ret.put("TAG_ATTR_NAMES_CSV", "ctx.tagAttrNamesCsv()");
        ret.put("TAG_ATTR_NAMES_Q_CSV", "ctx.tagAttrNamesCsvQ()");
        ret.put("TAG_NAMES_CSV", "ctx.tagNamesCsv()");
        ret.put("TAG_NAMES_Q_CSV", "ctx.tagNamesCsvQ()");
        ret.put("UG_ATTR_NAMES_CSV", "ctx.ugAttrNamesCsv()");
        ret.put("UG_ATTR_NAMES_Q_CSV", "ctx.ugAttrNamesCsvQ()");
        ret.put("UG_NAMES_CSV", "ctx.ugNamesCsv()");
        ret.put("UG_NAMES_Q_CSV", "ctx.ugNamesCsvQ()");
        ret.put("UR_NAMES_CSV", "ctx.urNamesCsv()");
        ret.put("UR_NAMES_Q_CSV", "ctx.urNamesCsvQ()");
        ret.put("USER_ATTR_NAMES_CSV", "ctx.userAttrNamesCsv()");
        ret.put("USER_ATTR_NAMES_Q_CSV", "ctx.userAttrNamesCsvQ()");
        ret.put("HAS_TAG", "ctx.hasTag");
        ret.put("HAS_ANY_TAG", "ctx.hasAnyTag()");
        ret.put("HAS_NO_TAG", "!ctx.hasAnyTag()");
        ret.put("HAS_USER_ATTR", "ctx.hasUserAttr");
        ret.put("HAS_UG_ATTR", "ctx.hasUgAttr");
        ret.put("HAS_TAG_ATTR", "ctx.hasTagAttr");
        ret.put("IS_IN_GROUP", "ctx.isInGroup");
        ret.put("IS_IN_ROLE", "ctx.isInRole");
        ret.put("IS_IN_ANY_GROUP", "ctx.isInAnyGroup()");
        ret.put("IS_IN_ANY_ROLE", "ctx.isInAnyRole()");
        ret.put("IS_NOT_IN_ANY_GROUP", "!ctx.isInAnyGroup()");
        ret.put("IS_NOT_IN_ANY_ROLE", "!ctx.isInAnyRole()");
        ret.put("IS_ACCESS_TIME_AFTER", "ctx.isAccessTimeAfter");
        ret.put("IS_ACCESS_TIME_BEFORE", "ctx.isAccessTimeBefore");
        ret.put("IS_ACCESS_TIME_BETWEEN", "ctx.isAccessTimeBetween");
        return ret;
    }

    public void logDebug(Object msg) {
        LOG.debug("", msg);
    }

    public void logInfo(Object msg) {
        LOG.info("", msg);
    }

    public void logWarn(Object msg) {
        LOG.warn("", msg);
    }

    public void logError(Object msg) {
        LOG.error("", msg);
    }

    public void logFatal(Object msg) {
        LOG.error("", msg);
    }

    static {
        RangerRequestScriptEvaluator.init(null);
        THREADLOCAL_DATE_FORMATS = new ThreadLocal<List<SimpleDateFormat>>(){

            @Override
            protected List<SimpleDateFormat> initialValue() {
                ArrayList<SimpleDateFormat> ret = new ArrayList<SimpleDateFormat>();
                for (String dateFormatString : dateFormatStrings) {
                    try {
                        if (!StringUtils.isNotBlank((String)dateFormatString)) continue;
                        if (StringUtils.equalsIgnoreCase((String)dateFormatString, (String)RangerRequestScriptEvaluator.DEFAULT_ATLAS_TAG_ATTRIBUTE_DATE_FORMAT_NAME)) {
                            dateFormatString = RangerRequestScriptEvaluator.DEFAULT_ATLAS_TAG_ATTRIBUTE_DATE_FORMAT;
                        }
                        SimpleDateFormat df = new SimpleDateFormat(dateFormatString);
                        df.setLenient(false);
                        ret.add(df);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return ret;
            }
        };
    }

    public static class UserGroupsAttributes {
        private final Collection<String> groupNames;
        private final Map<String, Map<String, String>> groupAttributes;

        public UserGroupsAttributes(Collection<String> groupNames, Map<String, Map<String, String>> groupAttributes) {
            this.groupNames = groupNames;
            this.groupAttributes = groupAttributes;
        }

        public Map<String, Map<String, Object>> getAttributes() {
            HashMap<String, Map<String, Object>> ret = new HashMap<String, Map<String, Object>>();
            HashMap<String, String> valueMap = new HashMap<String, String>();
            HashMap<String, ArrayList<String>> valuesMap = new HashMap<String, ArrayList<String>>();
            ret.put("sVal", valueMap);
            ret.put("mVal", valuesMap);
            if (this.groupNames != null && this.groupAttributes != null) {
                for (String groupName : this.groupNames) {
                    Map<String, String> attributes = this.groupAttributes.get(groupName);
                    if (attributes == null) continue;
                    for (Map.Entry<String, String> entry : attributes.entrySet()) {
                        ArrayList<String> values;
                        String attrName = entry.getKey();
                        String attrValue = entry.getValue();
                        if (!valueMap.containsKey(attrName)) {
                            valueMap.put(attrName, attrValue);
                        }
                        if ((values = (ArrayList<String>)valuesMap.get(attrName)) == null) {
                            values = new ArrayList<String>();
                            valuesMap.put(attrName, values);
                        }
                        values.add(attrValue);
                    }
                }
            }
            return ret;
        }
    }
}

