/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl.prefetch;

import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.slf4j.Logger;

public class ExecutorServiceFuturePool {
    private final ExecutorService executor;

    public ExecutorServiceFuturePool(ExecutorService executor) {
        this.executor = executor;
    }

    public Future<Void> executeFunction(Supplier<Void> f) {
        return this.executor.submit(f::get);
    }

    public Future<Void> executeRunnable(Runnable r) {
        return this.executor.submit(r::run);
    }

    public void shutdown(Logger logger, long timeout, TimeUnit unit) {
        HadoopExecutors.shutdown(this.executor, logger, timeout, unit);
    }

    public String toString() {
        return String.format(Locale.ROOT, "ExecutorServiceFuturePool(executor=%s)", this.executor);
    }
}

