/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.discovery.multicast;

import java.io.IOException;
import org.apache.qpid.jms.provider.discovery.multicast.PacketParser;
import org.apache.qpid.jms.util.FactoryFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PacketParserFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PacketParserFactory.class);
    private static final FactoryFinder<PacketParserFactory> AGENT_FACTORY_FINDER = new FactoryFinder(PacketParserFactory.class, "META-INF/services/org/apache/qpid/jms/provider/agents/multicast-parsers/");

    public abstract PacketParser createPacketParser(String var1) throws Exception;

    public abstract String getName();

    public static PacketParser createAgent(String key) throws Exception {
        PacketParser result = null;
        try {
            PacketParserFactory factory = PacketParserFactory.findAgentFactory(key);
            result = factory.createPacketParser(key);
        }
        catch (Exception ex) {
            LOG.error("Failed to create PacketParserFactory instance for: {}", (Object)key);
            LOG.trace("Error: ", (Throwable)ex);
            throw ex;
        }
        return result;
    }

    protected static PacketParserFactory findAgentFactory(String key) throws IOException {
        if (key == null) {
            throw new IOException("No PacketParserFactory name specified: [null]");
        }
        PacketParserFactory factory = null;
        if (factory == null) {
            try {
                factory = (PacketParserFactory)AGENT_FACTORY_FINDER.newInstance(key);
            }
            catch (Throwable e) {
                throw new IOException("Discovery Agent scheme NOT recognized: [" + key + "]", e);
            }
        }
        return factory;
    }
}

