/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.naming;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.common.naming.BundleSplitOption;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceBundleSplitAlgorithm;

public class SpecifiedPositionsBundleSplitAlgorithm
implements NamespaceBundleSplitAlgorithm {
    private boolean force;

    public SpecifiedPositionsBundleSplitAlgorithm() {
        this.force = false;
    }

    public SpecifiedPositionsBundleSplitAlgorithm(boolean force) {
        this.force = force;
    }

    @Override
    public CompletableFuture<List<Long>> getSplitBoundary(BundleSplitOption bundleSplitOption) {
        NamespaceService service = bundleSplitOption.getService();
        NamespaceBundle bundle = bundleSplitOption.getBundle();
        List<Long> positions = bundleSplitOption.getPositions();
        if (positions == null || positions.size() == 0) {
            throw new IllegalArgumentException("SplitBoundaries can't be empty");
        }
        Collections.sort(positions);
        if (this.force) {
            return this.getBoundaries(bundle, positions);
        }
        return service.getOwnedTopicListForNamespaceBundle(bundle).thenCompose(topics -> {
            if (topics == null || topics.size() <= 1) {
                return CompletableFuture.completedFuture(null);
            }
            return this.getBoundaries(bundle, positions);
        });
    }

    private CompletableFuture<List<Long>> getBoundaries(NamespaceBundle bundle, List<Long> positions) {
        List splitBoundaries = positions.stream().filter(position -> position > bundle.getLowerEndpoint() && position < bundle.getUpperEndpoint()).collect(Collectors.toList());
        if (splitBoundaries.size() == 0) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.completedFuture(splitBoundaries);
    }
}

