/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.impl;

import io.etcd.jetcd.Auth;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.ClientBuilder;
import io.etcd.jetcd.Cluster;
import io.etcd.jetcd.Election;
import io.etcd.jetcd.KV;
import io.etcd.jetcd.Lease;
import io.etcd.jetcd.Lock;
import io.etcd.jetcd.Maintenance;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.impl.AuthImpl;
import io.etcd.jetcd.impl.ClientConnectionManager;
import io.etcd.jetcd.impl.ClusterImpl;
import io.etcd.jetcd.impl.ElectionImpl;
import io.etcd.jetcd.impl.KVImpl;
import io.etcd.jetcd.impl.LeaseImpl;
import io.etcd.jetcd.impl.LockImpl;
import io.etcd.jetcd.impl.MaintenanceImpl;
import io.etcd.jetcd.impl.WatchImpl;
import io.etcd.jetcd.support.MemorizingClientSupplier;

public final class ClientImpl
implements Client {
    private final ClientConnectionManager connectionManager;
    private final MemorizingClientSupplier<KV> kvClient;
    private final MemorizingClientSupplier<Auth> authClient;
    private final MemorizingClientSupplier<Maintenance> maintenanceClient;
    private final MemorizingClientSupplier<Cluster> clusterClient;
    private final MemorizingClientSupplier<Lease> leaseClient;
    private final MemorizingClientSupplier<Watch> watchClient;
    private final MemorizingClientSupplier<Lock> lockClient;
    private final MemorizingClientSupplier<Election> electionClient;

    public ClientImpl(ClientBuilder clientBuilder) {
        this.connectionManager = new ClientConnectionManager(clientBuilder.copy());
        this.kvClient = new MemorizingClientSupplier<KV>(() -> new KVImpl(this.connectionManager));
        this.authClient = new MemorizingClientSupplier<Auth>(() -> new AuthImpl(this.connectionManager));
        this.maintenanceClient = new MemorizingClientSupplier<Maintenance>(() -> new MaintenanceImpl(this.connectionManager));
        this.clusterClient = new MemorizingClientSupplier<Cluster>(() -> new ClusterImpl(this.connectionManager));
        this.leaseClient = new MemorizingClientSupplier<Lease>(() -> new LeaseImpl(this.connectionManager));
        this.watchClient = new MemorizingClientSupplier<Watch>(() -> new WatchImpl(this.connectionManager));
        this.lockClient = new MemorizingClientSupplier<Lock>(() -> new LockImpl(this.connectionManager));
        this.electionClient = new MemorizingClientSupplier<Election>(() -> new ElectionImpl(this.connectionManager));
    }

    @Override
    public Auth getAuthClient() {
        return (Auth)this.authClient.get();
    }

    @Override
    public KV getKVClient() {
        return (KV)this.kvClient.get();
    }

    @Override
    public Cluster getClusterClient() {
        return (Cluster)this.clusterClient.get();
    }

    @Override
    public Maintenance getMaintenanceClient() {
        return (Maintenance)this.maintenanceClient.get();
    }

    @Override
    public Lease getLeaseClient() {
        return (Lease)this.leaseClient.get();
    }

    @Override
    public Watch getWatchClient() {
        return (Watch)this.watchClient.get();
    }

    @Override
    public Lock getLockClient() {
        return (Lock)this.lockClient.get();
    }

    @Override
    public Election getElectionClient() {
        return (Election)this.electionClient.get();
    }

    @Override
    public synchronized void close() {
        this.authClient.close();
        this.kvClient.close();
        this.clusterClient.close();
        this.maintenanceClient.close();
        this.leaseClient.close();
        this.watchClient.close();
        this.lockClient.close();
        this.electionClient.close();
        this.connectionManager.close();
    }
}

