/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.CharacterData;
import org.w3c.dom.*;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.w3c.domts.DOMTest.load;


/**
 * The "normalize()" method puts all the nodes in the full
 * depth of the sub-tree underneath this element into a
 * "normal" form.
 * <p>
 * Retrieve the third employee and access its second child.
 * This child contains a block of text that is spread
 * across multiple lines.   The content of the "name" child
 * should be parsed and treated as a single Text node.
 * <p>
 * This appears to be a duplicate of elementnormalize.xml in DOM L1 Test Suite
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-normalize">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-normalize</a>
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-72AB8359">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-72AB8359</a>
 */


public class normalize01 {
    @Test
    void testRun() throws Throwable {
        Document doc = load("staff", false);
        Element root = doc.getDocumentElement();
        root.normalize();
        NodeList elementList = root.getElementsByTagName("name");
        Node firstChild = elementList.item(2);
        NodeList textList = firstChild.getChildNodes();
        CharacterData textNode = (CharacterData) textList.item(0);
        String data = textNode.getData();
        assertEquals("Roger\n Jones", data, "data");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/normalize01";
    }

}
