/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.util.LinkedList;
import java.util.List;
import org.jline.builtins.Completers;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.impl.completer.AggregateCompleter;
import org.jline.reader.impl.completer.ArgumentCompleter;
import org.jline.reader.impl.completer.NullCompleter;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.utils.AttributedString;
import sqlline.CommandHandler;
import sqlline.SqlLine;

class SqlLineCommandCompleter
extends AggregateCompleter {
    SqlLineCommandCompleter(SqlLine sqlLine) {
        super(new LinkedList<Completer>());
        LinkedList<Completer> completers = new LinkedList<Completer>();
        for (CommandHandler commandHandler : sqlLine.getCommandHandlers()) {
            for (String cmd : commandHandler.getNames()) {
                LinkedList<Completer> compl = new LinkedList<Completer>();
                List<Completer> parameterCompleters = commandHandler.getParameterCompleters();
                if (parameterCompleters.size() == 1 && parameterCompleters.iterator().next() instanceof Completers.RegexCompleter) {
                    completers.add(parameterCompleters.iterator().next());
                    continue;
                }
                String commandName = "!" + cmd;
                String helpText = commandHandler.getHelpText();
                int firstEndOfLineIndex = helpText.indexOf(10);
                compl.add(new StringsCompleter(new SqlLineCandidate(sqlLine, AttributedString.stripAnsi(commandName), commandName, sqlLine.loc("command-name", new Object[0]), firstEndOfLineIndex == -1 ? helpText : helpText.substring(0, firstEndOfLineIndex), null, helpText, true)));
                compl.addAll(parameterCompleters);
                compl.add(new NullCompleter());
                completers.add(new ArgumentCompleter(compl));
            }
        }
        this.getCompleters().addAll(completers);
    }

    static class SqlLineCandidate
    extends Candidate {
        private final SqlLine sqlLine;

        SqlLineCandidate(SqlLine sqlLine, String value, String displ, String group, String descr, String suffix, String key, boolean complete) {
            super(value, displ, group, descr, suffix, key, complete);
            this.sqlLine = sqlLine;
        }

        @Override
        public String descr() {
            if (this.sqlLine.getOpts().getShowCompletionDescr()) {
                return super.descr();
            }
            return null;
        }
    }
}

