/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.apache.phoenix.pherf.PherfConstants;
import org.apache.phoenix.pherf.configuration.Column;
import org.apache.phoenix.pherf.configuration.DataModel;
import org.apache.phoenix.pherf.configuration.DataSequence;
import org.apache.phoenix.pherf.configuration.DataTypeMapping;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.configuration.XMLConfigParser;
import org.apache.phoenix.pherf.rules.DataValue;
import org.apache.phoenix.pherf.rules.RuleBasedDataGenerator;
import org.apache.phoenix.pherf.rules.SequentialDateDataGenerator;
import org.apache.phoenix.pherf.rules.SequentialIntegerDataGenerator;
import org.apache.phoenix.pherf.rules.SequentialListDataGenerator;
import org.apache.phoenix.pherf.rules.SequentialVarcharDataGenerator;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesApplier {
    private static final Logger LOGGER = LoggerFactory.getLogger(RulesApplier.class);
    private static final int OH_SHIT_LIMIT = 1000;
    private final Random rndNull;
    private final Random rndVal;
    private final RandomDataGenerator randomDataGenerator;
    private final DataModel dataModel;
    private final XMLConfigParser parser;
    private final List<Map> modelList;
    private final Map<String, Column> columnMap;
    private String cachedScenarioOverrideName;
    private Map<DataTypeMapping, List> scenarioOverrideMap;
    private ConcurrentHashMap<String, RuleBasedDataGenerator> columnRuleBasedDataGeneratorMap = new ConcurrentHashMap();

    public RulesApplier(DataModel model) {
        this(model, EnvironmentEdgeManager.currentTimeMillis());
    }

    public RulesApplier(DataModel model, long seed) {
        this.parser = null;
        this.dataModel = model;
        this.modelList = new ArrayList<Map>();
        this.columnMap = new HashMap<String, Column>();
        this.rndNull = new Random(seed);
        this.rndVal = new Random(seed);
        this.randomDataGenerator = new RandomDataGenerator();
        this.cachedScenarioOverrideName = null;
        this.populateModelList();
    }

    public RulesApplier(XMLConfigParser parser) {
        this(parser, EnvironmentEdgeManager.currentTimeMillis());
    }

    public RulesApplier(XMLConfigParser parser, long seed) {
        this.parser = parser;
        this.dataModel = null;
        this.modelList = new ArrayList<Map>();
        this.columnMap = new HashMap<String, Column>();
        this.rndNull = new Random(seed);
        this.rndVal = new Random(seed);
        this.randomDataGenerator = new RandomDataGenerator();
        this.cachedScenarioOverrideName = null;
        this.populateModelList();
    }

    public List<Map> getModelList() {
        return Collections.unmodifiableList(this.modelList);
    }

    private Map<DataTypeMapping, List> getCachedScenarioOverrides(Scenario scenario) {
        if (this.cachedScenarioOverrideName == null || this.cachedScenarioOverrideName != scenario.getName()) {
            this.cachedScenarioOverrideName = scenario.getName();
            this.scenarioOverrideMap = new HashMap<DataTypeMapping, List>();
            if (scenario.getDataOverride() != null) {
                for (Column column : scenario.getDataOverride().getColumn()) {
                    DataTypeMapping type = column.getType();
                    if (this.scenarioOverrideMap.containsKey((Object)type)) {
                        this.scenarioOverrideMap.get((Object)type).add(column);
                        continue;
                    }
                    LinkedList<Column> cols = new LinkedList<Column>();
                    cols.add(column);
                    this.scenarioOverrideMap.put(type, cols);
                }
            }
        }
        return this.scenarioOverrideMap;
    }

    public DataValue getDataForRule(Scenario scenario, Column phxMetaColumn) throws Exception {
        List<Scenario> scenarios = this.dataModel != null ? this.dataModel.getScenarios() : this.parser.getScenarios();
        DataValue value = null;
        if (scenarios.contains(scenario)) {
            Map ruleMap;
            List ruleList;
            List overrideRuleList;
            LOGGER.debug("We found a correct Scenario" + scenario.getName());
            Map<DataTypeMapping, List> overrideRuleMap = this.getCachedScenarioOverrides(scenario);
            if (overrideRuleMap != null && (overrideRuleList = this.getCachedScenarioOverrides(scenario).get((Object)phxMetaColumn.getType())) != null && overrideRuleList.contains(phxMetaColumn)) {
                LOGGER.debug("We found a correct override column rule");
                Column columnRule = this.getColumnForRuleOverride(overrideRuleList, phxMetaColumn);
                if (columnRule != null) {
                    return this.getDataValue(columnRule);
                }
            }
            if ((ruleList = (List)(ruleMap = this.modelList.get(0)).get((Object)phxMetaColumn.getType())) != null && ruleList.contains(phxMetaColumn)) {
                LOGGER.debug("We found a correct column rule");
                Column columnRule = this.getColumnForRule(ruleList, phxMetaColumn);
                value = this.getDataValue(columnRule);
            } else {
                LOGGER.warn(String.format("Attempted to apply rule to data, but could not find a rule to match type %s on %s", new Object[]{phxMetaColumn.getType(), phxMetaColumn.getName()}));
            }
        }
        return value;
    }

    public DataValue getDataValue(Column column) throws Exception {
        DataValue data = null;
        String prefix = "";
        int length = column.getLength();
        int nullChance = column.getNullChance();
        List<DataValue> dataValues = column.getDataValues();
        if (nullChance != Integer.MIN_VALUE && this.isValueNull(nullChance)) {
            return new DataValue(column.getType(), "");
        }
        if (column.getPrefix() != null) {
            prefix = column.getPrefix();
        }
        if (prefix.length() >= length && length > 0) {
            LOGGER.warn("You are attempting to generate data with a prefix (" + prefix + ") That is longer than expected overall field length (" + length + "). This will certainly lead to unexpected data values.");
        }
        switch (column.getType()) {
            case VARCHAR: 
            case VARBINARY: 
            case CHAR: {
                if (DataSequence.SEQUENTIAL.equals((Object)column.getDataSequence())) {
                    RuleBasedDataGenerator generator = this.getRuleBasedDataGeneratorForColumn(column);
                    data = generator.getDataValue();
                    break;
                }
                if (column.getDataValues() != null && column.getDataValues().size() > 0) {
                    data = this.pickDataValueFromList(dataValues);
                    break;
                }
                Preconditions.checkArgument(length > 0, "length needs to be > 0");
                data = this.getRandomDataValue(column);
                break;
            }
            case VARCHAR_ARRAY: {
                String arr = "";
                for (DataValue dv : dataValues) {
                    arr = arr + "," + dv.getValue();
                }
                if (arr.startsWith(",")) {
                    arr = arr.replaceFirst(",", "");
                }
                data = new DataValue(column.getType(), arr);
                break;
            }
            case DECIMAL: {
                if (column.getDataValues() != null && column.getDataValues().size() > 0) {
                    data = this.pickDataValueFromList(dataValues);
                    break;
                }
                int precision = column.getPrecision();
                double minDbl = column.getMinValue();
                Preconditions.checkArgument(precision > 0 && precision <= 18, "Precision must be between 0 and 18");
                Preconditions.checkArgument(minDbl >= 0.0, "minvalue must be set in configuration for decimal");
                Preconditions.checkArgument(column.getMaxValue() > 0L, "maxValue must be set in configuration decimal");
                StringBuilder maxValueStr = new StringBuilder();
                for (int i = 0; i < precision; ++i) {
                    maxValueStr.append(9);
                }
                double maxDbl = Math.min((double)column.getMaxValue(), Double.parseDouble(maxValueStr.toString()));
                double dbl = RandomUtils.nextDouble(minDbl, maxDbl);
                data = new DataValue(column.getType(), String.valueOf(dbl));
                break;
            }
            case TINYINT: 
            case INTEGER: {
                if (column.getDataValues() != null && column.getDataValues().size() > 0) {
                    data = this.pickDataValueFromList(dataValues);
                    break;
                }
                if (DataSequence.SEQUENTIAL.equals((Object)column.getDataSequence())) {
                    RuleBasedDataGenerator generator = this.getRuleBasedDataGeneratorForColumn(column);
                    data = generator.getDataValue();
                    break;
                }
                int minInt = (int)column.getMinValue();
                int maxInt = (int)column.getMaxValue();
                if (column.getType() == DataTypeMapping.TINYINT) {
                    Preconditions.checkArgument(minInt >= -128 && minInt <= 128, "min value need to be set in configuration for tinyints " + column.getName());
                    Preconditions.checkArgument(maxInt >= -128 && maxInt <= 128, "max value need to be set in configuration for tinyints " + column.getName());
                }
                int intVal = ThreadLocalRandom.current().nextInt(minInt, maxInt + 1);
                data = new DataValue(column.getType(), String.valueOf(intVal));
                break;
            }
            case BIGINT: 
            case UNSIGNED_LONG: {
                if (column.getDataValues() != null && column.getDataValues().size() > 0) {
                    data = this.pickDataValueFromList(dataValues);
                    break;
                }
                long minLong = column.getMinValue();
                long maxLong = column.getMaxValue();
                if (column.getType() == DataTypeMapping.UNSIGNED_LONG) {
                    Preconditions.checkArgument(minLong > 0L && maxLong > 0L, "min and max values need to be set in configuration for unsigned_longs " + column.getName());
                }
                long longVal = RandomUtils.nextLong(minLong, maxLong);
                data = new DataValue(column.getType(), String.valueOf(longVal));
                break;
            }
            case DATE: 
            case TIMESTAMP: {
                if (column.getDataValues() != null && column.getDataValues().size() > 0) {
                    data = this.pickDataValueFromList(dataValues);
                    data.setValue(this.checkDatePattern(data.getValue()));
                    break;
                }
                if (DataSequence.SEQUENTIAL.equals((Object)column.getDataSequence())) {
                    RuleBasedDataGenerator generator = this.getRuleBasedDataGeneratorForColumn(column);
                    data = generator.getDataValue();
                    break;
                }
                if (!column.getUseCurrentDate()) {
                    int minYear = (int)column.getMinValue();
                    int maxYear = (int)column.getMaxValue();
                    Preconditions.checkArgument(minYear > 0 && maxYear > 0, "min and max values need to be set in configuration for date/timestamps " + column.getName());
                    String dt = this.generateRandomDate(minYear, maxYear);
                    data = new DataValue(column.getType(), dt);
                    data.setMaxValue(String.valueOf(minYear));
                    data.setMinValue(String.valueOf(maxYear));
                    break;
                }
                String dt = this.getCurrentDate();
                data = new DataValue(column.getType(), dt);
                break;
            }
        }
        Preconditions.checkArgument(data != null, "Data value could not be generated for some reason. Please check configs");
        return data;
    }

    public String generateRandomDate(int min, int max) throws Exception {
        String mindt = min + "-01-01 00:00:00.000";
        String maxdt = max + "-12-31 23:59:59.999";
        return this.generateRandomDate(mindt, maxdt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateRandomDate(String min, String max) throws Exception {
        DateTime dt;
        DateTimeFormatter fmtr = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss.SSS").withZone(DateTimeZone.UTC);
        DateTime minDt = fmtr.parseDateTime(this.checkDatePattern(min));
        DateTime maxDt = fmtr.parseDateTime(this.checkDatePattern(max));
        RandomDataGenerator randomDataGenerator = this.randomDataGenerator;
        synchronized (randomDataGenerator) {
            long rndLong = this.randomDataGenerator.nextLong(minDt.getMillis() + 1L, maxDt.getMillis() - 1L);
            dt = new DateTime(rndLong, PherfConstants.DEFAULT_TIME_ZONE);
        }
        return fmtr.print(dt);
    }

    public String getCurrentDate() {
        DateTimeFormatter fmtr = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss.SSS").withZone(DateTimeZone.UTC);
        DateTime dt = new DateTime(PherfConstants.DEFAULT_TIME_ZONE);
        return fmtr.print(dt);
    }

    private boolean isValueNull(int chance) {
        return this.rndNull.nextInt(100) < chance;
    }

    private DataValue pickDataValueFromList(List<DataValue> values) throws Exception {
        DataValue generatedDataValue = null;
        int sum = 0;
        int count = 0;
        for (DataValue value : values) {
            int dist = value.getDistribution();
            sum += dist;
        }
        Preconditions.checkArgument(sum == 100 || sum == 0, "Distributions need to add up to 100 or not exist.");
        while (generatedDataValue == null) {
            int rndIndex = this.rndVal.nextInt(values.size());
            DataValue valueRule = values.get(rndIndex);
            generatedDataValue = this.pickDataValueFromList(valueRule);
            if (count++ != 1000) continue;
            LOGGER.info("We generated a value from hitting our OH_SHIT_LIMIT: 1000");
            generatedDataValue = valueRule;
        }
        return generatedDataValue;
    }

    private DataValue pickDataValueFromList(DataValue valueRule) throws Exception {
        DataValue retValue = new DataValue(valueRule);
        if (valueRule.getValue() != null) {
            int chance = valueRule.getDistribution() == 0 ? 100 : valueRule.getDistribution();
            return this.rndVal.nextInt(100) <= chance ? retValue : null;
        }
        if (valueRule.getUseCurrentDate()) {
            int chance = valueRule.getDistribution() == 0 ? 100 : valueRule.getDistribution();
            retValue.setValue(this.getCurrentDate());
            return this.rndVal.nextInt(100) <= chance ? retValue : null;
        }
        Preconditions.checkArgument(retValue.getMinValue() != null || retValue.getMaxValue() != null, "Both min/maxValue tags must be set if value tag is not used");
        Preconditions.checkArgument(retValue.getType() == DataTypeMapping.DATE, "Currently on DATE is supported for ranged random values");
        retValue.setValue(this.generateRandomDate(retValue.getMinValue(), retValue.getMaxValue()));
        retValue.setValue(this.generateRandomDate(retValue.getMinValue(), retValue.getMaxValue()));
        retValue.setMinValue(this.checkDatePattern(valueRule.getMinValue()));
        retValue.setMaxValue(this.checkDatePattern(valueRule.getMaxValue()));
        return retValue;
    }

    public String checkDatePattern(String date) {
        DateTimeFormatter fmtr = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss.SSS").withZone(DateTimeZone.UTC);
        DateTime parsedDate = fmtr.parseDateTime(date);
        return fmtr.print(parsedDate);
    }

    private void populateModelList() {
        if (!this.modelList.isEmpty()) {
            return;
        }
        List<DataModel> models = this.dataModel != null ? Lists.newArrayList(this.dataModel) : this.parser.getDataModels();
        for (DataModel model : models) {
            HashMap ruleMap = new HashMap();
            for (Column column : model.getDataMappingColumns()) {
                this.columnMap.put(column.getName(), column);
                DataTypeMapping type = column.getType();
                if (ruleMap.containsKey((Object)type)) {
                    ((List)ruleMap.get((Object)type)).add(column);
                    continue;
                }
                LinkedList<Column> cols = new LinkedList<Column>();
                cols.add(column);
                ruleMap.put(type, cols);
            }
            this.modelList.add(ruleMap);
        }
    }

    public Column getRule(Column phxMetaColumn) {
        Map ruleMap = this.modelList.get(0);
        List ruleList = (List)ruleMap.get((Object)phxMetaColumn.getType());
        return this.getColumnForRule(ruleList, phxMetaColumn);
    }

    public Column getRule(String columnName) {
        return this.getRule(columnName, null);
    }

    public Column getRule(String columnName, Scenario scenario) {
        if (null != scenario && null != scenario.getDataOverride()) {
            for (Column column : scenario.getDataOverride().getColumn()) {
                if (!column.getName().equals(columnName)) continue;
                return column;
            }
        }
        return this.columnMap.get(columnName);
    }

    private Column getColumnForRuleOverride(List<Column> ruleList, Column phxMetaColumn) {
        for (Column columnRule : ruleList) {
            if (!columnRule.getName().equals(phxMetaColumn.getName())) continue;
            return new Column(columnRule);
        }
        return null;
    }

    private Column getColumnForRule(List<Column> ruleList, Column phxMetaColumn) {
        Column ruleAppliedColumn = new Column(ruleList.get(0));
        for (Column columnRule : ruleList) {
            if (columnRule.isUserDefined() && !columnRule.getName().equals(phxMetaColumn.getName())) continue;
            ruleAppliedColumn.mutate(columnRule);
        }
        return ruleAppliedColumn;
    }

    private DataValue getRandomDataValue(Column column) {
        String varchar = RandomStringUtils.randomAlphanumeric(column.getLength());
        varchar = column.getPrefix() != null ? column.getPrefix() + varchar : varchar;
        varchar = StringUtils.left(varchar, column.getLength());
        return new DataValue(column.getType(), varchar);
    }

    private RuleBasedDataGenerator getRuleBasedDataGeneratorForColumn(Column column) {
        RuleBasedDataGenerator generator = this.columnRuleBasedDataGeneratorMap.get(column.getName());
        if (generator == null) {
            switch (column.getType()) {
                case VARCHAR: 
                case VARBINARY: 
                case CHAR: {
                    if (column.getDataValues() != null && column.getDataValues().size() > 0) {
                        generator = new SequentialListDataGenerator(column);
                        break;
                    }
                    generator = new SequentialVarcharDataGenerator(column);
                    break;
                }
                case DATE: 
                case TIMESTAMP: {
                    generator = new SequentialDateDataGenerator(column);
                    break;
                }
                case TINYINT: 
                case INTEGER: 
                case BIGINT: 
                case UNSIGNED_LONG: {
                    generator = new SequentialIntegerDataGenerator(column);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("No rule based generator supported for column type %s on %s", new Object[]{column.getType(), column.getName()}));
                }
            }
            RuleBasedDataGenerator oldGenerator = this.columnRuleBasedDataGeneratorMap.putIfAbsent(column.getName(), generator);
            if (oldGenerator != null) {
                generator = oldGenerator;
            }
        }
        return generator;
    }
}

