/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.colorpane;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.debugger.colorpane.ColorBarCellRenderer;
import org.apache.pdfbox.debugger.colorpane.DeviceNColorant;
import org.apache.pdfbox.debugger.colorpane.DeviceNTableModel;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN;

public class CSDeviceN {
    private final PDDeviceN deviceN;
    private JPanel panel;

    public CSDeviceN(COSArray array) throws IOException {
        this.deviceN = new PDDeviceN(array, null);
        DeviceNColorant[] colorants = this.getColorantData();
        this.initUI(colorants);
    }

    private DeviceNColorant[] getColorantData() throws IOException {
        List colorantNames = this.deviceN.getColorantNames();
        int componentCount = colorantNames.size();
        DeviceNColorant[] colorants = new DeviceNColorant[componentCount];
        for (int i = 0; i < componentCount; ++i) {
            DeviceNColorant colorant = new DeviceNColorant();
            colorant.setName((String)colorantNames.get(i));
            float[] maximum = new float[componentCount];
            float[] minimum = new float[componentCount];
            maximum[i] = 1.0f;
            colorant.setMaximum(this.getColorObj(this.deviceN.toRGB(maximum)));
            colorant.setMinimum(this.getColorObj(this.deviceN.toRGB(minimum)));
            colorants[i] = colorant;
        }
        return colorants;
    }

    private void initUI(DeviceNColorant[] colorants) {
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.panel.setPreferredSize(new Dimension(300, 500));
        JLabel colorSpaceLabel = new JLabel("DeviceN colorspace");
        colorSpaceLabel.setAlignmentX(0.5f);
        colorSpaceLabel.setFont(new Font("Monospaced", 1, 30));
        DeviceNTableModel tableModel = new DeviceNTableModel(colorants);
        JTable table = new JTable(tableModel);
        table.setDefaultRenderer(Color.class, new ColorBarCellRenderer());
        table.setRowHeight(60);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(table);
        this.panel.add(colorSpaceLabel);
        this.panel.add(scrollPane);
    }

    public Component getPanel() {
        return this.panel;
    }

    private Color getColorObj(float[] rgbValues) {
        return new Color(rgbValues[0], rgbValues[1], rgbValues[2]);
    }
}

