/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.debugger.ui.ArrayEntry;
import org.apache.pdfbox.debugger.ui.DocumentEntry;
import org.apache.pdfbox.debugger.ui.MapEntry;
import org.apache.pdfbox.debugger.ui.PageEntry;

public class PDFTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final ImageIcon ICON_ARRAY = new ImageIcon(PDFTreeCellRenderer.getImageUrl("array"));
    private static final ImageIcon ICON_BOOLEAN = new ImageIcon(PDFTreeCellRenderer.getImageUrl("boolean"));
    private static final ImageIcon ICON_DICT = new ImageIcon(PDFTreeCellRenderer.getImageUrl("dict"));
    private static final ImageIcon ICON_HEX = new ImageIcon(PDFTreeCellRenderer.getImageUrl("hex"));
    private static final ImageIcon ICON_INDIRECT = new ImageIcon(PDFTreeCellRenderer.getImageUrl("indirect"));
    private static final ImageIcon ICON_INTEGER = new ImageIcon(PDFTreeCellRenderer.getImageUrl("integer"));
    private static final ImageIcon ICON_NAME = new ImageIcon(PDFTreeCellRenderer.getImageUrl("name"));
    private static final ImageIcon ICON_NULL = new ImageIcon(PDFTreeCellRenderer.getImageUrl("null"));
    private static final ImageIcon ICON_REAL = new ImageIcon(PDFTreeCellRenderer.getImageUrl("real"));
    private static final ImageIcon ICON_STREAM_DICT = new ImageIcon(PDFTreeCellRenderer.getImageUrl("stream-dict"));
    private static final ImageIcon ICON_STRING = new ImageIcon(PDFTreeCellRenderer.getImageUrl("string"));
    private static final ImageIcon ICON_PDF = new ImageIcon(PDFTreeCellRenderer.getImageUrl("pdf"));
    private static final ImageIcon ICON_PAGE = new ImageIcon(PDFTreeCellRenderer.getImageUrl("page"));

    private static URL getImageUrl(String name) {
        String fullName = "/org/apache/pdfbox/debugger/" + name + ".png";
        return PDFTreeCellRenderer.class.getResource(fullName);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object nodeValue, boolean isSelected, boolean expanded, boolean leaf, int row, boolean componentHasFocus) {
        Component component = super.getTreeCellRendererComponent(tree, this.toTreeObject(nodeValue), isSelected, expanded, leaf, row, componentHasFocus);
        this.setIcon(this.lookupIconWithOverlay(nodeValue));
        return component;
    }

    private Object toTreeObject(Object nodeValue) {
        Object result = nodeValue;
        if (nodeValue instanceof MapEntry || nodeValue instanceof ArrayEntry) {
            COSBase item;
            COSBase value;
            Object object;
            String key;
            Object entry;
            if (nodeValue instanceof MapEntry) {
                entry = (MapEntry)nodeValue;
                key = ((MapEntry)entry).getKey().getName();
                object = this.toTreeObject(((MapEntry)entry).getValue());
                value = ((MapEntry)entry).getValue();
                item = ((MapEntry)entry).getItem();
            } else {
                entry = (ArrayEntry)nodeValue;
                key = Integer.toString(((ArrayEntry)entry).getIndex());
                object = this.toTreeObject(((ArrayEntry)entry).getValue());
                value = ((ArrayEntry)entry).getValue();
                item = ((ArrayEntry)entry).getItem();
            }
            String stringResult = key;
            if (object instanceof String && ((String)object).length() > 0) {
                stringResult = stringResult + ":  " + object;
                if (item instanceof COSObject) {
                    COSObject indirect = (COSObject)item;
                    stringResult = stringResult + " [" + indirect.getObjectNumber() + " " + indirect.getGenerationNumber() + " R]";
                }
                stringResult = stringResult + this.toTreePostfix(value);
            }
            result = stringResult;
        } else if (nodeValue instanceof COSBoolean) {
            result = Boolean.toString(((COSBoolean)nodeValue).getValue());
        } else if (nodeValue instanceof COSFloat) {
            result = Float.toString(((COSFloat)nodeValue).floatValue());
        } else if (nodeValue instanceof COSInteger) {
            result = Long.toString(((COSInteger)nodeValue).longValue());
        } else if (nodeValue instanceof COSString) {
            String text = ((COSString)nodeValue).getString();
            for (char c : text.toCharArray()) {
                if (!Character.isISOControl(c)) continue;
                text = "<" + ((COSString)nodeValue).toHexString() + ">";
                break;
            }
            result = text;
        } else if (nodeValue instanceof COSName) {
            result = ((COSName)nodeValue).getName();
        } else if (nodeValue instanceof COSNull || nodeValue == null) {
            result = "";
        } else if (nodeValue instanceof COSDictionary) {
            COSDictionary dict = (COSDictionary)nodeValue;
            result = COSName.XREF.equals((Object)dict.getCOSName(COSName.TYPE)) ? "" : "(" + dict.size() + ")";
        } else if (nodeValue instanceof COSArray) {
            COSArray array = (COSArray)nodeValue;
            result = "(" + array.size() + ")";
        } else if (nodeValue instanceof DocumentEntry) {
            result = nodeValue.toString();
        }
        return result;
    }

    private String toTreePostfix(Object nodeValue) {
        if (nodeValue instanceof COSDictionary) {
            int st;
            int pt;
            COSName subtype;
            COSName type;
            String name;
            StringBuilder sb = new StringBuilder();
            COSDictionary dict = (COSDictionary)nodeValue;
            if ((COSName.ANNOT.equals((Object)dict.getCOSName(COSName.TYPE)) && COSName.WIDGET.equals((Object)dict.getCOSName(COSName.SUBTYPE)) || dict.containsKey(COSName.T) && dict.containsKey(COSName.KIDS)) && (name = dict.getString(COSName.T)) != null) {
                sb.append("   Name: ");
                sb.append(name);
                sb.append(' ');
            }
            if (dict.containsKey(COSName.TYPE) && (type = dict.getCOSName(COSName.TYPE)) != null) {
                sb.append("   /T:").append(type.getName());
            }
            if (dict.containsKey(COSName.SUBTYPE) && (subtype = dict.getCOSName(COSName.SUBTYPE)) != null) {
                sb.append(" /S:").append(subtype.getName());
            }
            if (dict.containsKey(COSName.S) && (subtype = dict.getCOSName(COSName.S)) != null) {
                sb.append(" /S:").append(subtype.getName());
            }
            if (dict.containsKey(COSName.PATTERN_TYPE) && (pt = dict.getInt(COSName.PATTERN_TYPE)) > -1) {
                sb.append(" /PatternType:").append(pt);
            }
            if (dict.containsKey(COSName.SHADING_TYPE) && (st = dict.getInt(COSName.SHADING_TYPE)) > -1) {
                sb.append(" /ShadingType:").append(st);
            }
            return sb.toString();
        }
        return "";
    }

    private ImageIcon lookupIconWithOverlay(Object nodeValue) {
        Object entry;
        ImageIcon icon = this.lookupIcon(nodeValue);
        boolean isIndirect = false;
        boolean isStream = false;
        if (nodeValue instanceof MapEntry) {
            entry = (MapEntry)nodeValue;
            if (((MapEntry)entry).getItem() instanceof COSObject) {
                isIndirect = true;
                isStream = ((MapEntry)entry).getValue() instanceof COSStream;
            }
        } else if (nodeValue instanceof ArrayEntry && ((ArrayEntry)(entry = (ArrayEntry)nodeValue)).getItem() instanceof COSObject) {
            isIndirect = true;
            isStream = ((ArrayEntry)entry).getValue() instanceof COSStream;
        }
        if (isIndirect && !isStream) {
            OverlayIcon overlay = new OverlayIcon(icon);
            overlay.add(ICON_INDIRECT);
            return overlay;
        }
        return icon;
    }

    private ImageIcon lookupIcon(Object nodeValue) {
        if (nodeValue instanceof MapEntry) {
            MapEntry entry = (MapEntry)nodeValue;
            return this.lookupIcon(entry.getValue());
        }
        if (nodeValue instanceof ArrayEntry) {
            ArrayEntry entry = (ArrayEntry)nodeValue;
            return this.lookupIcon(entry.getValue());
        }
        if (nodeValue instanceof COSBoolean) {
            return ICON_BOOLEAN;
        }
        if (nodeValue instanceof COSFloat) {
            return ICON_REAL;
        }
        if (nodeValue instanceof COSInteger) {
            return ICON_INTEGER;
        }
        if (nodeValue instanceof COSString) {
            String text = ((COSString)nodeValue).getString();
            for (char c : text.toCharArray()) {
                if (!Character.isISOControl(c)) continue;
                return ICON_HEX;
            }
            return ICON_STRING;
        }
        if (nodeValue instanceof COSName) {
            return ICON_NAME;
        }
        if (nodeValue instanceof COSNull || nodeValue == null) {
            return ICON_NULL;
        }
        if (nodeValue instanceof COSStream) {
            return ICON_STREAM_DICT;
        }
        if (nodeValue instanceof COSDictionary) {
            return ICON_DICT;
        }
        if (nodeValue instanceof COSArray) {
            return ICON_ARRAY;
        }
        if (nodeValue instanceof DocumentEntry) {
            return ICON_PDF;
        }
        if (nodeValue instanceof PageEntry) {
            return ICON_PAGE;
        }
        return null;
    }

    private static class OverlayIcon
    extends ImageIcon {
        private final ImageIcon base;
        private final List<ImageIcon> overlays;

        OverlayIcon(ImageIcon base) {
            super(base.getImage());
            this.base = base;
            this.overlays = new ArrayList<ImageIcon>();
        }

        void add(ImageIcon overlay) {
            this.overlays.add(overlay);
        }

        @Override
        public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
            this.base.paintIcon(c, g, x, y);
            for (ImageIcon icon : this.overlays) {
                icon.paintIcon(c, g, x, y);
            }
        }
    }
}

