/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font.util;

import java.awt.Image;
import java.io.IOException;
import java.util.List;
import org.apache.fontbox.util.BoundingBox;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDInlinedImage;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.content.ContentStreamEngine;
import org.apache.pdfbox.util.ImageParameters;
import org.apache.pdfbox.util.PDFOperator;

public class PDFAType3StreamParser
extends ContentStreamEngine {
    private boolean firstOperator = true;
    private float width = 0.0f;
    private PDInlinedImage image = null;
    private BoundingBox box = null;

    public PDFAType3StreamParser(PreflightContext context, PDPage page) {
        super(context, page);
    }

    public Image createImage(COSStream type3Stream) throws IOException {
        this.resetEngine();
        this.processSubStream(null, null, type3Stream);
        return this.image.createImage();
    }

    protected void processOperator(PDFOperator operator, List arguments) throws IOException {
        super.processOperator(operator, (List<COSBase>)arguments);
        String operation = operator.getOperation();
        if (operation.equals("BI")) {
            ImageParameters params = operator.getImageParameters();
            this.image = new PDInlinedImage();
            this.image.setImageParameters(params);
            this.image.setImageData(operator.getImageData());
            this.validImageFilter(operator);
            this.validImageColorSpace(operator);
        }
        if (operation.equals("d0")) {
            this.checkType3FirstOperator(arguments);
        } else if (operation.equals("d1")) {
            COSNumber llx = (COSNumber)arguments.get(2);
            COSNumber lly = (COSNumber)arguments.get(3);
            COSNumber urx = (COSNumber)arguments.get(4);
            COSNumber ury = (COSNumber)arguments.get(5);
            this.box = new BoundingBox();
            this.box.setLowerLeftX(llx.floatValue());
            this.box.setLowerLeftY(lly.floatValue());
            this.box.setUpperRightX(urx.floatValue());
            this.box.setUpperRightY(ury.floatValue());
            this.checkType3FirstOperator(arguments);
        }
        this.checkColorOperators(operation);
        this.validRenderingIntent(operator, arguments);
        this.checkSetColorSpaceOperators(operator, arguments);
        this.validNumberOfGraphicStates(operator);
        this.firstOperator = false;
    }

    private void checkType3FirstOperator(List arguments) throws IOException {
        if (!this.firstOperator) {
            throw new IOException("Type3 CharProc : First operator must be d0 or d1");
        }
        Object obj = arguments.get(0);
        if (obj instanceof Number) {
            this.width = ((Number)obj).intValue();
        } else if (obj instanceof COSInteger) {
            this.width = ((COSInteger)obj).floatValue();
        } else if (obj instanceof COSFloat) {
            this.width = ((COSFloat)obj).floatValue();
        } else {
            throw new IOException("Unexpected argument type. Expected : COSInteger or Number / Received : " + obj.getClass().getName());
        }
    }

    public float getWidth() {
        return this.width;
    }
}

