/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.paimon.data;

import org.apache.paimon.memory.MemorySegment;

import java.util.ArrayList;

/** A {@link Segments} with limit in last segment. */
public class MultiSegments implements Segments {

    private final ArrayList<MemorySegment> segments;

    private final int limitInLastSegment;
    private final int pageSize;
    private final long totalMemorySize;

    public MultiSegments(ArrayList<MemorySegment> segments, int limitInLastSegment) {
        this.segments = segments;
        this.limitInLastSegment = limitInLastSegment;
        this.pageSize = segments.isEmpty() ? 0 : segments.get(0).size();
        this.totalMemorySize = ((long) segments.size()) * pageSize;
    }

    public int pageSize() {
        return pageSize;
    }

    public ArrayList<MemorySegment> segments() {
        return segments;
    }

    public int limitInLastSegment() {
        return limitInLastSegment;
    }

    @Override
    public long totalMemorySize() {
        return totalMemorySize;
    }
}
