/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with this
 * work for additional information regarding copyright ownership.  The ASF
 * licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package org.apache.hadoop.ozone.admin.om;

import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalizer;
import picocli.CommandLine;

import java.util.UUID;
import java.util.concurrent.Callable;

/**
 * Handler of ozone admin om finalizationstatus command.
 */
@CommandLine.Command(
    name = "finalizationstatus",
    description = "Get the finalization status of om cluster.",
    mixinStandardHelpOptions = true,
    versionProvider = HddsVersionProvider.class
)
public class FinalizationStatusSubCommand implements Callable<Void> {

  @CommandLine.ParentCommand
  private OMAdmin parent;

  @CommandLine.Option(
      names = {"-id", "--service-id"},
      description = "Ozone Manager Service ID"
  )
  private String omServiceId;

  @CommandLine.Option(
      names = {"-host", "--service-host"},
      description = "Ozone Manager Host"
  )
  private String omHost;

  @Override
  public Void call() throws Exception {
    OzoneManagerProtocol client =
        parent.createOmClient(omServiceId, omHost, false);
    String upgradeClientID = "Upgrade-Client-" + UUID.randomUUID().toString();
    UpgradeFinalizer.StatusAndMessages progress =
        client.queryUpgradeFinalizationProgress(upgradeClientID, false, true);
    System.out.println(progress.status());
    return null;
  }
}
