// Code generated by go-bindata.
// sources:
// wski18n/resources/de_DE.all.json
// wski18n/resources/en_US.all.json
// wski18n/resources/es_ES.all.json
// wski18n/resources/fr_FR.all.json
// wski18n/resources/it_IT.all.json
// wski18n/resources/ja_JA.all.json
// wski18n/resources/ko_KR.all.json
// wski18n/resources/pt_BR.all.json
// wski18n/resources/zh_Hans.all.json
// wski18n/resources/zh_Hant.all.json
// DO NOT EDIT!

package wski18n

import (
	"bytes"
	"compress/gzip"
	"fmt"
	"io"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)

func bindataRead(data []byte, name string) ([]byte, error) {
	gz, err := gzip.NewReader(bytes.NewBuffer(data))
	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}

	var buf bytes.Buffer
	_, err = io.Copy(&buf, gz)
	clErr := gz.Close()

	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}
	if clErr != nil {
		return nil, err
	}

	return buf.Bytes(), nil
}

type asset struct {
	bytes []byte
	info  os.FileInfo
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

func (fi bindataFileInfo) Name() string {
	return fi.name
}
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}
func (fi bindataFileInfo) IsDir() bool {
	return false
}
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _wski18nResourcesDe_deAllJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x01\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00")

func wski18nResourcesDe_deAllJsonBytes() ([]byte, error) {
	return bindataRead(
		_wski18nResourcesDe_deAllJson,
		"wski18n/resources/de_DE.all.json",
	)
}

func wski18nResourcesDe_deAllJson() (*asset, error) {
	bytes, err := wski18nResourcesDe_deAllJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "wski18n/resources/de_DE.all.json", size: 0, mode: os.FileMode(420), modTime: time.Unix(1515697090, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _wski18nResourcesEn_usAllJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xcc\x7c\x7b\x8f\x1b\x37\x92\xf8\xff\xf9\x14\x85\x60\x01\x27\x80\x46\xf6\x2e\x7e\xf8\x61\x31\x77\x3e\x60\xd6\x1e\x27\xb3\xb1\x33\xbe\x79\x24\xc8\xd9\x83\x36\xd5\x5d\x92\xb8\xd3\x4d\xf6\x92\x6c\xc9\xca\x40\xdf\xfd\x50\x45\xb2\xbb\xa5\x51\x3f\x34\x76\x70\xf1\x3f\xd6\x88\x64\xbd\x58\x2c\xd6\x8b\xfa\xf0\x0d\xc0\xc3\x37\x00\x00\xdf\xca\xec\xdb\x53\xf8\xb6\xb0\x8b\xa4\x34\x38\x97\x9f\x13\x34\x46\x9b\x6f\x27\x7e\xd4\x19\xa1\x6c\x2e\x9c\xd4\x8a\xa6\x9d\xf3\xd8\x37\x00\xdb\x49\x0f\x04\xa9\xe6\xba\x03\xc0\x05\x0d\x0d\xad\xb7\x55\x9a\xa2\xb5\x1d\x20\xae\xc3\xe8\x10\x94\xb5\x30\x4a\xaa\x45\x07\x94\x5f\xc3\x68\x27\x94\xb4\xc8\x92\x0c\x6d\x9a\xe4\x5a\x2d\x12\x83\xa5\x36\xae\x03\xd6\x15\x0f\x5a\xd0\x0a\x32\x2c\x73\xbd\xc1\x0c\x50\x39\xe9\x24\x5a\xf8\x4e\x4e\x71\x3a\x81\xf7\x22\xbd\x17\x0b\xb4\x13\x38\x4b\x69\x9d\x9d\xc0\x8d\x91\x8b\x05\x1a\x3b\x81\xab\x2a\xa7\x11\x74\xe9\xf4\x7b\x10\x16\xd6\x98\xe7\xf4\xbf\xc1\x14\x95\xe3\x15\x2b\xc6\x66\x41\x2a\x70\x4b\x04\x5b\x62\x2a\xe7\x12\x33\x50\xa2\x40\x5b\x8a\x14\xa7\xa3\x79\xd1\xba\x8b\x93\x9b\x25\xc2\x65\x89\xea\xd7\xa5\xb4\xf7\xf0\x9a\x99\x29\x88\x84\x1b\xad\xf3\x8f\xea\xa3\xba\xd1\x30\xc3\x85\x54\xb0\xd6\xe6\x5e\xaa\x05\xac\xa5\x5b\xc2\xda\xde\x7b\xc6\x27\x60\x2a\x4f\xe0\xb3\xfa\xbb\x67\x90\xea\xa2\x10\x2a\x3b\x25\x00\x1f\xdd\x5f\x9a\xe9\x0c\x71\x29\x2d\xac\x65\x9e\x07\xd9\xb5\xf0\x0b\x6b\xd1\xd9\x16\xaf\x52\x41\x21\x94\x9c\xa3\x75\xd3\x8d\x28\x72\xd0\xa6\xf5\x45\x91\x7f\x54\x17\x73\x48\x2b\x63\x88\xe4\x4c\x1a\x4c\x9d\x36\x1b\xc8\x34\x5a\xe5\x60\x29\x56\x08\x42\x6d\xea\x25\x30\x97\x39\x4e\x1a\x72\xa0\x34\x52\x39\x0b\x8e\x48\x5a\x62\x5e\x42\x81\xd6\x8a\x05\x4e\x3d\xa1\x08\x85\xb6\x8e\xd9\xd1\x0a\xd6\x62\x63\x41\xcf\xa1\xb2\x2c\x87\x1a\x88\xd3\x91\x13\xa1\xb2\xe7\xda\x40\xa5\xba\x38\x13\x06\x59\x28\x3b\x22\x69\xfd\x01\x27\x05\x94\xc2\x2d\x9f\x3b\xfd\x7c\x87\xf1\x71\xb3\xe0\x24\xab\x07\xb2\x7a\x2f\x0f\x00\x88\x14\x1e\xfe\x76\x24\x15\x83\xd3\x7b\xc9\xf9\xa8\xce\x2a\xe5\x96\x74\x6c\x52\x56\xc7\xd3\x8f\xaa\x81\x6d\x50\x64\x16\x52\x83\x19\x4d\x10\xb9\x85\xb9\xd1\x05\xfc\xe5\xc7\xcb\x77\xe7\xcf\xa7\x6b\x7b\x5f\x1a\x5d\x5a\x98\x6d\x20\xc3\xb9\xa8\x72\xf7\x51\x5d\xae\xd0\xac\x8d\x74\x18\xbf\x82\x54\xab\xb9\x5c\xf0\xa6\xd3\x51\x7d\xf5\xf6\xe2\xf4\xa3\x02\xd8\x91\xe4\x49\x98\xf4\x9f\xad\xc9\xff\xd5\x23\x80\x4b\x13\xd4\x73\x03\x22\xcf\xc1\x2d\x0d\xf6\x00\x17\xa5\x5c\x92\x06\xfd\x78\x79\x7d\x43\x7f\x56\x6e\x09\x3f\x9d\xff\x06\x27\x27\xf5\x29\x86\x9f\xcf\xde\x9d\x5f\xbf\x3f\x7b\x75\xde\x89\x75\xc4\x39\xb7\x4b\x6d\x5c\xbf\xd1\x7a\x6f\xf4\x4a\x66\x68\x41\x80\xad\x8a\x42\x18\x92\x32\xcd\x27\x9d\x7e\xa4\xa9\x33\x24\x25\x8f\xd6\xed\x79\xdc\x6b\xcc\x60\x26\x2c\x66\xc4\x72\xa4\xb1\xb5\xb7\xf0\xdb\xd9\xbb\xb7\x63\xec\x52\xa0\xb7\xdb\x30\x9d\x81\xd3\x3a\x07\x8b\x8e\xce\x17\x9f\xcd\x20\xd5\x8d\xae\x0c\xe8\x12\xd5\x9a\xe9\x2d\x83\x9d\x0d\xc7\x52\xec\x1e\xf6\xf1\xb4\xac\xd0\x58\xc2\xdd\x25\x3c\xa9\x1c\xdb\xb9\x30\x0f\x54\x55\xcc\xd0\x90\xec\xea\x0d\x1f\x8d\xcb\x6e\x54\xda\xcf\xb7\xd3\x40\x93\x3c\xb3\xcd\xe6\xd4\xcc\xce\xd0\xad\x11\x15\xa4\xb9\x24\xb1\x0b\x95\x81\x45\xb3\x42\x33\xfa\x52\x18\x4f\x43\x6b\x7b\x09\x4f\x54\x05\xfe\x62\x47\x75\xba\xb7\x82\xd6\xe9\x92\xe0\x8b\xbc\x0d\x8f\xb6\x28\x4e\x67\xd5\x21\xbb\xf0\x5a\xce\xe7\xc8\x16\x3d\x5a\x5c\x53\x29\xba\xbb\x99\x9c\xd3\x5d\x23\x44\x5f\x3d\xfe\x66\xa4\x05\xeb\x9d\xda\xb6\x5e\x4f\x87\x71\x52\x1a\xfd\x2f\x4c\x1d\x9d\x77\x78\x7f\x75\xf9\xcf\xf3\x57\x37\xa3\xf5\x24\x8a\xba\x63\x9f\x6e\x3b\xef\x19\x36\x96\x5e\x21\xc6\xea\xc3\x58\x5c\x06\x0b\xbd\x42\xfb\x18\xe7\x7a\x29\xd3\x25\xac\xd1\x60\xe3\x14\x31\x1d\x74\x6a\x76\x34\x61\xdf\x5e\xec\xf8\x19\x19\xe6\xe8\x68\xb3\x0f\x33\xb5\x03\xcc\x5f\xe7\xa6\x52\xa7\x7f\xba\xeb\xed\x30\xa4\x43\xda\x00\xdf\x69\x95\x6f\xd8\xbf\xb2\x30\xd7\xa6\x25\x1e\xf6\xfe\x58\xc1\x0a\x9d\xe1\xf7\xa3\xf5\x06\x3f\xf7\xdc\x03\xe7\x3c\x08\x81\x92\x1d\xe1\xd6\x22\x1f\xab\x34\x23\x10\x59\xda\x2e\xb1\xc0\xac\x1f\x23\x59\x9b\x1d\x25\x99\x57\x8a\xfd\x66\x6f\x23\x3a\xfc\x31\x5a\x45\x0e\xa8\xa7\x63\x4f\x0b\xfc\x97\x1d\x42\x6f\x6d\xaa\x9f\x87\xd9\xc9\x11\x97\xee\x3c\x17\x8b\x44\x94\x32\xa1\xeb\xbd\x83\x7f\x7f\x3f\x9d\xbd\xbf\x80\x4f\x74\xff\x7f\x1a\x09\xb1\xff\x22\x6a\x01\xfd\xe5\xfc\xea\xfa\xe2\xf2\xe7\x51\x70\x2b\xb7\x4c\xee\xb1\xeb\x70\xd3\xb0\x36\xf2\x77\xfe\x02\x3e\xfd\x74\xfe\xdb\x18\xa0\x29\x1a\x97\xd0\xee\x74\x40\x25\xf9\x92\xf5\xa6\x23\x3b\xa5\xc9\xbc\x95\x63\x00\xb3\x2b\xd6\x01\xb5\xed\xd4\x7d\x17\x3d\x3d\x69\xf7\x5d\xc3\x81\xc3\xe2\xa5\x92\xe7\x7a\x9d\x04\x18\x5d\xd1\x27\x4f\x82\x7a\xd2\x30\xd4\xe6\xf8\xf6\xc9\xa5\x0e\x1a\xea\x7b\x70\x04\xe8\xd2\xe0\x4a\xe2\xba\x03\xae\x5d\x32\xa1\x11\xe8\xf3\x9d\x8b\xba\xcc\x85\x1a\x81\xe1\x1e\x37\xa3\xb7\xf4\x1e\x37\x63\x09\xf7\x92\x0e\x86\xa0\x57\xd0\xd1\x48\xd4\xe1\xb4\xa3\x8b\x01\x0a\x61\xee\x31\x8b\xa6\x64\x94\xa8\x18\x4e\x42\x87\xbe\x8b\x99\x80\x8a\xa7\x0c\x43\x8c\xd6\x61\x60\x57\x77\x2e\xa7\x11\x60\xeb\x40\xa0\x03\x6e\x33\x3e\x9a\xe9\x01\x0a\xbd\x5f\x90\xa3\xb5\x51\xda\x23\x40\x5b\x67\x64\x27\x64\xbf\x75\x95\x45\xba\xbc\xe6\x52\x61\x46\x56\xd9\xc9\xa2\x76\x97\x47\x60\x70\xa6\x5b\x08\x3c\x06\xba\x72\x65\x35\x86\x58\xaf\x6e\x2b\x34\x33\x6d\xbb\x40\x86\xd1\x63\x81\x96\xc2\x88\xa2\x53\xc0\x46\x14\xe8\xd0\xc0\x4a\xe4\x15\xf2\xed\x4d\xc6\x14\x7e\x39\x7b\x7b\x7b\xfe\x89\x2e\xf7\x42\x1c\x89\xaa\xef\x34\x7e\x7a\x73\xf1\xf6\xfc\x13\x85\xb9\x4e\x48\x76\x90\x0f\x51\xf0\xcf\xeb\xcb\x9f\x87\x51\xb3\x55\x4d\x0a\x69\xc9\x17\xe7\xfb\xa2\xfb\xba\xa0\x8b\x98\x66\x34\xb1\x3b\x90\x2d\x90\x16\x94\x8e\x51\x77\x65\x30\x9b\x7e\xec\xdb\xf7\x3d\x8c\x3e\x52\xee\xc1\x48\x77\x1e\x07\xd3\x5f\x84\x67\xe8\xb8\x11\xa6\x26\x36\x7f\x12\xaa\xc0\x4a\x5f\x56\x74\x9f\x9f\x0f\x0f\x0f\x53\xfa\xbc\xdd\xde\x4d\xbc\x63\xf4\xf0\x30\xb5\xba\x32\x29\x6e\xb7\xa3\x70\xfa\x0d\x1b\xc2\xc9\x09\x88\xb0\x57\x16\xdd\xd3\x70\xd5\xe2\x19\xc2\xb6\x23\x47\x62\xb1\xfe\xe2\xe9\x7c\x96\x72\xb1\x4e\x1c\x2a\xa1\x5c\x22\xb3\x31\x32\xfe\x41\x38\x24\x57\xf1\x86\x17\xc1\xc5\xeb\x48\x4d\x55\xc9\xec\x0b\x09\x11\x9c\x99\x4e\x9c\xbe\x47\x75\x0c\x2d\x7e\x1d\xf0\xba\xa7\xed\x45\xa5\x0a\x61\xec\x52\xe4\x49\xae\x53\x91\x77\x46\x6d\x61\x56\xcb\xd1\x0e\x96\x39\x38\xe0\xbc\x3a\x58\x8b\x91\x08\x15\x3a\x0a\x56\x9e\x8c\x52\x2a\x87\x46\xa1\x03\xe1\x88\xdd\xca\xe4\x03\xbc\x36\x6e\x4c\x92\x0a\x95\x62\x9e\x77\x3a\x11\x97\x3f\x4d\xe1\x95\x9f\xd3\xe4\xaf\x38\x2c\x1b\x89\x60\x2e\x64\x37\xf4\x56\x7e\x3c\x93\x59\x30\x0d\x45\x99\xa3\x43\xb0\x15\x6d\xe9\xbc\xca\xf3\xcd\x14\xae\x2a\x05\x9f\x1e\x07\x80\x9f\x38\x5e\xe1\x00\x9a\x4c\xb5\x93\x22\xcf\x37\x4d\xb4\xec\x03\xa3\xb1\x94\xfa\xe4\x5d\x62\x9d\x70\x55\x97\xf3\x7a\x72\x72\x72\xf2\xf2\xe5\xcb\x97\x87\x73\xfc\xd7\xbc\x14\x68\x02\x4d\x1c\x85\x95\x4b\x35\x98\x8d\x11\x51\x14\x4d\x06\xa1\xbe\xe3\x85\xd3\xaf\x64\x4f\xdf\xeb\xf6\xda\xf1\x48\x7a\xf7\xfb\xb6\xed\x41\xf7\xee\xf8\x68\x7c\x43\xf2\xdb\x41\xf9\x04\x09\x86\xd2\x4b\xc2\x39\x35\x76\x1e\xc8\xe8\x26\xc2\x25\xe4\xfe\x75\x20\x7d\x78\x98\xa6\x45\xb6\xdd\x86\x4c\xdc\xc3\xc3\x94\x16\xba\x4d\x89\xdb\x2d\x9b\x4a\x5a\xbb\xdd\xde\x4d\xa7\xbd\xb8\xd9\x67\xdf\x24\x51\x9f\x07\xca\x7a\x0f\x0f\x14\x41\x04\x04\x44\xe4\x76\x7b\x07\x4b\x61\x61\x86\xa8\x76\x18\xae\x4f\xc8\x78\xec\xdd\x75\xc0\xd7\x71\x1c\x0e\x12\x30\x9d\xf6\x64\x50\x03\x8a\x26\x19\xfe\xf5\x58\x6c\x60\x8e\x61\x32\xce\xee\x66\xf3\xb6\x99\x71\x90\xd1\x5e\x3e\x33\x2c\x51\x65\xa8\xd2\x63\xc4\xd9\x2c\x7a\x3a\x9e\xe6\x88\x74\xca\xf4\xf5\x41\x34\x5f\xa2\x38\x87\xa9\x20\xc3\x50\x99\x2e\x37\xf1\xf5\x4e\x0a\xfc\x30\xeb\xff\x87\x77\x44\xe4\xe7\x38\x3d\xf9\xb2\x1d\x7c\x6c\xe6\xbe\xce\x1e\x8e\x3c\x19\x5d\x94\xf4\xef\xe3\xed\x5e\x31\xe3\x29\x3b\xd9\x47\x55\x48\x58\x3c\xf5\xce\x61\x8a\xfc\x0d\x50\x27\x44\xfa\x68\x81\xac\x32\xb4\x93\x31\xe5\xda\xba\x11\xff\x38\x7d\x8b\x3c\xce\x75\xa5\xb2\x24\xd0\x1b\x2c\x55\xa7\x02\x84\x24\xff\x41\x0b\x19\x2a\x09\xdc\x0f\x41\x74\xb5\xea\x08\xb1\xd6\xbf\x9f\x53\xe6\x4b\xca\x7f\x26\x08\xc2\x32\x2f\x5c\xad\x1f\xeb\x16\x84\x14\x5f\x12\xaa\x58\x5d\x85\x40\x3f\xca\xb1\x0d\xb4\xd2\x8f\x06\x39\xad\x92\x4d\xb8\x2c\xdc\xb8\x5b\xf5\xb6\x11\x1d\xa6\x5e\x11\x90\x80\x68\x55\x4b\xda\x45\x56\xdf\xcb\x10\xb4\xdf\xf8\x32\xe0\x50\xe3\xc7\xf9\xd5\xd5\xe5\xd5\x75\x07\xdd\x2f\xf7\xff\x81\x9f\x0e\x8f\x06\x5e\xbe\xec\xb9\x7e\x8c\xd9\x3d\x68\xf7\x4a\xaf\x55\x42\x9e\xc2\xf0\x51\xa7\x59\x24\xaa\xb0\x6a\x0a\xad\x5c\x3d\x97\x40\x6c\x55\xfa\x8a\xc1\x73\xce\x72\x4f\xed\xc6\x3a\x2c\x60\x26\x55\x26\xd5\xc2\x82\x36\xb0\x90\x6e\x59\xcd\xa6\xa9\x2e\xea\x6a\x63\xff\x7d\x69\x4c\xbc\x33\x53\x83\xc2\x75\x91\xc9\x7d\x4e\xc0\x53\x76\xd4\x92\xbb\x5d\xb8\x41\x2a\xb6\x86\x9c\xd2\x20\x1a\xb3\xdd\x72\x99\xc2\x8f\xa5\x3a\xf3\x03\xf4\x61\x20\x9a\x69\x91\xe4\xcf\x4a\x2f\x49\xd9\xa3\x93\xf2\x07\x91\x34\x47\xa4\x70\x7a\xa5\xef\xbb\x08\x7a\xc3\x66\x8b\xcc\x85\x9f\xc6\x07\x92\x96\xc1\x7a\x89\xad\xc2\x9d\xf3\x6d\x4e\x61\xe8\x8f\xa1\xf6\x1e\x37\x75\x4a\x87\xfc\x5d\xe1\xb4\xe9\x4b\x57\xd5\x73\x38\xfb\xf1\x21\x0a\xf3\x8e\xf4\x31\xc0\x19\xc4\x19\x33\xbb\x89\xd2\xce\x1b\xbb\x0e\x84\xef\xda\x29\x60\xb6\xd5\x3c\x9b\xe2\x5d\xce\xc1\xb6\x3d\xea\x21\xa4\xec\xbd\x17\xd2\x16\xc2\xa5\x5d\xee\x3b\x31\x58\xab\x07\x2d\xc8\x18\x45\x16\xed\xa9\x54\xfb\xb5\x06\x3f\x1e\x68\xe0\x76\x29\x26\x93\x91\xf0\xb6\xb2\x79\xa3\x49\x45\x0b\xc8\x4e\x6a\xdb\x8f\x46\x36\xfa\x99\x08\xf1\x3f\xa9\x97\xc8\x65\x97\xd8\x2e\xfc\x28\xf7\x78\xf9\x2d\xa9\xb3\xc8\x84\x2b\x7c\x26\x5a\x0e\x36\x88\x71\xed\x94\x68\x17\xbe\x6e\x48\x6b\xfc\xc7\x31\x72\x8e\x24\x0e\x88\xfa\xea\x18\x82\xf6\xe4\xca\x47\xc1\x53\xf4\xcc\x82\xcf\xf2\x78\x51\xe2\x67\x87\xca\x46\xa2\xf1\x33\xdf\x61\xc4\xce\x97\xb0\x62\x93\x05\x76\xe5\x53\x9b\xa3\xbc\x40\xdf\xd6\x12\x6c\x6f\x93\xb9\x7f\x54\xa0\xa5\xfb\x4d\xa6\xad\xe3\x3b\x5a\xa6\x9e\xf4\xc4\x73\xcc\xa7\xa7\xc6\xd6\x41\xdf\x0e\xc3\xec\x17\x92\x18\x1b\x29\x0b\xb5\xa9\x75\x83\x8c\x48\x6b\xdb\x07\xe5\x1a\x72\xba\x35\x09\x83\x6c\x54\x26\x3f\x5e\x73\x7d\x62\x2b\x84\xd0\xb7\x57\x6f\x7d\xc6\xd1\xe4\xe1\x28\x7d\xd8\x89\xb1\xef\x7c\xaf\xd2\x18\x42\x0a\x91\xcf\xb5\x29\x3a\x25\xf7\x2e\x8e\xf7\x51\x30\x85\x1b\xb3\x01\xb1\x10\x52\x0d\x85\xf4\xc6\x24\xff\xb2\x5a\xd5\xc6\x36\x2d\xb2\x9e\x42\x32\xd7\x1a\xa4\x2a\x2b\x07\x99\x70\x02\xde\x05\x69\x3c\x4b\x8b\xec\x19\x99\xde\x7e\x4c\xa2\x94\x4d\x41\xc0\x2b\x8d\x36\x89\xc5\x7f\x57\xa8\x3a\x33\xf6\xbe\xbd\xf6\xf9\x75\x98\xb5\x7b\x58\x5a\xf6\xdd\xeb\xf3\x5e\xef\xc8\xd9\xfb\x0b\xbf\xa0\x94\x34\x3b\x15\xca\xbb\x22\x33\xf4\xce\x40\xbb\xdf\xad\x51\xb2\xe7\x91\xa4\x03\x30\xa7\xf0\x3e\x47\x61\x11\xaa\x32\x13\x6e\xaf\x59\xc5\x5f\x9e\x69\x5e\x65\xfb\x74\x0a\x0b\x02\xd6\x38\xdb\xc7\x30\xb8\x3b\x41\x4e\xfd\x0a\x7a\x76\xc0\x8e\x90\x68\xc2\xaa\x29\x5c\x38\x1f\x7d\x69\xb7\xe4\xbb\x78\xb7\x05\xa3\x3e\x78\x13\x2f\x1d\xad\x30\x54\x81\x0b\x82\x82\x9f\x4b\x4c\xc7\x9c\xa4\x40\x6b\xdc\xe2\x68\x1f\xc8\x30\x26\x84\xf5\x0b\xa9\x67\xc2\x1b\x23\x41\x60\x75\xe5\xda\xc6\x62\x0a\xbf\x36\x46\x38\x9a\x0a\x5a\x36\xa9\xcd\x89\xb4\x8d\xb3\x30\x70\xad\x05\x76\xa2\x98\x12\x8a\x56\x1c\x26\x99\x34\xa3\x8c\xdc\x41\xb6\x88\x8f\x5a\xee\xa5\x96\xca\xbb\x54\x3e\x44\x73\xd8\x6a\x72\x6e\x8e\xf3\x84\x42\xc0\xc8\x15\x37\x19\xef\x59\xb8\x7e\x36\x52\x41\x01\xbb\x58\x61\x92\xe9\xf4\x1e\xbb\x9e\x02\xbc\x12\x8a\xa1\x8a\x15\xc2\x6b\x9e\x08\xb2\x60\x07\x7c\xc0\xb1\x94\x39\x26\x22\x37\x28\xb2\x4d\x82\x9f\xa5\xed\x6c\xb5\x78\x43\x27\x24\xcc\x04\x3f\x73\x00\x76\x16\x5b\x05\x9b\xa8\x44\xa2\xf5\x0a\x65\xc9\x73\xca\xc5\x0c\xbb\x8a\x23\x97\x0a\x81\xf4\x30\xc7\xfd\xb0\xbf\xf9\x33\x6e\x89\x5b\x6b\xa8\x91\x71\xd1\xc4\xcb\x9a\x66\xc7\xbf\xbc\x61\x5d\x4a\x0b\xf7\x52\x65\x74\x40\x82\x2e\x86\x1a\xe9\xa3\x8b\x67\xcf\x52\x90\x7d\x69\x11\xc2\xa4\x1f\x20\x27\x3c\x08\x78\x64\x57\x58\x59\xb8\xbe\x4f\xbe\x5b\x24\x0a\x62\x58\x83\xcc\x83\xc5\x52\x18\xfa\x83\xa1\xfb\x7e\xb3\x0e\xde\xc6\x29\x7f\x38\x64\x09\xb1\x7c\xac\x9e\x2b\xed\x25\x65\xd1\x1d\x87\xec\x58\x5b\x11\x90\xb5\xce\xfb\x00\xbe\x68\x7d\x93\xa5\x58\x91\xa5\x62\x5d\xf2\x89\x74\x1b\x88\xe9\x7a\xac\xd2\xbe\x86\x22\x98\x60\xaf\xa2\x6a\xc7\x1e\x09\xb2\xf9\x2a\x1a\x23\x1f\xe8\xb3\x2b\x46\xfb\x17\xa2\xdb\x69\x7c\x3d\x12\x5a\x7c\x3d\x3c\xcb\x17\x15\x29\x13\x3f\x71\xe0\x05\xec\xb1\x4b\x05\x22\xea\x74\x84\x30\x70\xf8\xb5\x9a\xe7\x32\x25\x2b\x93\x84\xc0\x8d\x38\x34\xda\xda\x98\x09\xe9\x3a\xae\xad\xf3\x13\x43\x3e\x62\x3a\x7c\x0e\x3c\x47\x5e\xd9\xf9\x2d\xaa\xdc\xc9\x32\xf7\x51\xa3\x3f\x3c\xf4\x29\x78\x24\x1e\x39\x9b\xaf\x78\xf7\xee\xa5\x41\x5c\xbb\xa8\x3c\x01\xe9\xfc\x89\x2a\xb5\xb5\x72\xe6\x4f\x01\x0b\x24\x32\xe2\xb1\x36\xe2\x99\x91\x5f\x52\x6b\x3a\x13\xf1\xe8\x10\x06\x4e\x18\xcd\xa3\xa0\xe7\x08\x61\x9a\x2a\xc7\x27\x48\x92\x96\x85\xe8\x22\xc7\x43\x32\x6c\xe8\x8f\xf6\x7e\xcf\x91\xf0\x6f\x50\x6a\x11\xec\x6e\xc9\xd4\x3f\x3d\xfa\x1a\x42\x66\x06\x0f\x49\x58\x58\xab\x53\xc9\xa0\x0f\x53\xfc\x3c\x12\xb7\x2f\x7c\x66\xfe\x49\x92\x17\xa6\x69\xf1\xe0\x62\x76\x67\x6b\x7b\x28\x90\x41\x2e\x15\x82\x30\x8b\x8a\x83\x62\x12\xa1\x59\x6c\xb7\x6d\x7f\x91\xe1\x4c\xa0\xf4\x24\xc6\x57\x1f\x24\x0f\x1e\x39\x82\xa2\x7b\xdc\x7c\x35\xaa\xee\x71\xf3\x9c\x61\x41\x29\xa4\x79\x44\xde\xee\x30\xdb\x77\xfc\x2c\x8a\x92\x9c\xdd\x1a\xdc\x3d\x6e\x46\xf1\x10\x1c\xac\xe1\x4e\xa4\x2e\x06\xbe\x8b\x28\xbf\x67\x1b\x1c\xe0\xf9\x36\x25\x7f\x71\xd5\xa9\x90\x89\x4f\x48\xb6\xc2\xcb\xa8\x1c\xf5\x7b\x1b\xf0\xab\x39\xc8\x68\x40\x0c\xe5\x1e\xf0\xdf\x95\x34\x9c\xdb\x2a\x2b\x67\x47\x69\xc9\x55\x58\xe3\x43\x19\x7f\x5a\x76\xb4\xc2\x02\xae\x50\x81\x98\x3b\x34\x20\xca\x32\xe7\xfa\x09\x37\x36\x94\xda\xc3\x09\xb5\x54\x54\xab\x29\xac\x84\x91\x62\x96\x63\xa3\xf0\x16\x5d\x0d\x71\x77\x4a\x3c\xc0\x3e\x8a\x6a\xda\xb8\x0e\xbd\xb6\xf1\x2f\x9b\x4c\x78\x7f\xc4\x9b\x3d\xd7\x79\xae\xd7\x9e\x1a\xa2\x9d\xe5\xe9\x3f\x6e\xb7\xc3\xd1\xd7\xc2\x37\xa8\x24\x14\xf4\x70\xc5\x78\x28\xb0\x68\x35\xb5\xd0\x9a\x26\xc1\x25\x4a\x49\x5f\xc4\x1c\xd3\x01\x77\x9d\xa7\xd6\x1d\x6b\xf1\x01\xc1\xbe\x97\x14\x42\x0e\x83\x84\x74\x15\x10\xd4\x99\xe2\x3d\x18\x43\x67\xb2\x15\x5f\xae\x71\xd6\x7f\x93\x77\x45\x1d\x44\x5d\x3b\x54\x1b\x15\x44\xc6\x17\x31\xcd\xb2\xe1\x60\x69\x8f\xd8\x81\x30\xb8\xcf\xf1\x68\x48\x8e\x03\x47\x13\x3d\x3a\x1e\x8d\x41\x5d\x29\x8c\x45\xd3\xfb\xb8\xb8\xc9\x42\x19\x74\x46\x22\x5f\x2a\x21\xf9\x54\x5b\x81\x7e\x6c\xcd\x2e\xc6\x83\xee\x7b\xdd\x63\x47\x56\x9f\xee\xde\x2a\x11\xee\x33\x8b\x69\x65\xbc\x03\xde\x6c\xd0\x7f\xc0\x41\x0d\x38\xa3\x28\x48\xd4\x03\x21\x8d\xdc\xb6\x6e\xde\xfc\xd2\x20\x7f\xea\x4e\x8f\xfe\x7a\x76\xf5\xf3\xc5\xcf\x3f\x8c\x2f\xd9\xc4\x05\xc7\x15\x6d\xd6\xc2\xa8\xba\x2f\x84\x24\xdd\x95\xbd\xb9\xa2\x31\xda\xf2\x0f\xb1\x21\xe4\x2e\x98\x38\xde\xc5\x53\x9f\x45\xa3\x5d\xb9\xeb\xd3\x82\x80\x8f\xdb\xe4\x8e\xce\x9b\xb5\xdb\xfb\x5b\x79\x72\xc8\xd0\x0d\xe7\x18\x18\x33\x5d\xb6\x19\x96\x06\x53\x52\xe2\xc4\x60\x99\x8b\xb4\x33\x08\xbf\x59\x7a\x3c\x3a\xcf\xc2\x56\x72\x7b\xa4\x8f\xb1\x76\x1b\x61\xf8\xcd\xb2\xd5\x5a\xd1\x19\x69\x30\xd4\x57\x70\x65\xbd\x0a\x71\x29\x13\xd7\x3b\xe0\xac\x43\x31\x92\xf6\x20\x89\xa7\x14\x33\xec\x52\x57\x79\x46\xe4\x51\x48\x05\xb7\xd6\x57\xf5\x7d\xc9\xf1\x80\x5a\xf6\xe7\xfe\x6a\x8a\x78\xfe\xc0\x56\x12\x5d\x1e\x03\xdd\x42\x8f\x8b\x2c\x64\x82\xbc\xf9\x3f\x02\x25\x67\x51\xc4\xaa\x77\xf3\x86\x90\xf2\xfa\xb8\xa1\xb1\x7c\x1c\x1f\x71\xb6\x5f\x6f\x0e\x13\x96\xcb\x42\xba\x44\x2e\x94\x36\x9d\x24\x45\x95\x0e\x51\x1d\x2f\xf1\x59\x02\xfa\xb4\x5f\x48\xa1\x5b\xd1\x83\x1b\x8b\x3d\x5d\x0a\xb5\x40\x32\x5c\xfd\xd7\xd6\xdb\x1a\x71\x5d\xc0\xb1\x91\xfd\x7c\xe3\x1b\x08\x6a\x50\x53\xb8\x20\x2a\xa4\x5a\x8c\x51\x09\x26\xc4\x26\xb9\x5e\x24\x56\xfe\x3e\x40\x07\x4f\x3e\x85\x5c\x2f\xae\xe5\xef\xa4\xba\x7c\xc3\xe8\xca\x59\x99\xc5\x94\x87\xd7\x4f\x43\xd4\xd0\x8e\x7c\x78\x31\x81\xbf\xbe\xb8\x83\x77\xff\xa8\xdd\xa5\x15\x1a\xf2\x00\xb9\x0c\x5e\xfa\x77\xcc\xa6\x71\x02\xf8\xf9\xbe\xf7\x67\xc7\x12\x5f\x60\xa1\xcd\x66\x3c\xfd\x7e\xfe\x78\x16\xfe\xfa\xb7\xbf\x4f\xe0\x6f\x2f\xfe\xdf\xdf\xff\x58\x36\xe8\xae\xd4\x55\xe7\x1b\xea\x1d\x16\xc2\xdc\x91\xf4\xbf\x78\x31\x81\xff\xff\x82\xfe\xdd\x41\x21\xf3\x5c\x5a\x4c\xb5\x6a\xc5\xcb\x5f\x8f\x17\x2e\xf6\x27\xa5\xd1\x25\x1a\x27\x3b\x83\xe4\x68\xa9\x5b\x76\xd5\xb7\x88\x78\xd7\x21\x34\x89\xf8\xce\x81\x06\x58\x6c\x26\x39\x6c\xbb\xa3\xe9\xce\x34\x9f\x08\xb2\xe0\xd2\xd5\xa2\xd1\x73\xb8\x31\x62\x25\x2d\xcc\x2a\x99\x67\xfd\x9d\x06\xcc\x8a\x37\x5b\x2c\xc6\x51\x26\xab\x3e\x9e\x3b\x86\x4b\xed\x5d\x3c\xc1\xac\x73\xff\x04\x45\xf3\xfe\xdb\xf8\x04\xfc\xe1\x61\x5a\x48\x15\xaa\xe9\xf4\x87\x48\x07\x6a\x73\x4c\x6a\xf4\xd3\xbc\x15\xe8\x32\x67\xb1\xde\x19\x66\x91\xb3\xb4\x57\xfa\x3c\x50\x1e\xe9\xac\x6e\x3e\xa9\xa4\xc9\xd4\x86\x86\x09\x4e\xc1\xf5\xe6\x90\x1f\xd5\xc2\x77\x6c\xe0\x5e\x72\xb9\x89\xc6\x72\x7e\x98\xaa\xb4\x5b\x86\xdc\xcf\x30\x49\x31\xa7\x33\xd8\x0e\x70\xf3\x28\x5b\xdb\x76\x6c\xc2\xeb\x1d\xcc\x40\xe9\x71\x3d\x2d\x8c\xbd\xd5\x4e\xc6\x42\x19\x43\xc4\xc1\x66\xab\x70\x33\xee\x47\x95\xeb\x50\x73\xf5\x9d\x0b\x87\x72\xce\x23\x24\xd4\x7a\x83\x97\xe8\x15\x1a\x23\xb3\x0c\xbb\xe2\x2d\xa2\xb0\xfd\x24\xaf\x69\x07\x6c\x96\x46\x9f\xa6\xdd\xed\x35\x76\xa3\x12\x69\x93\xb2\x9a\xe5\xb2\xeb\x67\x0f\xfc\xae\xf0\xdc\x58\x39\xf4\xaf\x0e\x29\x56\xe5\x85\x8f\xb2\x52\x13\x32\x17\x6c\x5b\x66\x08\x2b\xe9\x13\x64\x74\x0e\x29\x9c\x9a\x61\x78\xe7\x81\x19\xcc\x36\x20\xd4\x46\xab\x9e\x57\x7c\x4c\x6b\x4c\x74\xe3\x2c\xbc\xad\x1e\x70\x37\x1e\xe7\xb9\xb9\x84\xc7\x51\x8c\xca\xe8\xff\x93\xf0\x0c\x7a\xbf\x86\x47\x07\x81\x7f\xc7\x06\x67\x13\xef\x84\x84\xbf\xc2\x82\x9e\xc0\xcb\x53\xfa\x67\x8a\xa5\xe1\x95\x56\x2b\x32\xf8\x21\x78\x69\x90\x38\x3d\x3e\xea\x3e\xc8\xd7\x9f\x24\xec\xde\xe7\xb0\x8d\xaa\xe6\x71\x54\x90\x5e\x73\x19\xb3\x7b\x06\x6d\xa9\x95\xc5\xbe\x36\xbe\x3d\xb2\x39\xaf\xbb\x9f\xbf\x09\xe3\x31\x53\xd3\xca\xfc\xc4\x1c\x5c\x9d\x3b\x5e\x3a\x57\xfa\xdf\xbb\xf2\xa8\xf9\x6e\x9b\xc2\x2b\xba\x65\xb8\xef\xa7\xfd\xbd\xbf\xd8\xf9\xda\x09\x5f\x07\xa6\x19\x0a\xdd\x29\x0d\x65\x43\x5a\x1b\x77\x16\xd5\x4a\x1a\xad\xd8\x7e\xc6\xd4\x5b\x57\x47\x45\x88\x4c\xcf\x9b\x25\xf0\x4b\x58\x32\x26\xca\x7f\x7d\xfe\x8f\xdb\x1f\x46\x87\xf8\x3c\xfb\xb8\xf8\x3e\x9b\x2d\x12\x8b\xc2\xa4\x4b\xe2\x2c\x1a\xdd\xba\x50\xdc\xa9\xb8\x61\x45\x6d\x74\x77\x4b\xcb\x71\xfb\xa2\x7c\xbd\x73\x32\x10\x1f\x10\x29\xfb\x37\xd3\xd7\xbe\x95\x9e\x78\x23\x11\x69\xf5\x95\xed\x5b\x95\x7b\x7e\x7e\xe8\xf5\x81\x7e\xb9\x20\x91\x53\x78\xc3\x14\x34\xbf\x76\xc3\x65\x13\x02\x76\x2c\x01\xfd\xef\xb5\x8f\xa7\xa1\xdd\x0d\x1d\xbb\xf7\x8f\x7b\x83\xbb\xf7\xa6\xb1\xef\x29\x29\x4d\x7e\xf4\x90\xf1\xf8\xd7\xb2\x21\x76\xa8\xdb\xaf\xbf\x3a\x11\x13\x76\xeb\x9f\x3d\x3c\x4c\xb3\xaa\x28\x36\x3c\x6b\xbb\x7d\x46\xe6\xa7\x1d\xfb\x68\xd5\xaf\x3f\xe1\xbd\x78\xf2\xbb\x2c\x13\xfc\xcc\x2d\x3c\xbe\xb5\xa1\xe7\x5d\xd5\x39\xcf\xa3\x33\xf6\x5e\xb8\xe5\x69\x7b\x07\xc7\xa2\x12\x59\x16\x1f\x72\xf5\x61\x3a\xe3\x69\x3b\x07\xd7\x69\xf8\x1f\x59\xc2\x9b\xa1\x83\xd1\xc6\x16\x7a\x93\x62\xab\x5e\x0f\xc2\x37\xa1\xd9\xf2\xda\x3b\xfa\x4f\xe6\xef\x00\xc6\x24\x43\xeb\xa4\x62\x54\x5f\x42\x02\x7b\x40\xaf\x1b\x58\xad\x19\x2d\x0c\x23\x69\x8d\x97\x65\xa4\x17\x55\x77\x1e\x35\x26\x53\xe0\x22\xb4\x7a\x9d\xd3\x64\x52\x38\xe9\x5a\x85\x10\xa6\x24\xc0\xe3\xd2\x6c\x9c\xce\xb0\xd9\x35\x40\xc9\x01\x09\xdf\x99\x1f\x3c\x9f\x77\x40\x06\xd9\x7f\x9e\xb4\xd9\xeb\x3f\xea\x91\x8f\xd8\xe2\xce\xc2\xef\xa9\xe8\xbd\x8a\xad\xf0\x24\xe1\xa8\x47\x47\xef\x70\x2e\xad\x4b\xf4\x9c\x11\xd9\x84\xdb\x60\xf9\x8e\x12\xce\xa1\xe9\x3a\xd8\xde\xb4\x71\x73\x79\x5d\xcc\xf2\x3f\x14\xe6\x9b\x08\x02\x94\xb8\xef\xdc\x35\xf4\xde\xfb\x22\x0c\xb6\x57\x0e\xc1\xc1\xde\xfd\xf9\x82\xae\x43\xb5\xfb\x1b\x07\x74\x13\x76\xb6\x97\x70\xa0\xd2\xf6\x06\x82\x1b\x47\x6c\x5c\x9d\xff\xf7\xed\xc5\xd5\x79\xf2\xeb\x8f\x17\xd7\x3f\x25\x67\xb7\x37\x3f\xb6\xaa\x08\x91\xda\x6f\xee\xbe\xf9\xdf\x00\x00\x00\xff\xff\x40\xdb\x8b\x92\xa5\x55\x00\x00")

func wski18nResourcesEn_usAllJsonBytes() ([]byte, error) {
	return bindataRead(
		_wski18nResourcesEn_usAllJson,
		"wski18n/resources/en_US.all.json",
	)
}

func wski18nResourcesEn_usAllJson() (*asset, error) {
	bytes, err := wski18nResourcesEn_usAllJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "wski18n/resources/en_US.all.json", size: 21925, mode: os.FileMode(420), modTime: time.Unix(1580408211, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _wski18nResourcesEs_esAllJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x01\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00")

func wski18nResourcesEs_esAllJsonBytes() ([]byte, error) {
	return bindataRead(
		_wski18nResourcesEs_esAllJson,
		"wski18n/resources/es_ES.all.json",
	)
}

func wski18nResourcesEs_esAllJson() (*asset, error) {
	bytes, err := wski18nResourcesEs_esAllJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "wski18n/resources/es_ES.all.json", size: 0, mode: os.FileMode(420), modTime: time.Unix(1515697090, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _wski18nResourcesFr_frAllJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x8a\xe6\x52\x50\xa8\xe6\x52\x50\x50\x50\x50\xca\x4c\x51\xb2\x52\x50\x4a\xaa\x2c\x48\x2c\x2e\x56\x48\x4e\x2d\x2a\xc9\x4c\xcb\x4c\x4e\x2c\x49\x55\x48\xce\x48\x4d\xce\xce\xcc\x4b\x57\xd2\x81\x28\x2c\x29\x4a\xcc\x2b\xce\x49\x2c\xc9\xcc\xcf\x03\xe9\x08\xce\xcf\x4d\x55\x40\x12\x53\xc8\xcc\x53\x70\x2b\x4a\xcd\x4b\xce\x50\xe2\x52\x50\xa8\xe5\x8a\xe5\x02\x04\x00\x00\xff\xff\x45\xa4\xe9\x62\x65\x00\x00\x00")

func wski18nResourcesFr_frAllJsonBytes() ([]byte, error) {
	return bindataRead(
		_wski18nResourcesFr_frAllJson,
		"wski18n/resources/fr_FR.all.json",
	)
}

func wski18nResourcesFr_frAllJson() (*asset, error) {
	bytes, err := wski18nResourcesFr_frAllJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "wski18n/resources/fr_FR.all.json", size: 101, mode: os.FileMode(420), modTime: time.Unix(1515697090, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _wski18nResourcesIt_itAllJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x01\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00")

func wski18nResourcesIt_itAllJsonBytes() ([]byte, error) {
	return bindataRead(
		_wski18nResourcesIt_itAllJson,
		"wski18n/resources/it_IT.all.json",
	)
}

func wski18nResourcesIt_itAllJson() (*asset, error) {
	bytes, err := wski18nResourcesIt_itAllJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "wski18n/resources/it_IT.all.json", size: 0, mode: os.FileMode(420), modTime: time.Unix(1515697090, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _wski18nResourcesJa_jaAllJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x01\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00")

func wski18nResourcesJa_jaAllJsonBytes() ([]byte, error) {
	return bindataRead(
		_wski18nResourcesJa_jaAllJson,
		"wski18n/resources/ja_JA.all.json",
	)
}

func wski18nResourcesJa_jaAllJson() (*asset, error) {
	bytes, err := wski18nResourcesJa_jaAllJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "wski18n/resources/ja_JA.all.json", size: 0, mode: os.FileMode(420), modTime: time.Unix(1515697090, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _wski18nResourcesKo_krAllJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x01\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00")

func wski18nResourcesKo_krAllJsonBytes() ([]byte, error) {
	return bindataRead(
		_wski18nResourcesKo_krAllJson,
		"wski18n/resources/ko_KR.all.json",
	)
}

func wski18nResourcesKo_krAllJson() (*asset, error) {
	bytes, err := wski18nResourcesKo_krAllJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "wski18n/resources/ko_KR.all.json", size: 0, mode: os.FileMode(420), modTime: time.Unix(1515697090, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _wski18nResourcesPt_brAllJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x01\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00")

func wski18nResourcesPt_brAllJsonBytes() ([]byte, error) {
	return bindataRead(
		_wski18nResourcesPt_brAllJson,
		"wski18n/resources/pt_BR.all.json",
	)
}

func wski18nResourcesPt_brAllJson() (*asset, error) {
	bytes, err := wski18nResourcesPt_brAllJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "wski18n/resources/pt_BR.all.json", size: 0, mode: os.FileMode(420), modTime: time.Unix(1515697090, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _wski18nResourcesZh_hansAllJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x01\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00")

func wski18nResourcesZh_hansAllJsonBytes() ([]byte, error) {
	return bindataRead(
		_wski18nResourcesZh_hansAllJson,
		"wski18n/resources/zh_Hans.all.json",
	)
}

func wski18nResourcesZh_hansAllJson() (*asset, error) {
	bytes, err := wski18nResourcesZh_hansAllJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "wski18n/resources/zh_Hans.all.json", size: 0, mode: os.FileMode(420), modTime: time.Unix(1515697090, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _wski18nResourcesZh_hantAllJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x01\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00")

func wski18nResourcesZh_hantAllJsonBytes() ([]byte, error) {
	return bindataRead(
		_wski18nResourcesZh_hantAllJson,
		"wski18n/resources/zh_Hant.all.json",
	)
}

func wski18nResourcesZh_hantAllJson() (*asset, error) {
	bytes, err := wski18nResourcesZh_hantAllJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "wski18n/resources/zh_Hant.all.json", size: 0, mode: os.FileMode(420), modTime: time.Unix(1515697090, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"wski18n/resources/de_DE.all.json":   wski18nResourcesDe_deAllJson,
	"wski18n/resources/en_US.all.json":   wski18nResourcesEn_usAllJson,
	"wski18n/resources/es_ES.all.json":   wski18nResourcesEs_esAllJson,
	"wski18n/resources/fr_FR.all.json":   wski18nResourcesFr_frAllJson,
	"wski18n/resources/it_IT.all.json":   wski18nResourcesIt_itAllJson,
	"wski18n/resources/ja_JA.all.json":   wski18nResourcesJa_jaAllJson,
	"wski18n/resources/ko_KR.all.json":   wski18nResourcesKo_krAllJson,
	"wski18n/resources/pt_BR.all.json":   wski18nResourcesPt_brAllJson,
	"wski18n/resources/zh_Hans.all.json": wski18nResourcesZh_hansAllJson,
	"wski18n/resources/zh_Hant.all.json": wski18nResourcesZh_hantAllJson,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"}
// AssetDir("data/img") would return []string{"a.png", "b.png"}
// AssetDir("foo.txt") and AssetDir("notexist") would return an error
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		cannonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(cannonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}

var _bintree = &bintree{nil, map[string]*bintree{
	"wski18n": &bintree{nil, map[string]*bintree{
		"resources": &bintree{nil, map[string]*bintree{
			"de_DE.all.json":   &bintree{wski18nResourcesDe_deAllJson, map[string]*bintree{}},
			"en_US.all.json":   &bintree{wski18nResourcesEn_usAllJson, map[string]*bintree{}},
			"es_ES.all.json":   &bintree{wski18nResourcesEs_esAllJson, map[string]*bintree{}},
			"fr_FR.all.json":   &bintree{wski18nResourcesFr_frAllJson, map[string]*bintree{}},
			"it_IT.all.json":   &bintree{wski18nResourcesIt_itAllJson, map[string]*bintree{}},
			"ja_JA.all.json":   &bintree{wski18nResourcesJa_jaAllJson, map[string]*bintree{}},
			"ko_KR.all.json":   &bintree{wski18nResourcesKo_krAllJson, map[string]*bintree{}},
			"pt_BR.all.json":   &bintree{wski18nResourcesPt_brAllJson, map[string]*bintree{}},
			"zh_Hans.all.json": &bintree{wski18nResourcesZh_hansAllJson, map[string]*bintree{}},
			"zh_Hant.all.json": &bintree{wski18nResourcesZh_hantAllJson, map[string]*bintree{}},
		}},
	}},
}}

// RestoreAsset restores an asset under the given directory
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	err = os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
	if err != nil {
		return err
	}
	return nil
}

// RestoreAssets restores an asset under the given directory recursively
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(cannonicalName, "/")...)...)
}
