/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.primitivetype;

import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;

public final class EdmBoolean
extends SingletonPrimitiveType {
    private static final EdmBoolean INSTANCE = new EdmBoolean();

    public static EdmBoolean getInstance() {
        return INSTANCE;
    }

    @Override
    public Class<?> getDefaultType() {
        return Boolean.class;
    }

    @Override
    public boolean validate(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) {
        return value == null ? isNullable == null || isNullable.booleanValue() : EdmBoolean.validateLiteral(value);
    }

    private static boolean validateLiteral(String value) {
        return "true".equals(value) || "false".equals(value);
    }

    @Override
    protected <T> T internalValueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        if (EdmBoolean.validateLiteral(value)) {
            if (returnType.isAssignableFrom(Boolean.class)) {
                return returnType.cast("true".equals(value));
            }
            throw new EdmPrimitiveTypeException("The value type " + returnType + " is not supported.");
        }
        throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.");
    }

    @Override
    protected <T> String internalValueToString(T value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        if (value instanceof Boolean) {
            return Boolean.toString((Boolean)value);
        }
        throw new EdmPrimitiveTypeException("The value type " + value.getClass() + " is not supported.");
    }
}

