/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.ClientCsdlAnnotation;
import org.apache.olingo.client.core.edm.xml.ClientCsdlParameter;
import org.apache.olingo.commons.api.edm.provider.CsdlAction;

@JsonDeserialize(using=ActionDeserializer.class)
class ClientCsdlAction
extends CsdlAction
implements Serializable {
    private static final long serialVersionUID = 5321541275349234088L;

    ClientCsdlAction() {
    }

    static class ActionDeserializer
    extends AbstractClientCsdlEdmDeserializer<ClientCsdlAction> {
        ActionDeserializer() {
        }

        @Override
        protected ClientCsdlAction doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ClientCsdlAction action = new ClientCsdlAction();
            while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                JsonToken token = jp.getCurrentToken();
                if (token == JsonToken.FIELD_NAME) {
                    if ("Name".equals(jp.getCurrentName())) {
                        action.setName(jp.nextTextValue());
                    } else if ("IsBound".equals(jp.getCurrentName())) {
                        action.setBound(BooleanUtils.toBoolean(jp.nextTextValue()));
                    } else if ("EntitySetPath".equals(jp.getCurrentName())) {
                        action.setEntitySetPath(jp.nextTextValue());
                    } else if ("Parameter".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        action.getParameters().add(jp.readValueAs(ClientCsdlParameter.class));
                    } else if ("ReturnType".equals(jp.getCurrentName())) {
                        action.setReturnType(this.parseReturnType(jp, "Action"));
                    } else if ("Annotation".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        action.getAnnotations().add(jp.readValueAs(ClientCsdlAnnotation.class));
                    }
                }
                jp.nextToken();
            }
            return action;
        }
    }
}

